/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.build.gcc.core.internal.Activator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;

public class GCCToolChain
extends PlatformObject
implements IToolChain {
    private final IToolChainProvider provider;
    private final String id;
    private final String version;
    private final String name;
    private final Path[] path;
    private final String prefix;
    private final IEnvironmentVariable pathVar;
    private final IEnvironmentVariable[] envVars;
    private final Map<String, String> properties = new HashMap<String, String>();
    protected String[] compileCommands;

    public GCCToolChain(IToolChainProvider provider, String id, String version) {
        this(provider, id, version, null, null);
    }

    public GCCToolChain(IToolChainProvider provider, String id, String version, Path[] path) {
        this(provider, id, version, path, null);
    }

    public GCCToolChain(IToolChainProvider provider, String id, String version, Path[] path, String prefix) {
        this.provider = provider;
        this.id = id;
        this.version = version;
        this.name = String.valueOf(id) + " - " + version;
        this.path = path;
        this.prefix = prefix;
        if (path != null) {
            StringBuilder pathString = new StringBuilder();
            int i = 0;
            while (i < path.length) {
                pathString.append(path[i].toString());
                if (i < path.length - 1) {
                    pathString.append(File.pathSeparator);
                }
                ++i;
            }
            this.pathVar = new EnvironmentVariable("PATH", pathString.toString(), 3, File.pathSeparator);
            this.envVars = new IEnvironmentVariable[]{this.pathVar};
        } else {
            this.pathVar = null;
            this.envVars = new IEnvironmentVariable[0];
        }
    }

    public IToolChainProvider getProvider() {
        return this.provider;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if (value != null) {
            return value;
        }
        switch (key) {
            case "os": {
                return Platform.getOS();
            }
            case "arch": {
                return Platform.getOSArch();
            }
        }
        return null;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getBinaryParserId() {
        switch (Platform.getOS()) {
            case "win32": {
                return "org.eclipse.cdt.core.PE";
            }
            case "macosx": {
                return "org.eclipse.cdt.core.MachO64";
            }
        }
        return "org.eclipse.cdt.core.ELF";
    }

    protected void addDiscoveryOptions(List<String> command) {
        command.add("-E");
        command.add("-P");
        command.add("-v");
        command.add("-dD");
    }

    public IExtendedScannerInfo getScannerInfo(IBuildConfiguration buildConfig, Path command, String[] args, IExtendedScannerInfo baseScannerInfo, IResource resource, URI buildDirectoryURI) {
        try {
            Path buildDirectory = Paths.get(buildDirectoryURI);
            ArrayList<String> commandLine = new ArrayList<String>();
            if (command.isAbsolute()) {
                commandLine.add(command.toString());
            } else {
                commandLine.add(this.getCommandPath(command).toString());
            }
            if (baseScannerInfo != null && baseScannerInfo.getIncludePaths() != null) {
                String[] stringArray = baseScannerInfo.getIncludePaths();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String includePath = stringArray[n2];
                    commandLine.add("-I" + includePath);
                    ++n2;
                }
            }
            this.addDiscoveryOptions(commandLine);
            commandLine.addAll(Arrays.asList(args));
            boolean haveOut = false;
            int i = 0;
            while (i < commandLine.size() - 1) {
                if (((String)commandLine.get(i)).equals("-o")) {
                    commandLine.set(i + 1, "-");
                    haveOut = true;
                    break;
                }
                ++i;
            }
            if (!haveOut) {
                commandLine.add("-o");
                commandLine.add("-");
            }
            Path tmpFile = null;
            int i2 = 1;
            while (i2 < commandLine.size()) {
                if (!((String)commandLine.get(i2)).startsWith("-")) {
                    Path filePath = buildDirectory.resolve((String)commandLine.get(i2));
                    IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(filePath.toUri());
                    if (files.length > 0) {
                        Path parentPath = filePath.getParent();
                        String extension = files[0].getFileExtension();
                        extension = extension == null ? ".cpp" : String.valueOf('.') + extension;
                        tmpFile = Files.createTempFile(parentPath, ".sc", extension, new FileAttribute[0]);
                        commandLine.set(i2, tmpFile.toString());
                    }
                }
                ++i2;
            }
            if (tmpFile == null) {
                IPath parentPath = resource instanceof IFile ? resource.getParent().getLocation() : resource.getLocation();
                tmpFile = Files.createTempFile(parentPath.toFile().toPath(), ".sc", ".cpp", new FileAttribute[0]);
                commandLine.add(tmpFile.toString());
            }
            Files.createDirectories(buildDirectory, new FileAttribute[0]);
            ProcessBuilder processBuilder = new ProcessBuilder(commandLine).directory(buildDirectory.toFile()).redirectErrorStream(true);
            CCorePlugin.getDefault().getBuildEnvironmentManager().setEnvironment(processBuilder.environment(), buildConfig, true);
            Process process = processBuilder.start();
            HashMap<String, String> symbols = new HashMap<String, String>();
            ArrayList<String> includePath = new ArrayList<String>();
            Pattern definePattern = Pattern.compile("#define (.*)\\s(.*)");
            boolean inIncludePaths = false;
            Throwable throwable = null;
            Object var18_25 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    if (inIncludePaths) {
                        if (line.equals("End of search list.")) {
                            inIncludePaths = false;
                        } else {
                            includePath.add(line.trim());
                        }
                    } else if (line.startsWith("#define ")) {
                        Matcher matcher = definePattern.matcher(line);
                        if (matcher.matches()) {
                            symbols.put(matcher.group(1), matcher.group(2));
                        }
                    } else if (line.equals("#include <...> search starts here:")) {
                        inIncludePaths = true;
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
            Files.delete(tmpFile);
            return new ExtendedScannerInfo(symbols, includePath.toArray(new String[includePath.size()]));
        }
        catch (IOException e) {
            Activator.log(e);
            return null;
        }
    }

    public String[] getErrorParserIds() {
        return new String[]{"org.eclipse.cdt.core.GCCErrorParser", "org.eclipse.cdt.core.GASErrorParser", "org.eclipse.cdt.core.GLDErrorParser", "org.eclipse.cdt.core.GmakeErrorParser", "org.eclipse.cdt.core.CWDLocator"};
    }

    public IEnvironmentVariable getVariable(String name) {
        if (this.path != null && name.equals("PATH")) {
            return this.pathVar;
        }
        return null;
    }

    public IEnvironmentVariable[] getVariables() {
        return this.envVars;
    }

    public Path getCommandPath(Path command) {
        int n;
        if (command.isAbsolute()) {
            return command;
        }
        if (Platform.getOS().equals("win32") && !command.toString().endsWith(".exe")) {
            command = Paths.get(String.valueOf(command.toString()) + ".exe", new String[0]);
        }
        if (this.path != null) {
            Path[] pathArray = this.path;
            n = this.path.length;
            int n2 = 0;
            while (n2 < n) {
                Path p = pathArray[n2];
                Path c = p.resolve(command);
                if (Files.isExecutable(c)) {
                    return c;
                }
                ++n2;
            }
        }
        String path = System.getenv("PATH");
        String[] stringArray = path.split(File.pathSeparator);
        int n3 = stringArray.length;
        n = 0;
        while (n < n3) {
            String entry = stringArray[n];
            Path entryPath = Paths.get(entry, new String[0]);
            Path cmdPath = entryPath.resolve(command);
            if (Files.isExecutable(cmdPath)) {
                return cmdPath;
            }
            ++n;
        }
        return null;
    }

    public String[] getCompileCommands() {
        if (this.compileCommands == null) {
            ArrayList<String> cmds = new ArrayList<String>();
            String[] stringArray = new String[]{"gcc", "g++", "clang", "clang++"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cmd = stringArray[n2];
                cmd = this.prefix != null ? cmd : String.valueOf(this.prefix) + cmd;
                Path cmdPath = this.getCommandPath(Paths.get(cmd, new String[0]));
                if (cmdPath != null) {
                    cmds.add(cmd);
                }
                ++n2;
            }
            this.compileCommands = cmds.toArray(new String[this.compileCommands.length]);
        }
        return this.compileCommands;
    }

    public IResource[] getResourcesFromCommand(String[] cmd, URI buildDirectoryURI) {
        ArrayList<IFile> resources = new ArrayList<IFile>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = cmd.length - 1;
        while (i >= 0) {
            String arg = cmd[i];
            if (arg.startsWith("-")) break;
            IFile[] iFileArray = root.findFilesForLocationURI(buildDirectoryURI.resolve(arg));
            int n = iFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile resource = iFileArray[n2];
                resources.add(resource);
                ++n2;
            }
            --i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }
}

