/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.preferences;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.cdt.internal.qt.core.QtInstall;
import org.eclipse.cdt.internal.qt.ui.Messages;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewQtInstallWizardPage
extends WizardPage {
    private Text locationText;
    private Text specText;
    private final Map<Path, IQtInstall> existing;

    public NewQtInstallWizardPage(Map<Path, IQtInstall> existing) {
        super(Messages.NewQtInstallWizardPage_0, Messages.NewQtInstallWizardPage_1, null);
        this.existing = existing;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(comp, 0);
        nameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        nameLabel.setText(Messages.NewQtInstallWizardPage_2);
        Label locationLabel = new Label(comp, 0);
        locationLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        locationLabel.setText(Messages.NewQtInstallWizardPage_3);
        Composite locationComp = new Composite(comp, 0);
        locationComp.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        locationComp.setLayout((Layout)layout);
        this.locationText = new Text(locationComp, 2048);
        this.locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.locationText.addModifyListener(e -> this.validate());
        Button locationButton = new Button(locationComp, 8);
        locationButton.setLayoutData((Object)new GridData(4, 4, false, false));
        locationButton.setText(Messages.NewQtInstallWizardPage_4);
        locationButton.addListener(13, e -> {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setText(Messages.NewQtInstallWizardPage_5);
            dialog.setFilterExtensions(new String[]{Platform.getOS().equals("win32") ? Messages.NewQtInstallWizardPage_6 : Messages.NewQtInstallWizardPage_7});
            final String selected = dialog.open();
            if (selected != null) {
                this.locationText.setText(selected);
                new Job(Messages.NewQtInstallWizardPage_8){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            String spec = QtInstall.getSpec((Path)Paths.get(selected, new String[0]));
                            NewQtInstallWizardPage.this.getControl().getDisplay().asyncExec(() -> NewQtInstallWizardPage.this.specText.setText(spec));
                            return Status.OK_STATUS;
                        }
                        catch (IOException e) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                }.schedule();
            }
        });
        Label specLabel = new Label(comp, 0);
        specLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        specLabel.setText(Messages.NewQtInstallWizardPage_9);
        this.specText = new Text(comp, 2056);
        this.specText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setControl((Control)comp);
        this.validate();
    }

    private void validate() {
        this.setPageComplete(false);
        if (this.existing.containsKey(Paths.get(this.locationText.getText(), new String[0]))) {
            this.setErrorMessage(Messages.NewQtInstallWizardPage_11);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    IQtInstall getInstall() {
        return new QtInstall(Paths.get(this.locationText.getText(), new String[0]));
    }
}

