/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.qt.core.IQtBuildConfiguration;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.cdt.qt.core.IQtInstallManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class QtBuildConfiguration
extends CBuildConfiguration
implements ICBuildConfiguration,
IQtBuildConfiguration {
    private static final String QTINSTALL_NAME = "cdt.qt.install.name";
    private static final String LAUNCH_MODE = "cdt.qt.launchMode";
    private final IQtInstall qtInstall;
    private final String launchMode;
    private Map<String, String> properties;

    public QtBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        Preferences settings = this.getSettings();
        String installName = settings.get(QTINSTALL_NAME, "");
        if (!installName.isEmpty()) {
            IQtInstallManager manager = Activator.getService(IQtInstallManager.class);
            this.qtInstall = manager.getInstall(Paths.get(installName, new String[0]));
        } else {
            this.qtInstall = null;
        }
        this.launchMode = settings.get(LAUNCH_MODE, null);
    }

    QtBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, IQtInstall qtInstall, String launchMode) throws CoreException {
        super(config, name, toolChain);
        this.qtInstall = qtInstall;
        this.launchMode = launchMode;
        Preferences settings = this.getSettings();
        settings.put(QTINSTALL_NAME, qtInstall.getQmakePath().toString());
        if (launchMode != null) {
            settings.put(LAUNCH_MODE, launchMode);
        }
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)super.getAdapter(adapter);
    }

    public IQtInstall getQtInstall() {
        return this.qtInstall;
    }

    @Override
    public String getLaunchMode() {
        return this.launchMode;
    }

    @Override
    public Path getQmakeCommand() {
        return this.qtInstall.getQmakePath();
    }

    @Override
    public String[] getQmakeConfig() {
        block10: {
            if (this.launchMode == null) break block10;
            switch (this.launchMode) {
                case "run": {
                    return new String[]{"CONFIG-=debug_and_release", "CONFIG+=release"};
                }
                case "debug": {
                    return new String[]{"CONFIG-=debug_and_release", "CONFIG+=debug"};
                }
            }
            return new String[]{"CONFIG-=debug_and_release", "CONFIG+=launch_mode_" + this.launchMode};
        }
        return new String[]{"CONFIG+=debug_and_release", "CONFIG+=launch_modeall"};
    }

    public Path getProjectFile() {
        File projectDir = this.getProject().getLocation().toFile();
        File[] proFiles = projectDir.listFiles((dir, name) -> name.endsWith(".pro"));
        if (proFiles.length > 0) {
            return proFiles[0].toPath();
        }
        return null;
    }

    @Override
    public Path getProgramPath() throws CoreException {
        String projectName = this.getProject().getName();
        switch (Platform.getOS()) {
            case "macosx": {
                Path appFolder = this.getBuildDirectory().resolve(String.valueOf(projectName) + ".app");
                Path contentsFolder = appFolder.resolve("Contents");
                Path macosFolder = contentsFolder.resolve("MacOS");
                return macosFolder.resolve(projectName);
            }
            case "win32": {
                return this.getBuildDirectory().resolve(String.valueOf(projectName) + ".exe");
            }
            case "linux": {
                return this.getBuildDirectory().resolve(projectName);
            }
        }
        Path releaseFolder = this.getBuildDirectory().resolve("release");
        return releaseFolder.resolve(projectName);
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            String[] stringArray;
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getQmakeCommand().toString());
            cmd.add("-E");
            String[] config = this.getQmakeConfig();
            if (config != null) {
                stringArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    cmd.add(str);
                    ++n2;
                }
            }
            cmd.add(this.getProjectFile().toString());
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(cmd).directory(this.getProjectFile().getParent().toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process proc = processBuilder.start();
                Throwable throwable = null;
                stringArray = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                    this.properties = new HashMap<String, String>();
                    String line = reader.readLine();
                    while (line != null) {
                        int i = line.indexOf(61);
                        if (i >= 0) {
                            String k = line.substring(0, i);
                            String v = line.substring(i + 1);
                            this.properties.put(k.trim(), v.trim());
                        }
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return this.properties != null ? this.properties.get(key) : null;
    }

    public IEnvironmentVariable getVariable(String name) {
        return null;
    }

    public IEnvironmentVariable[] getVariables() {
        return new IEnvironmentVariable[0];
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        String srcFile;
        IQtInstall qtInstall = this.getQtInstall();
        String cxx = this.getProperty("QMAKE_CXX");
        if (cxx == null) {
            Activator.log("No QMAKE_CXX for " + qtInstall.getSpec());
            return null;
        }
        String[] cxxSplit = cxx.split(" ");
        Path command = Paths.get(cxxSplit[0], new String[0]);
        ArrayList<String> args = new ArrayList<String>();
        int i = 1;
        while (i < cxxSplit.length) {
            args.add(cxxSplit[i]);
            ++i;
        }
        args.addAll(Arrays.asList(this.getProperty("QMAKE_CXXFLAGS").split(" ")));
        args.add("-o");
        args.add("-");
        if (resource instanceof IFile) {
            srcFile = resource.getLocation().toOSString();
            args.add(srcFile);
        } else {
            srcFile = "scannerInfo.cpp";
        }
        String[] includePaths = this.getProperty("INCLUDEPATH").split(" ");
        int i2 = 0;
        while (i2 < includePaths.length) {
            Path path = Paths.get(includePaths[i2], new String[0]);
            if (!path.isAbsolute()) {
                try {
                    includePaths[i2] = this.getBuildDirectory().resolve(path).toString();
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            ++i2;
        }
        ExtendedScannerInfo baseScannerInfo = new ExtendedScannerInfo(null, includePaths);
        try {
            return this.getToolChain().getScannerInfo(this.getBuildConfiguration(), command, args.toArray(new String[args.size()]), (IExtendedScannerInfo)baseScannerInfo, resource, this.getBuildContainer().getLocationURI());
        }
        catch (CoreException e) {
            Activator.log(e);
            return null;
        }
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        Path makeCommand;
        ConsoleOutputStream outStream;
        IProject project;
        block16: {
            project = this.getProject();
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream errStream = console.getErrorStream();
            outStream = console.getOutputStream();
            makeCommand = this.getMakeCommand();
            if (makeCommand != null) break block16;
            errStream.write("'make' not found.\n");
            return null;
        }
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                Path buildDir = this.getBuildDirectory();
                if (!buildDir.resolve("Makefile").toFile().exists()) {
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(this.getQmakeCommand().toString());
                    String[] config = this.getQmakeConfig();
                    if (config != null) {
                        String[] stringArray = config;
                        int n = config.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String str = stringArray[n2];
                            command.add(str);
                            ++n2;
                        }
                    }
                    IFile projectFile = project.getFile(String.valueOf(project.getName()) + ".pro");
                    command.add(projectFile.getLocation().toOSString());
                    ProcessBuilder processBuilder = new ProcessBuilder(command).directory(this.getBuildDirectory().toFile());
                    this.setBuildEnvironment(processBuilder.environment());
                    Process process = processBuilder.start();
                    StringBuffer msg = new StringBuffer();
                    for (String arg : command) {
                        msg.append(arg).append(' ');
                    }
                    msg.append('\n');
                    outStream.write(msg.toString());
                    this.watchProcess(process, new IConsoleParser[0], console);
                }
                ProcessBuilder processBuilder = new ProcessBuilder(makeCommand.toString(), "all").directory(buildDir.toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process process = processBuilder.start();
                outStream.write(String.valueOf(makeCommand.toString()) + '\n');
                this.watchProcess(process, new IConsoleParser[]{epm}, console);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.getProject().refreshLocal(2, monitor);
            return new IProject[]{project};
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.qt.core", "Building " + project.getName(), (Throwable)e));
        }
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream errStream = console.getErrorStream();
            ConsoleOutputStream outStream = console.getOutputStream();
            Path makeCommand = this.getMakeCommand();
            if (makeCommand == null) {
                errStream.write("'make' not found.\n");
                return;
            }
            Path buildDir = this.getBuildDirectory();
            Throwable throwable = null;
            Object var9_11 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                ProcessBuilder processBuilder = new ProcessBuilder(makeCommand.toString(), "clean").directory(buildDir.toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process process = processBuilder.start();
                outStream.write(String.valueOf(makeCommand.toString()) + "clean\n");
                this.watchProcess(process, new IConsoleParser[]{epm}, console);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.qt.core", "Cleaning " + project.getName(), (Throwable)e));
        }
    }

    public Path getMakeCommand() {
        Path makeCommand = this.findCommand("make");
        if (makeCommand == null) {
            makeCommand = this.findCommand("mingw32-make");
        }
        return makeCommand;
    }
}

