/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.launch;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.GdbSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.launching.ServicesLaunchSequence;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.qt.core.IQtBuildConfiguration;
import org.eclipse.cdt.qt.core.QtLaunchConfigurationDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.ITargetedLaunch;

public class QtLocalDebugLaunchConfigDelegate
extends QtLaunchConfigurationDelegate {
    public ITargetedLaunch getLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target) throws CoreException {
        GdbLaunch launch = new GdbLaunch(configuration, mode, null);
        launch.setLaunchTarget(target);
        launch.initialize();
        GdbSourceLookupDirector locator = new GdbSourceLookupDirector(launch.getSession());
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento == null) {
            locator.initializeDefaults(configuration);
        } else {
            locator.initializeFromMemento(memento, configuration);
        }
        launch.setSourceLocator((ISourceLocator)locator);
        return launch;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, final IProgressMonitor monitor) throws CoreException {
        final GdbLaunch gdbLaunch = (GdbLaunch)launch;
        ILaunchTarget target = ((ITargetedLaunch)launch).getLaunchTarget();
        IQtBuildConfiguration qtBuildConfig = this.getQtBuildConfiguration(configuration, mode, target, monitor);
        IToolChain toolChain = qtBuildConfig.getToolChain();
        gdbLaunch.setGDBPath(toolChain.getCommandPath(Paths.get("gdb", new String[0])).toString());
        String gdbVersion = gdbLaunch.getGDBVersion();
        Path exeFile = qtBuildConfig.getProgramPath();
        gdbLaunch.setProgramPath(exeFile.toString());
        gdbLaunch.setServiceFactory((IDsfDebugServicesFactory)new GdbDebugServicesFactory(gdbVersion, configuration));
        ServicesLaunchSequence servicesLaunchSequence = new ServicesLaunchSequence(gdbLaunch.getSession(), gdbLaunch, monitor);
        gdbLaunch.getSession().getExecutor().execute((Runnable)servicesLaunchSequence);
        try {
            servicesLaunchSequence.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.qt.core", "Failure launching with gdb", (Throwable)e));
        }
        gdbLaunch.initializeControl();
        gdbLaunch.addCLIProcess(String.valueOf(gdbLaunch.getGDBPath().toOSString()) + " (" + gdbVersion + ")");
        Query<Object> ready = new Query<Object>(){

            protected void execute(final DataRequestMonitor<Object> rm) {
                DsfServicesTracker tracker = new DsfServicesTracker(Activator.getDefault().getBundle().getBundleContext(), gdbLaunch.getSession().getId());
                IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                tracker.dispose();
                control.completeInitialization((RequestMonitor)new RequestMonitorWithProgress(ImmediateExecutor.getInstance(), monitor){

                    protected void handleCompleted() {
                        if (this.isCanceled()) {
                            rm.cancel();
                        } else {
                            rm.setStatus(this.getStatus());
                        }
                        rm.done();
                    }
                });
            }
        };
        gdbLaunch.getSession().getExecutor().execute((Runnable)ready);
        try {
            ready.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.qt.core", "Failure to start debug session", (Throwable)e));
        }
    }
}

