/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.downloads;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.FormTextHoverManager;
import org.eclipse.cdt.arduino.ui.internal.downloads.SelectLibrariesDialog;
import org.eclipse.cdt.arduino.ui.internal.downloads.UpdateLibrariesDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class LibrariesTabControl
extends Composite {
    private ArduinoManager manager = Activator.getService(ArduinoManager.class);
    private Table table;
    private IWizardContainer container;
    private Collection<ArduinoLibrary> availableLibraries;

    public LibrariesTabControl(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Text desc = new Text((Composite)this, 72);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = 500;
        desc.setLayoutData((Object)layoutData);
        desc.setBackground(parent.getBackground());
        desc.setText("Installed Platforms. Details available in their tooltips");
        Composite comp = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(tableComp, 68098);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn packageColumn = new TableColumn(this.table, 16384);
        packageColumn.setText("Library");
        tableLayout.setColumnData((Widget)packageColumn, (ColumnLayoutData)new ColumnWeightData(5, 150, true));
        TableColumn platformColumn = new TableColumn(this.table, 16384);
        platformColumn.setText("Version");
        tableLayout.setColumnData((Widget)platformColumn, (ColumnLayoutData)new ColumnWeightData(2, 75, true));
        TableColumn versionColumn = new TableColumn(this.table, 16384);
        versionColumn.setText("Description");
        tableLayout.setColumnData((Widget)versionColumn, (ColumnLayoutData)new ColumnWeightData(5, 150, true));
        tableComp.setLayout((Layout)tableLayout);
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        buttonComp.setLayoutData((Object)new GridData(1, 1, false, false));
        final Button uninstallButton = new Button(buttonComp, 8);
        uninstallButton.setLayoutData((Object)new GridData(4, 1, true, false));
        uninstallButton.setText("Uninstall");
        uninstallButton.setEnabled(false);
        uninstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrariesTabControl.this.uninstall();
            }
        });
        Button updatesButton = new Button(buttonComp, 8);
        updatesButton.setLayoutData((Object)new GridData(4, 1, true, false));
        updatesButton.setText("Updates");
        updatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrariesTabControl.this.checkForUpdates();
            }
        });
        Button addButton = new Button(buttonComp, 8);
        addButton.setLayoutData((Object)new GridData(4, 1, true, false));
        addButton.setText("Add");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrariesTabControl.this.addLibraries();
            }
        });
        this.populateTable();
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = LibrariesTabControl.this.table.getSelection();
                uninstallButton.setEnabled(selection.length > 0);
            }
        });
        FormTextHoverManager hoverManager = new FormTextHoverManager(){

            protected void computeInformation() {
                TableItem item = LibrariesTabControl.this.table.getItem(this.getHoverEventLocation());
                if (item != null) {
                    ArduinoLibrary library = (ArduinoLibrary)item.getData();
                    this.setInformation(library.toFormText(), item.getBounds());
                } else {
                    this.setInformation(null, null);
                }
            }
        };
        hoverManager.install((Control)this.table);
    }

    public void setContainer(IWizardContainer container) {
        this.container = container;
    }

    private void populateTable() {
        this.table.removeAll();
        try {
            ArrayList libraries = new ArrayList(this.manager.getInstalledLibraries());
            Collections.sort(libraries, new Comparator<ArduinoLibrary>(){

                @Override
                public int compare(ArduinoLibrary o1, ArduinoLibrary o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (ArduinoLibrary library : libraries) {
                TableItem item = new TableItem(this.table, 0);
                item.setData((Object)library);
                item.setText(0, library.getName());
                item.setText(1, library.getVersion());
                item.setText(2, library.getSentence());
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    private void uninstall() {
        ArrayList<ArduinoLibrary> selectedLibraries = new ArrayList<ArduinoLibrary>(this.table.getSelectionCount());
        TableItem[] tableItemArray = this.table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            selectedLibraries.add((ArduinoLibrary)item.getData());
            ++n2;
        }
        try {
            this.container.run(true, true, monitor -> {
                try {
                    this.manager.uninstallLibraries((Collection)selectedLibraries, monitor);
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
            return;
        }
        this.populateTable();
    }

    private void checkForUpdates() {
        Collection<ArduinoLibrary> toUpdate;
        ArrayList<ArduinoLibrary> updates = new ArrayList<ArduinoLibrary>();
        try {
            this.container.run(true, true, monitor -> {
                try {
                    for (ArduinoLibrary available : this.manager.getAvailableLibraries(monitor)) {
                        ArduinoLibrary installed = this.manager.getInstalledLibrary(available.getName());
                        if (installed == null || ArduinoManager.compareVersions((String)available.getVersion(), (String)installed.getVersion()) <= 0) continue;
                        updates.add(available);
                    }
                }
                catch (CoreException e) {
                    this.getDisplay().syncExec(() -> {
                        int n = ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
                    });
                    Activator.log((Exception)((Object)e));
                }
            });
            if (updates.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Library Updates", (String)"All libraries are up to date");
                return;
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
            return;
        }
        if (updates.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Platform Updates", (String)"All platforms are up to date");
            return;
        }
        UpdateLibrariesDialog updateDialog = new UpdateLibrariesDialog(this.getShell(), updates);
        if (updateDialog.open() == 0 && !(toUpdate = updateDialog.getSelectedLibraries()).isEmpty()) {
            try {
                this.container.run(true, true, monitor -> {
                    try {
                        this.manager.installLibraries(toUpdate, monitor);
                    }
                    catch (CoreException e) {
                        this.getDisplay().syncExec(() -> {
                            int n = ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
                        });
                        Activator.log((Exception)((Object)e));
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                Activator.log(e);
            }
            this.populateTable();
        }
    }

    private void addLibraries() {
        try {
            this.container.run(true, true, monitor -> {
                try {
                    this.availableLibraries = this.manager.getAvailableLibraries(monitor);
                }
                catch (CoreException e) {
                    this.getDisplay().syncExec(() -> {
                        int n = ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
                    });
                    Activator.log((Exception)((Object)e));
                }
            });
            SelectLibrariesDialog selectDialog = new SelectLibrariesDialog(this.getShell());
            selectDialog.setLibraries(this.availableLibraries);
            if (selectDialog.open() == 0) {
                Collection<ArduinoLibrary> selectedLibraries = selectDialog.getChecked();
                this.container.run(true, true, monitor -> {
                    try {
                        this.manager.installLibraries(selectedLibraries, monitor);
                    }
                    catch (CoreException e) {
                        Activator.log((Exception)((Object)e));
                    }
                });
            }
            this.populateTable();
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
            return;
        }
    }
}

