/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.arduino.core.internal.HierarchicalProperties;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BoardPropertyControl
extends Composite {
    private Combo portCombo;
    private String[] portNames;
    private String portName;
    private Combo boardCombo;
    private ArduinoBoard[] boards;
    private ArduinoBoard board;
    private List<SelectionListener> listeners = Collections.synchronizedList(new ArrayList());
    private List<Control> menuControls = new ArrayList<Control>();

    public BoardPropertyControl(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label portLabel = new Label((Composite)this, 0);
        portLabel.setText(Messages.NewArduinoTargetWizardPage_4);
        this.portCombo = new Combo((Composite)this, 0);
        this.portCombo.setLayoutData((Object)new GridData(768));
        try {
            this.portNames = SerialPort.list();
        }
        catch (IOException e) {
            this.portNames = new String[0];
            Activator.log(e);
        }
        String[] stringArray = this.portNames;
        int n = this.portNames.length;
        int n2 = 0;
        while (n2 < n) {
            String portName = stringArray[n2];
            this.portCombo.add(portName);
            ++n2;
        }
        if (this.portNames.length > 0) {
            this.portCombo.select(0);
            this.portName = this.portNames[0];
        } else {
            this.portName = "";
        }
        this.portCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BoardPropertyControl.this.portName = BoardPropertyControl.this.portCombo.getText();
                BoardPropertyControl.this.fireSelection();
            }
        });
        Label boardLabel = new Label((Composite)this, 0);
        boardLabel.setText(Messages.ArduinoTargetPropertyPage_2);
        this.boardCombo = new Combo((Composite)this, 8);
        this.boardCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        try {
            ArrayList boardList = new ArrayList(Activator.getService(ArduinoManager.class).getInstalledBoards());
            Collections.sort(boardList, new Comparator<ArduinoBoard>(){

                @Override
                public int compare(ArduinoBoard o1, ArduinoBoard o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            ArduinoBoard[] arduinoBoardArray = this.boards = boardList.toArray(new ArduinoBoard[boardList.size()]);
            int n3 = this.boards.length;
            int n4 = 0;
            while (n4 < n3) {
                ArduinoBoard board = arduinoBoardArray[n4];
                this.boardCombo.add(board.getName());
                ++n4;
            }
            this.boardCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BoardPropertyControl.this.boardChanged();
                    BoardPropertyControl.this.fireSelection();
                }
            });
            if (this.boards.length > 0) {
                this.boardCombo.select(0);
                this.board = this.boards[0];
                this.updateBoardMenu();
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    public String getPortName() {
        return this.portName;
    }

    public ArduinoBoard getSelectedBoard() {
        return this.board;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    private void updateBoardMenu() {
        HierarchicalProperties menus = this.board.getMenus();
        if (menus != null) {
            for (Map.Entry menuEntry : menus.getChildren().entrySet()) {
                Label label = new Label((Composite)this, 0);
                label.setText(String.valueOf(this.board.getPlatform().getMenuText((String)menuEntry.getKey())) + ':');
                label.setData(menuEntry.getKey());
                this.menuControls.add((Control)label);
                Combo combo = new Combo((Composite)this, 8);
                combo.setLayoutData((Object)new GridData(4, 4, true, false));
                this.menuControls.add((Control)combo);
                ArrayList<String> ids = new ArrayList<String>();
                for (Map.Entry valueEntry : ((HierarchicalProperties)menuEntry.getValue()).getChildren().entrySet()) {
                    String value = ((HierarchicalProperties)valueEntry.getValue()).getValue();
                    if (value == null) continue;
                    combo.add(value);
                    ids.add((String)valueEntry.getKey());
                }
                combo.setData(ids);
                combo.select(0);
            }
        }
    }

    private void boardChanged() {
        ArduinoBoard newBoard;
        int index = this.boardCombo.getSelectionIndex();
        ArduinoBoard arduinoBoard = newBoard = index < 0 ? null : this.boards[index];
        if (newBoard != this.board) {
            for (Control control : this.menuControls) {
                control.dispose();
            }
            this.menuControls.clear();
            this.board = newBoard;
            this.updateBoardMenu();
            this.layout();
            this.getShell().pack();
            this.redraw();
        }
    }

    private void fireSelection() {
        for (SelectionListener listener : this.listeners) {
            Event event = new Event();
            event.widget = this;
            listener.widgetSelected(new SelectionEvent(event));
        }
    }

    public void apply(IRemoteConnectionWorkingCopy workingCopy) {
        ArduinoRemoteConnection.setBoardId((IRemoteConnectionWorkingCopy)workingCopy, (ArduinoBoard)this.board);
        ArduinoRemoteConnection.setPortName((IRemoteConnectionWorkingCopy)workingCopy, (String)this.portName);
        String key = null;
        for (Control control : this.menuControls) {
            if (control instanceof Label) {
                key = (String)control.getData();
                continue;
            }
            if (!(control instanceof Combo)) continue;
            Combo combo = (Combo)control;
            String value = (String)((List)combo.getData()).get(combo.getSelectionIndex());
            if (key == null) continue;
            ArduinoRemoteConnection.setMenuValue((IRemoteConnectionWorkingCopy)workingCopy, (String)key, (String)value);
        }
    }
}

