/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class ArduinoPreferences {
    private static final String ARDUINO_HOME = "arduinoHome";
    private static final String BOARD_URLS = "boardUrls";
    private static final String defaultHome = Paths.get(System.getProperty("user.home"), ".arduinocdt").toString();
    private static final String defaultBoardUrls = "http://downloads.arduino.cc/packages/package_index.json\nhttp://arduino.esp8266.com/stable/package_esp8266com_index.json\nhttps://adafruit.github.io/arduino-board-index/package_adafruit_index.json";

    private static IEclipsePreferences getPrefs() {
        return InstanceScope.INSTANCE.getNode(Activator.getId());
    }

    public static Path getArduinoHome() {
        return Paths.get(ArduinoPreferences.getPrefs().get(ARDUINO_HOME, defaultHome), new String[0]);
    }

    public static void setArduinoHome(Path home) {
        ArduinoPreferences.getPrefs().put(ARDUINO_HOME, home.toString());
    }

    public static String getBoardUrls() {
        return ArduinoPreferences.getPrefs().get(BOARD_URLS, defaultBoardUrls);
    }

    public static URL[] getBoardUrlList() throws CoreException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        String[] stringArray = ArduinoPreferences.getBoardUrls().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            try {
                urlList.add(new URL(url.trim()));
            }
            catch (MalformedURLException e) {
                throw Activator.coreException(e);
            }
            ++n2;
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public static void setBoardUrls(String boardUrls) {
        IEclipsePreferences prefs = ArduinoPreferences.getPrefs();
        prefs.put(BOARD_URLS, boardUrls);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    public static void setBoardUrlList(URL[] urls) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < urls.length - 1) {
            str.append(urls[i].toString());
            str.append('\n');
            ++i;
        }
        if (urls.length > 0) {
            str.append(urls[urls.length - 1].toString());
        }
        ArduinoPreferences.setBoardUrls(str.toString());
    }

    public static String getDefaultArduinoHome() {
        return defaultHome;
    }

    public static String getDefaultBoardUrls() {
        return defaultBoardUrls;
    }
}

