/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoHelp;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;
import org.eclipse.core.runtime.CoreException;

public class ArduinoPackage {
    private String name;
    private String maintainer;
    private String websiteURL;
    private String email;
    private ArduinoHelp help;
    private List<ArduinoPlatform> platforms;
    private List<ArduinoTool> tools;
    private Map<String, ArduinoPlatform> installedPlatforms;

    public String getName() {
        return this.name;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getWebsiteURL() {
        return this.websiteURL;
    }

    public String getEmail() {
        return this.email;
    }

    public ArduinoHelp getHelp() {
        return this.help;
    }

    public Collection<ArduinoPlatform> getPlatforms() {
        return Collections.unmodifiableCollection(this.platforms);
    }

    void init() {
        for (ArduinoPlatform platform : this.platforms) {
            platform.init(this);
        }
        for (ArduinoTool tool : this.tools) {
            tool.init(this);
        }
    }

    public ArduinoPlatform getPlatform(String architecture, String version) {
        if (this.platforms != null) {
            for (ArduinoPlatform plat : this.platforms) {
                if (!plat.getArchitecture().equals(architecture) || !plat.getVersion().equals(version)) continue;
                return plat;
            }
        }
        return null;
    }

    public Path getInstallPath() {
        return ArduinoPreferences.getArduinoHome().resolve("packages").resolve(this.getName());
    }

    private void initInstalledPlatforms() throws CoreException {
        if (this.installedPlatforms == null) {
            this.installedPlatforms = new HashMap<String, ArduinoPlatform>();
            if (Files.isDirectory(this.getInstallPath(), new LinkOption[0])) {
                Path platformTxt = Paths.get("platform.txt", new String[0]);
                try {
                    Path hardware = this.getInstallPath().resolve("hardware");
                    if (Files.exists(hardware, new LinkOption[0])) {
                        Files.find(hardware, 2, (path2, attrs) -> path2.getFileName().equals(platformTxt), new FileVisitOption[0]).forEach(path -> {
                            try {
                                Throwable throwable = null;
                                Object var3_5 = null;
                                try (FileReader reader = new FileReader(path.toFile());){
                                    Properties platformProperties = new Properties();
                                    platformProperties.load(reader);
                                    String arch = path.getName(path.getNameCount() - 2).toString();
                                    String version = platformProperties.getProperty("version");
                                    ArduinoPlatform platform = this.getPlatform(arch, version);
                                    if (platform != null) {
                                        platform.setPlatformProperties(platformProperties);
                                        this.installedPlatforms.put(arch, platform);
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    throw Activator.coreException(e);
                }
            }
        }
    }

    public Collection<ArduinoPlatform> getInstalledPlatforms() throws CoreException {
        this.initInstalledPlatforms();
        return this.installedPlatforms.values();
    }

    public ArduinoPlatform getInstalledPlatform(String architecture) throws CoreException {
        if (architecture == null) {
            return null;
        }
        this.initInstalledPlatforms();
        return this.installedPlatforms.get(architecture);
    }

    void platformInstalled(ArduinoPlatform platform) {
        this.installedPlatforms.put(platform.getArchitecture(), platform);
    }

    void platformUninstalled(ArduinoPlatform platform) {
        this.installedPlatforms.remove(platform.getArchitecture());
    }

    public Collection<ArduinoPlatform> getAvailablePlatforms() throws CoreException {
        this.initInstalledPlatforms();
        HashMap<String, ArduinoPlatform> platformMap = new HashMap<String, ArduinoPlatform>();
        for (ArduinoPlatform platform : this.platforms) {
            ArduinoPlatform p;
            if (this.installedPlatforms.containsKey(platform.getArchitecture()) || (p = (ArduinoPlatform)platformMap.get(platform.getName())) != null && ArduinoManager.compareVersions(platform.getVersion(), p.getVersion()) <= 0) continue;
            platformMap.put(platform.getName(), platform);
        }
        return platformMap.values();
    }

    public List<ArduinoTool> getTools() {
        return this.tools;
    }

    public ArduinoTool getTool(String toolName, String version) {
        for (ArduinoTool tool : this.tools) {
            if (!tool.getName().equals(toolName) || !tool.getVersion().equals(version)) continue;
            return tool;
        }
        return null;
    }

    public ArduinoTool getLatestTool(String toolName) {
        ArduinoTool latest = null;
        for (ArduinoTool tool : this.tools) {
            if (!tool.getName().equals(toolName) || !tool.isInstalled() || latest != null && ArduinoManager.compareVersions(tool.getVersion(), latest.getVersion()) <= 0) continue;
            latest = tool;
        }
        return latest;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArduinoPackage) {
            return ((ArduinoPackage)obj).getName().equals(this.name);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

