/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.launch;

import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.qt.core.IQtBuildConfiguration;
import org.eclipse.cdt.qt.core.QtLaunchConfigurationDelegate;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.ITargetedLaunch;

public class QtLocalRunLaunchConfigDelegate
extends QtLaunchConfigurationDelegate {
    public static final String TYPE_ID = "org.eclipse.cdt.qt.core.launchConfigurationType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchTarget target = ((ITargetedLaunch)launch).getLaunchTarget();
        IQtBuildConfiguration qtBuildConfig = this.getQtBuildConfiguration(configuration, mode, target, monitor);
        IBuildConfiguration buildConfig = qtBuildConfig.getBuildConfiguration();
        ProcessBuilder processBuilder = new ProcessBuilder(qtBuildConfig.getProgramPath().toString()).directory(buildConfig.getProject().getLocation().toFile());
        Map<String, String> env = processBuilder.environment();
        IEnvironmentVariable[] iEnvironmentVariableArray = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(qtBuildConfig.getBuildConfiguration(), true);
        int n = iEnvironmentVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            env.put(var.getName(), var.getValue());
            ++n2;
        }
        Map configEnv = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        if (configEnv != null) {
            for (Map.Entry entry : configEnv.entrySet()) {
                env.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        try {
            Process process = processBuilder.start();
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)qtBuildConfig.getProgramPath().toString());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.qt.core", "Launching", (Throwable)e));
        }
    }
}

