/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionPropertyService;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.serial.core.SerialPortCommandShell;

public class ArduinoRemoteConnection
implements IRemoteConnectionPropertyService,
IRemoteCommandShellService,
IRemoteConnectionChangeListener {
    public static final String TYPE_ID = "org.eclipse.cdt.arduino.core.connectionType";
    private static final String PORT_NAME = "arduinoPortName";
    private static final String PACKAGE_NAME = "arduinoPackageName";
    private static final String PLATFORM_NAME = "arduinoPlatformName";
    private static final String BOARD_NAME = "arduinoBoardName";
    private static final String MENU_QUALIFIER = "menu_";
    private final IRemoteConnection remoteConnection;
    private SerialPort serialPort;
    private SerialPortCommandShell commandShell;
    private static final Map<IRemoteConnection, ArduinoRemoteConnection> connectionMap = new HashMap<IRemoteConnection, ArduinoRemoteConnection>();

    public ArduinoRemoteConnection(IRemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        remoteConnection.addConnectionChangeListener((IRemoteConnectionChangeListener)this);
    }

    public static void setBoardId(IRemoteConnectionWorkingCopy workingCopy, ArduinoBoard board) {
        workingCopy.setAttribute(BOARD_NAME, board.getId());
        ArduinoPlatform platform = board.getPlatform();
        workingCopy.setAttribute(PLATFORM_NAME, platform.getArchitecture());
        ArduinoPackage pkg = platform.getPackage();
        workingCopy.setAttribute(PACKAGE_NAME, pkg.getName());
    }

    public static void setPortName(IRemoteConnectionWorkingCopy workingCopy, String portName) {
        workingCopy.setAttribute(PORT_NAME, portName);
    }

    public static void setMenuValue(IRemoteConnectionWorkingCopy workingCopy, String key, String value) {
        workingCopy.setAttribute(MENU_QUALIFIER + key, value);
    }

    public String getMenuValue(String key) {
        return this.remoteConnection.getAttribute(MENU_QUALIFIER + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionChanged(RemoteConnectionChangeEvent event) {
        if (event.getType() == 32) {
            Map<IRemoteConnection, ArduinoRemoteConnection> map = connectionMap;
            synchronized (map) {
                connectionMap.remove(event.getConnection());
            }
        }
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public String getProperty(String key) {
        if ("os.name".equals(key)) {
            return "arduino";
        }
        if ("os.arch".equals(key)) {
            return "avr";
        }
        return null;
    }

    public ArduinoBoard getBoard() throws CoreException {
        return Activator.getService(ArduinoManager.class).getBoard(this.remoteConnection.getAttribute(PACKAGE_NAME), this.remoteConnection.getAttribute(PLATFORM_NAME), this.remoteConnection.getAttribute(BOARD_NAME));
    }

    public String getPortName() {
        return this.remoteConnection.getAttribute(PORT_NAME);
    }

    public IRemoteProcess getCommandShell(int flags) throws IOException {
        if (this.serialPort != null && this.serialPort.isOpen()) {
            return null;
        }
        this.serialPort = new SerialPort(this.getPortName());
        this.commandShell = new SerialPortCommandShell(this.remoteConnection, this.serialPort);
        return this.commandShell;
    }

    public void pause() {
        if (this.serialPort != null) {
            try {
                if (this.serialPort.isOpen()) {
                    this.serialPort.pause();
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }

    public void resume() {
        if (this.serialPort != null) {
            try {
                if (this.serialPort.isOpen()) {
                    this.serialPort.resume();
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (ArduinoRemoteConnection.class.equals(service)) {
                Map map = connectionMap;
                synchronized (map) {
                    ArduinoRemoteConnection connection = (ArduinoRemoteConnection)connectionMap.get(remoteConnection);
                    if (connection == null) {
                        connection = new ArduinoRemoteConnection(remoteConnection);
                        connectionMap.put(remoteConnection, connection);
                    }
                    return (T)connection;
                }
            }
            if (IRemoteConnectionPropertyService.class.equals(service) || IRemoteCommandShellService.class.equals(service)) {
                return (T)remoteConnection.getService(ArduinoRemoteConnection.class);
            }
            return null;
        }
    }
}

