/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class CBuildConfiguration
extends PlatformObject
implements ICBuildConfiguration,
IMarkerGenerator,
IConsoleParser {
    private static final String TOOLCHAIN_TYPE = "cdt.toolChain.type";
    private static final String TOOLCHAIN_ID = "cdt.toolChain.id";
    private static final String TOOLCHAIN_VERSION = "cdt.toolChain.version";
    private final String name;
    private final IBuildConfiguration config;
    private final IToolChain toolChain;
    private Map<IResource, IExtendedScannerInfo> cheaterInfo;
    private boolean infoChanged = false;

    protected CBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        this.config = config;
        this.name = name;
        Preferences settings = this.getSettings();
        String typeId = settings.get(TOOLCHAIN_TYPE, "");
        String id = settings.get(TOOLCHAIN_ID, "");
        String version = settings.get(TOOLCHAIN_VERSION, "");
        IToolChainManager toolChainManager = CCorePlugin.getService(IToolChainManager.class);
        IToolChain tc = toolChainManager.getToolChain(typeId, id, version);
        if (tc == null) {
            Collection<IToolChain> tcs = toolChainManager.getToolChains(typeId, id);
            if (!tcs.isEmpty()) {
                tc = tcs.iterator().next();
            } else {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", String.format("Toolchain missing for config: %s", config.getName())));
            }
        }
        this.toolChain = tc;
    }

    protected CBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        this.config = config;
        this.name = name;
        this.toolChain = toolChain;
        Preferences settings = this.getSettings();
        settings.put(TOOLCHAIN_TYPE, toolChain.getProvider().getId());
        settings.put(TOOLCHAIN_ID, toolChain.getId());
        settings.put(TOOLCHAIN_VERSION, toolChain.getVersion());
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
    }

    protected CBuildConfiguration(IBuildConfiguration config, IToolChain toolChain) {
        this(config, "default", toolChain);
    }

    @Override
    public IBuildConfiguration getBuildConfiguration() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public IProject getProject() {
        return this.config.getProject();
    }

    @Override
    public String getBinaryParserId() throws CoreException {
        return this.toolChain != null ? this.toolChain.getBinaryParserId() : "org.eclipse.cdt.core.ELF";
    }

    public IContainer getBuildContainer() throws CoreException {
        IFolder buildFolder;
        IFolder buildRootFolder = this.getProject().getFolder("build");
        if (!buildRootFolder.exists()) {
            buildRootFolder.create(1025, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(buildFolder = buildRootFolder.getFolder(this.name)).exists()) {
            buildFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            buildFolder.setDerived(true, null);
            ICProject cproject = CoreModel.getDefault().create(this.getProject());
            IOutputEntry output = CoreModel.newOutputEntry(buildFolder.getFullPath());
            IPathEntry[] oldEntries = cproject.getRawPathEntries();
            IPathEntry[] newEntries = new IPathEntry[oldEntries.length + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
            newEntries[oldEntries.length] = output;
            cproject.setRawPathEntries(newEntries, null);
        }
        return buildFolder;
    }

    public URI getBuildDirectoryURI() throws CoreException {
        return this.getBuildContainer().getLocationURI();
    }

    public Path getBuildDirectory() throws CoreException {
        return Paths.get(this.getBuildDirectoryURI());
    }

    public void setBuildEnvironment(Map<String, String> env) {
        CCorePlugin.getDefault().getBuildEnvironmentManager().setEnvironment(env, this.config, true);
    }

    public void setActive(IProgressMonitor monitor) throws CoreException {
        IProject project = this.config.getProject();
        if (this.config.equals(project.getActiveBuildConfig())) {
            return;
        }
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setActiveBuildConfig(this.config.getName());
        project.setDescription(projectDesc, monitor);
    }

    protected Preferences getSettings() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").node("config").node(this.getProject().getName()).node(this.config.getName());
    }

    @Override
    public IToolChain getToolChain() throws CoreException {
        return this.toolChain;
    }

    @Override
    public IEnvironmentVariable getVariable(String name) {
        return null;
    }

    @Override
    public IEnvironmentVariable[] getVariables() {
        return null;
    }

    @Override
    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        this.addMarker(new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar, null));
    }

    @Override
    public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
        try {
            Map<String, String> attributes;
            IMarker[] markers;
            IProject project = this.config.getProject();
            IResource markerResource = problemMarkerInfo.file;
            if (markerResource == null) {
                markerResource = project;
            }
            String externalLocation = null;
            if (problemMarkerInfo.externalPath != null && !problemMarkerInfo.externalPath.isEmpty()) {
                externalLocation = problemMarkerInfo.externalPath.toOSString();
            }
            IMarker[] iMarkerArray = markers = markerResource.findMarkers("org.eclipse.cdt.core.problem", true, 1);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                String extloc;
                IMarker m = iMarkerArray[n2];
                int line = m.getAttribute("lineNumber", -1);
                int sev = m.getAttribute("severity", -1);
                String msg = (String)m.getAttribute("message");
                if (line == problemMarkerInfo.lineNumber && sev == this.mapMarkerSeverity(problemMarkerInfo.severity) && msg.equals(problemMarkerInfo.description) && ((extloc = (String)m.getAttribute("problem.externalLocation")) == externalLocation || extloc != null && extloc.equals(externalLocation))) {
                    if (project == null || project.equals((Object)markerResource.getProject())) {
                        return;
                    }
                    String source = (String)m.getAttribute("sourceId");
                    if (project.getName().equals(source)) {
                        return;
                    }
                }
                ++n2;
            }
            String type = problemMarkerInfo.getType();
            if (type == null) {
                type = "org.eclipse.cdt.core.problem";
            }
            IMarker marker = markerResource.createMarker(type);
            marker.setAttribute("message", (Object)problemMarkerInfo.description);
            marker.setAttribute("severity", this.mapMarkerSeverity(problemMarkerInfo.severity));
            marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
            marker.setAttribute("charStart", problemMarkerInfo.startChar);
            marker.setAttribute("charEnd", problemMarkerInfo.endChar);
            if (problemMarkerInfo.variableName != null) {
                marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
            }
            if (externalLocation != null) {
                URI uri = URIUtil.toURI((String)externalLocation);
                if (uri.getScheme() != null) {
                    marker.setAttribute("problem.externalLocation", (Object)externalLocation);
                    String locationText = NLS.bind((String)CCorePlugin.getResourceString("ACBuilder.ProblemsView.Location"), (Object)problemMarkerInfo.lineNumber, (Object)externalLocation);
                    marker.setAttribute("location", (Object)locationText);
                }
            } else if (problemMarkerInfo.lineNumber == 0) {
                marker.setAttribute("location", (Object)" ");
            }
            if (project != null && !project.equals((Object)markerResource.getProject())) {
                marker.setAttribute("sourceId", (Object)project.getName());
            }
            if ((attributes = problemMarkerInfo.getAttributes()) != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    marker.setAttribute(entry.getKey(), (Object)entry.getValue());
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    private int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    protected Path findCommand(String command) {
        String[] path;
        Path cmdPath;
        if (Platform.getOS().equals("win32") && !command.endsWith(".exe")) {
            command = String.valueOf(command) + ".exe";
        }
        if ((cmdPath = Paths.get(command, new String[0])).isAbsolute()) {
            return cmdPath;
        }
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        this.setBuildEnvironment(env);
        String[] stringArray = path = ((String)env.get("PATH")).split(File.pathSeparator);
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            Path commandPath = Paths.get(dir, command);
            if (Files.exists(commandPath, new LinkOption[0])) {
                return commandPath;
            }
            ++n2;
        }
        return null;
    }

    protected int watchProcess(Process process, IConsoleParser[] consoleParsers, IConsole console) throws CoreException {
        new ReaderThread(process.getInputStream(), consoleParsers, console.getOutputStream()).start();
        new ReaderThread(process.getErrorStream(), consoleParsers, console.getErrorStream()).start();
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            CCorePlugin.log(e);
            return -1;
        }
    }

    private void initScannerInfo() {
        if (this.cheaterInfo == null) {
            this.cheaterInfo = new HashMap<IResource, IExtendedScannerInfo>();
        }
    }

    @Override
    public IScannerInfo getScannerInformation(IResource resource) {
        this.initScannerInfo();
        return this.cheaterInfo.get(resource);
    }

    @Override
    public boolean processLine(String line) {
        String[] command = line.split("\\s+");
        boolean found = false;
        String[] compileCommands = this.toolChain.getCompileCommands();
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("-")) break;
            String[] stringArray2 = compileCommands;
            int n3 = compileCommands.length;
            int n4 = 0;
            while (n4 < n3) {
                String cc = stringArray2[n4];
                if (arg.equals(cc)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (!found) {
            return false;
        }
        try {
            IResource[] resources = this.toolChain.getResourcesFromCommand(command, this.getBuildDirectoryURI());
            if (resources != null) {
                IResource[] iResourceArray = resources;
                int n5 = resources.length;
                n = 0;
                while (n < n5) {
                    IResource resource = iResourceArray[n];
                    this.initScannerInfo();
                    this.cheaterInfo.put(resource, this.getToolChain().getScannerInfo(this.getBuildConfiguration(), this.findCommand(command[0]), Arrays.copyOfRange(command, 1, command.length), null, resource, this.getBuildDirectoryURI()));
                    this.infoChanged = true;
                    ++n;
                }
                return true;
            }
            return false;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public void shutdown() {
        if (this.infoChanged) {
            CCorePlugin.getIndexManager().reindex(CoreModel.getDefault().create(this.getProject()));
            this.infoChanged = false;
        }
    }

    @Override
    public void subscribe(IResource resource, IScannerInfoChangeListener listener) {
    }

    @Override
    public void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
    }

    private static class ReaderThread
    extends Thread {
        private final BufferedReader in;
        private final PrintStream out;
        private final IConsoleParser[] consoleParsers;

        public ReaderThread(InputStream in, IConsoleParser[] consoleParsers, OutputStream out) {
            this.in = new BufferedReader(new InputStreamReader(in));
            this.consoleParsers = consoleParsers;
            this.out = new PrintStream(out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String line = this.in.readLine();
                while (line != null) {
                    IConsoleParser[] iConsoleParserArray = this.consoleParsers;
                    int n = this.consoleParsers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConsoleParser consoleParser;
                        IConsoleParser iConsoleParser = consoleParser = iConsoleParserArray[n2];
                        synchronized (iConsoleParser) {
                            consoleParser.processLine(line);
                        }
                        ++n2;
                    }
                    this.out.println(line);
                    line = this.in.readLine();
                }
            }
            catch (IOException e) {
                CCorePlugin.log(e);
            }
        }
    }
}

