/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification.extension;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ObjectTypeBasedStorage;
import org.eclipse.core.runtime.IConfigurationElement;

public class MatchObjectElement {
    public static String ELEMENT_NAME = "matchObject";
    private static String ATTR_OBJECT_TYPE = "objectType";
    private static String ATTR_OBJECT_IDS = "objectIds";
    private static String ELEMENT_PATTERN = "pattern";
    private static String ATTR_PATTERN_TYPE_SEARCH_SCOPE = "searchScope";
    private static String ATTR_PATTERN_TYPE_ID_TYPE = "objectIdsType";
    private static String DELIMITER = ";";
    private int fObjectType;
    private PatternElement[] fPatterns;
    private int fHash;

    public MatchObjectElement(IConfigurationElement element) throws IllegalArgumentException {
        IConfigurationElement[] patternsChildren;
        TypeToStringAssociation assoc = TypeToStringAssociation.getAssociation(element.getAttribute(ATTR_OBJECT_TYPE));
        if (assoc == null) {
            throw new IllegalArgumentException();
        }
        this.fObjectType = assoc.getType();
        HashMap<PatternTypeKey, PatternElement> patternMap = new HashMap<PatternTypeKey, PatternElement>();
        int defaultSearchType = 1;
        int defaultIdType = 256;
        if (element.getAttribute(ATTR_OBJECT_IDS) != null) {
            PatternElement el = new PatternElement(element, defaultSearchType, defaultIdType);
            patternMap.put(new PatternTypeKey(el), el);
            defaultSearchType = el.getSearchType();
            defaultIdType = el.getIdType();
        }
        if ((patternsChildren = element.getChildren(ELEMENT_PATTERN)).length != 0) {
            int i = 0;
            while (i < patternsChildren.length) {
                PatternElement el = new PatternElement(patternsChildren[i], defaultSearchType, defaultIdType);
                PatternTypeKey key = new PatternTypeKey(el);
                PatternElement cur = (PatternElement)patternMap.get(key);
                if (cur != null) {
                    patternMap.put(key, cur.merge(el));
                } else {
                    patternMap.put(key, el);
                }
                ++i;
            }
        }
        if (patternMap.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.fPatterns = patternMap.values().toArray(new PatternElement[patternMap.size()]);
    }

    public int getObjectType() {
        return this.fObjectType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MatchObjectElement)) {
            return false;
        }
        MatchObjectElement other = (MatchObjectElement)obj;
        if (this.fObjectType != other.fObjectType) {
            return false;
        }
        return Arrays.equals(other.fPatterns, this.fPatterns);
    }

    public int hashCode() {
        if (this.fHash == 0) {
            int hash = this.fObjectType;
            int i = 0;
            while (i < this.fPatterns.length) {
                hash += this.fPatterns[i].hashCode();
                ++i;
            }
            this.fHash = hash;
        }
        return this.fHash;
    }

    public PatternElement[] getPatterns() {
        return (PatternElement[])this.fPatterns.clone();
    }

    public class PatternElement {
        private HashSet<String> fIds;
        private int fHashPE;
        private int fType;
        private static final int SEARCH_TYPE_MASK = 255;
        private static final int SEARCH_TYPE_OFFSET = 0;
        public static final int TYPE_SEARCH_EXTENSION_OBJECT = 1;
        public static final int TYPE_SEARCH_ALL_EXTENSION_SUPERCLASSES = 2;
        private static final int DEFAULT_PATTERN_SEARCH_TYPE = 1;
        private static final String EXTENSION_OBJECT = "EXTENSION_OBJECT";
        private static final String ALL_EXTENSION_SUPERCLASSES = "ALL_EXTENSION_SUPERCLASSES";
        private static final int ID_TYPE_MASK = 65280;
        private static final int ID_TYPE_OFFSET = 8;
        public static final int TYPE_ID_EXACT_MATCH = 256;
        public static final int TYPE_ID_REGEXP = 512;
        private static final int DEFAULT_PATTERN_ID_TYPE = 256;
        private static final String EXACT_MATCH = "EXACT_MATCH";
        private static final String REGEGP = "REGEXP";

        PatternElement(IConfigurationElement el, int defaultSearchType, int defaultIdType) {
            String tmp = el.getAttribute(ATTR_OBJECT_IDS);
            this.fIds = new HashSet<String>(Arrays.asList(CDataUtil.stringToArray((String)tmp, (String)DELIMITER)));
            int type = 0;
            tmp = el.getAttribute(ATTR_PATTERN_TYPE_SEARCH_SCOPE);
            if (tmp == null) {
                type = defaultSearchType;
            } else if (EXTENSION_OBJECT.equals(tmp)) {
                type = 1;
            } else if (ALL_EXTENSION_SUPERCLASSES.equals(tmp)) {
                type = 2;
            } else {
                throw new IllegalArgumentException();
            }
            tmp = el.getAttribute(ATTR_PATTERN_TYPE_ID_TYPE);
            if (tmp == null) {
                type |= defaultIdType;
            } else if (EXACT_MATCH.equals(tmp)) {
                type |= 0x100;
            } else if (REGEGP.equals(tmp)) {
                type |= 0x200;
            } else {
                throw new IllegalArgumentException();
            }
            this.fType = type;
        }

        private PatternElement(HashSet<String> ids, int type) {
            this.fIds = ids;
            this.fType = type;
        }

        public String[] getIds() {
            return this.fIds.toArray(new String[this.fIds.size()]);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PatternElement)) {
                return false;
            }
            PatternElement other = (PatternElement)obj;
            if (other.fIds.size() != this.fIds.size()) {
                return false;
            }
            return other.fIds.containsAll(this.fIds);
        }

        public int hashCode() {
            if (this.fHashPE == 0) {
                this.fHashPE = this.fIds.hashCode();
            }
            return this.fHashPE;
        }

        public PatternElement merge(PatternElement el) throws IllegalArgumentException {
            if (el.fType != this.fType) {
                throw new IllegalArgumentException();
            }
            HashSet<String> set = new HashSet<String>();
            set.addAll(this.fIds);
            set.addAll(el.fIds);
            return new PatternElement(set, this.fType);
        }

        public int getSearchType() {
            return this.fType & 0xFF;
        }

        public int getIdType() {
            return this.fType & 0xFF00;
        }

        public int getCompleteOredTypeValue() {
            return this.fType;
        }
    }

    private static class PatternTypeKey {
        private int fType;

        PatternTypeKey(PatternElement el) {
            this.fType = el.getCompleteOredTypeValue();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PatternTypeKey)) {
                return false;
            }
            return this.fType == ((PatternTypeKey)obj).fType;
        }

        public int hashCode() {
            return this.fType;
        }
    }

    public static class TypeToStringAssociation {
        private int fType;
        private String fString;
        private static ObjectTypeBasedStorage<TypeToStringAssociation> fTypeAssociationStorage = new ObjectTypeBasedStorage();
        private static Map<String, TypeToStringAssociation> fStringAssociationStorage = new HashMap<String, TypeToStringAssociation>();
        public static TypeToStringAssociation TOOL = new TypeToStringAssociation(2, "tool");
        public static TypeToStringAssociation TOOLCHAIN = new TypeToStringAssociation(1, "toolChain");
        public static TypeToStringAssociation CONFIGURATION = new TypeToStringAssociation(32, "configuration");
        public static TypeToStringAssociation BUILDER = new TypeToStringAssociation(4, "builder");

        private TypeToStringAssociation(int type, String string) {
            this.fType = type;
            this.fString = string;
            fTypeAssociationStorage.set(type, this);
            fStringAssociationStorage.put(this.fString, this);
        }

        public int getType() {
            return this.fType;
        }

        public String getString() {
            return this.fString;
        }

        public static TypeToStringAssociation getAssociation(String str) {
            return fStringAssociationStorage.get(str);
        }

        public static TypeToStringAssociation getAssociation(int type) {
            return fTypeAssociationStorage.get(type);
        }
    }
}

