/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeNavigator {
    private Tree fTree;
    private Class<?> fDataClass;

    public TreeNavigator(Tree tree, Class<?> dataClass) {
        this.fTree = tree;
        this.fDataClass = dataClass;
    }

    public TreeItem getSelectedItem() {
        return this.getItemOfClass(this.fTree.getSelection(), true);
    }

    private TreeItem getItemOfClass(TreeItem[] items, boolean fwd) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[fwd ? i : items.length - 1 - i];
            if (this.fDataClass == null || this.fDataClass.isInstance(item.getData())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public TreeItem getFirstItemOnLevel(int level, boolean fwd) {
        return this.getFirstOnLevel(this.fTree.getItems(), level, fwd);
    }

    private TreeItem getFirstOnLevel(TreeItem[] items, int level, boolean fwd) {
        TreeItem item = this.getItemOfClass(items, fwd);
        if (level <= 0 || item == null) {
            return item;
        }
        return this.getFirstOnLevel(item.getItems(), level - 1, fwd);
    }

    public TreeItem getSelectedItemOrFirstOnLevel(int level, boolean fwd) {
        TreeItem result = this.getSelectedItem();
        if (result == null) {
            result = this.getFirstItemOnLevel(level, fwd);
        }
        return result;
    }

    public TreeItem getNextSibbling(TreeItem current, boolean forward) {
        TreeItem parentItem = current.getParentItem();
        if (parentItem == null) {
            Tree tree = current.getParent();
            int itemCount = tree.getItemCount();
            if (itemCount > 0) {
                int index = tree.indexOf(current);
                index = (index + (forward ? 1 : itemCount - 1)) % itemCount;
                return tree.getItem(index);
            }
        } else {
            int itemCount = parentItem.getItemCount();
            if (itemCount > 0) {
                int index = parentItem.indexOf(current);
                index = (index + (forward ? 1 : itemCount - 1)) % itemCount;
                return parentItem.getItem(index);
            }
        }
        return null;
    }
}

