/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.internal.ide.model.WorkingSetResourceMapping;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WorkingSetAdapterFactory
implements IAdapterFactory {
    private IContributorResourceAdapter2 contributorResourceAdapter = new ContributorResourceAdapter();
    private IWorkbenchAdapter workbenchAdapter = new WorkbenchAdapter();

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof IWorkingSet) {
            if (adapterType == IContributorResourceAdapter.class) {
                return adapterType.cast(this.contributorResourceAdapter);
            }
            if (adapterType == IWorkbenchAdapter.class) {
                return adapterType.cast(this.workbenchAdapter);
            }
            if (adapterType == ResourceMapping.class) {
                IWorkingSet workingSet = (IWorkingSet)adaptableObject;
                IAdaptable[] elements = workingSet.getElements();
                int i = 0;
                while (i < elements.length) {
                    IAdaptable element = elements[i];
                    ResourceMapping mapping = WorkingSetAdapterFactory.getResourceMapping(element);
                    if (mapping != null) {
                        return adapterType.cast((Object)new WorkingSetResourceMapping(workingSet));
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IContributorResourceAdapter2.class, IWorkbenchAdapter.class, ResourceMapping.class};
    }

    static ResourceMapping getResourceMapping(Object o) {
        ResourceMapping mapping = (ResourceMapping)Adapters.adapt((Object)o, ResourceMapping.class);
        if (mapping != null) {
            return mapping;
        }
        IResource resource = (IResource)Adapters.adapt((Object)o, IResource.class);
        if (resource != null && (mapping = (ResourceMapping)Adapters.adapt((Object)resource, ResourceMapping.class)) != null) {
            return mapping;
        }
        return null;
    }

    static ResourceMapping getContributedResourceMapping(IAdaptable element) {
        IContributorResourceAdapter resourceAdapter = (IContributorResourceAdapter)Adapters.adapt((Object)element, IContributorResourceAdapter.class);
        if (resourceAdapter != null) {
            IContributorResourceAdapter2 mappingAdapter;
            ResourceMapping mapping;
            if (resourceAdapter instanceof IContributorResourceAdapter2 && (mapping = (mappingAdapter = (IContributorResourceAdapter2)resourceAdapter).getAdaptedResourceMapping(element)) != null) {
                return mapping;
            }
            IResource resource = resourceAdapter.getAdaptedResource(element);
            if (resource != null && (mapping = (ResourceMapping)Adapters.adapt((Object)resource, ResourceMapping.class)) != null) {
                return mapping;
            }
        }
        return null;
    }

    class ContributorResourceAdapter
    implements IContributorResourceAdapter2 {
        ContributorResourceAdapter() {
        }

        @Override
        public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
            if (adaptable instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)adaptable;
                IAdaptable[] elements = workingSet.getElements();
                int i = 0;
                while (i < elements.length) {
                    IAdaptable element = elements[i];
                    ResourceMapping mapping = WorkingSetAdapterFactory.getContributedResourceMapping(element);
                    if (mapping == null) {
                        mapping = WorkingSetAdapterFactory.getResourceMapping(element);
                    }
                    if (mapping != null) {
                        return new WorkingSetResourceMapping(workingSet);
                    }
                    ++i;
                }
            }
            return null;
        }

        @Override
        public IResource getAdaptedResource(IAdaptable adaptable) {
            return null;
        }
    }

    class WorkbenchAdapter
    implements IWorkbenchAdapter {
        WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            if (o instanceof IWorkingSet) {
                IWorkingSet set = (IWorkingSet)o;
                return set.getElements();
            }
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object o) {
            if (o instanceof IWorkingSet) {
                IWorkingSet set = (IWorkingSet)o;
                return set.getImageDescriptor();
            }
            return null;
        }

        public String getLabel(Object o) {
            if (o instanceof IWorkingSet) {
                IWorkingSet set = (IWorkingSet)o;
                return set.getLabel();
            }
            return null;
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

