/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalID
extends CPPDependentEvaluation {
    private final ICPPEvaluation fFieldOwner;
    private final char[] fName;
    private final IBinding fNameOwner;
    private final boolean fAddressOf;
    private final boolean fQualified;
    private final boolean fIsPointerDeref;
    private final ICPPTemplateArgument[] fTemplateArgs;

    public EvalID(ICPPEvaluation fieldOwner, IBinding nameOwner, char[] simpleID, boolean addressOf, boolean qualified, boolean isPointerDeref, ICPPTemplateArgument[] templateArgs, IASTNode pointOfDefinition) {
        this(fieldOwner, nameOwner, simpleID, addressOf, qualified, isPointerDeref, templateArgs, EvalID.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalID(ICPPEvaluation fieldOwner, IBinding nameOwner, char[] simpleID, boolean addressOf, boolean qualified, boolean isPointerDeref, ICPPTemplateArgument[] templateArgs, IBinding templateDefinition) {
        super(templateDefinition);
        if (simpleID == null) {
            throw new NullPointerException("simpleID");
        }
        this.fFieldOwner = fieldOwner;
        this.fName = simpleID;
        this.fNameOwner = nameOwner;
        this.fAddressOf = addressOf;
        this.fQualified = qualified;
        this.fIsPointerDeref = isPointerDeref;
        this.fTemplateArgs = templateArgs;
    }

    public ICPPEvaluation getFieldOwner() {
        return this.fFieldOwner;
    }

    public IBinding getNameOwner() {
        return this.fNameOwner;
    }

    public char[] getName() {
        return this.fName;
    }

    public boolean isAddressOf() {
        return this.fAddressOf;
    }

    public boolean isQualified() {
        return this.fQualified;
    }

    public boolean isPointerDeref() {
        return this.fIsPointerDeref;
    }

    public ICPPTemplateArgument[] getTemplateArgs() {
        return this.fTemplateArgs;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        return true;
    }

    @Override
    public boolean isValueDependent() {
        return true;
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        return false;
    }

    @Override
    public IType getType(IASTNode point) {
        return new TypeOfDependentExpression(this);
    }

    @Override
    public IValue getValue(IASTNode point) {
        return Value.create(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 10;
        if (this.fAddressOf) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.fQualified) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        if (this.fTemplateArgs != null) {
            firstBytes = (short)(firstBytes | 0x80);
        }
        if (this.fIsPointerDeref) {
            firstBytes = (short)(firstBytes | 0x100);
        }
        buffer.putShort(firstBytes);
        buffer.marshalEvaluation(this.fFieldOwner, false);
        buffer.putCharArray(this.fName);
        buffer.marshalBinding(this.fNameOwner);
        if (this.fTemplateArgs != null) {
            buffer.putInt(this.fTemplateArgs.length);
            ICPPTemplateArgument[] iCPPTemplateArgumentArray = this.fTemplateArgs;
            int n = this.fTemplateArgs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
                buffer.marshalTemplateArgument(arg);
                ++n2;
            }
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean addressOf = (firstBytes & 0x20) != 0;
        boolean qualified = (firstBytes & 0x40) != 0;
        boolean isPointerDeref = (firstBytes & 0x100) != 0;
        ICPPEvaluation fieldOwner = (ICPPEvaluation)buffer.unmarshalEvaluation();
        char[] name = buffer.getCharArray();
        IBinding nameOwner = buffer.unmarshalBinding();
        ICPPTemplateArgument[] args = null;
        if ((firstBytes & 0x80) != 0) {
            int len = buffer.getInt();
            args = new ICPPTemplateArgument[len];
            int i = 0;
            while (i < args.length) {
                args[i] = buffer.unmarshalTemplateArgument();
                ++i;
            }
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalID(fieldOwner, nameOwner, name, addressOf, qualified, isPointerDeref, args, templateDefinition);
    }

    public static ICPPEvaluation create(IASTIdExpression expr) {
        IType fieldOwnerType;
        IASTName name = expr.getName();
        IBinding binding = name.resolvePreBinding();
        boolean qualified = name instanceof ICPPASTQualifiedName;
        if (binding instanceof IProblemBinding || binding instanceof IType || binding instanceof ICPPConstructor) {
            return EvalFixed.INCOMPLETE;
        }
        if (binding instanceof CPPFunctionSet) {
            return new EvalFunctionSet((CPPFunctionSet)binding, qualified, EvalID.isAddressOf(expr), null, expr);
        }
        if (binding instanceof ICPPUnknownBinding) {
            ICPPTemplateArgument[] templateArgs = null;
            IASTName lastName = name.getLastName();
            if (lastName instanceof ICPPASTTemplateId) {
                try {
                    templateArgs = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)lastName);
                }
                catch (DOMException e) {
                    return EvalFixed.INCOMPLETE;
                }
            }
            if (binding instanceof CPPDeferredFunction) {
                ICPPFunction[] candidates = ((CPPDeferredFunction)binding).getCandidates();
                if (candidates != null) {
                    CPPFunctionSet functionSet = new CPPFunctionSet(candidates, templateArgs, null);
                    return new EvalFunctionSet(functionSet, qualified, EvalID.isAddressOf(expr), null, expr);
                }
                return new EvalFunctionSet(name.getSimpleID(), qualified, EvalID.isAddressOf(expr), expr);
            }
            IBinding owner = binding.getOwner();
            if (owner instanceof IProblemBinding) {
                return EvalFixed.INCOMPLETE;
            }
            EvalFixed fieldOwner = null;
            IType fieldOwnerType2 = EvalID.withinNonStaticMethod(expr);
            if (fieldOwnerType2 != null) {
                fieldOwner = new EvalFixed(fieldOwnerType2, IASTExpression.ValueCategory.LVALUE, Value.UNKNOWN);
            }
            return new EvalID((ICPPEvaluation)fieldOwner, owner, name.getSimpleID(), EvalID.isAddressOf(expr), name instanceof ICPPASTQualifiedName, false, templateArgs, expr);
        }
        if (binding instanceof ICPPMember && !(binding instanceof IType) && !(binding instanceof ICPPConstructor) && !((ICPPMember)binding).isStatic() && (fieldOwnerType = EvalID.withinNonStaticMethod(expr)) != null) {
            return new EvalMemberAccess(fieldOwnerType, IASTExpression.ValueCategory.LVALUE, binding, true, expr);
        }
        if (binding instanceof IEnumerator) {
            ICPPEnumeration enumType;
            IType type = ((IEnumerator)binding).getType();
            if (type instanceof ICPPEnumeration && EvalID.isInsideEnum(expr, enumType = (ICPPEnumeration)type)) {
                if (binding instanceof ICPPInternalEnumerator && (type = enumType.getFixedType()) == null) {
                    type = ((ICPPInternalEnumerator)binding).getInternalType();
                }
                return new EvalBinding(binding, type, expr);
            }
            return new EvalBinding(binding, null, expr);
        }
        if (binding instanceof ICPPTemplateNonTypeParameter || binding instanceof IVariable || binding instanceof IFunction) {
            return new EvalBinding(binding, null, expr);
        }
        return EvalFixed.INCOMPLETE;
    }

    private static boolean isInsideEnum(IASTNode node, ICPPEnumeration enumBinding) {
        IASTEnumerationSpecifier.IASTEnumerator enumeratorNode = ASTQueries.findAncestorWithType(node, IASTEnumerationSpecifier.IASTEnumerator.class);
        if (enumeratorNode == null) {
            return false;
        }
        IBinding enumerator = enumeratorNode.getName().getBinding();
        return enumerator != null && enumBinding == enumerator.getOwner();
    }

    private static IType withinNonStaticMethod(IASTExpression expr) {
        IASTNode parent = expr.getParent();
        while (parent != null && !(parent instanceof ICPPASTFunctionDefinition)) {
            parent = parent.getParent();
        }
        if (parent instanceof ICPPASTFunctionDefinition) {
            ICPPASTFunctionDefinition fdef = (ICPPASTFunctionDefinition)parent;
            if (ASTQueries.isAncestorOf(fdef.getDeclSpecifier(), expr)) {
                return null;
            }
            IBinding methodBinding = fdef.getDeclarator().getName().resolvePreBinding();
            if (methodBinding instanceof ICPPMethod && !((ICPPMethod)methodBinding).isStatic()) {
                IScope scope = CPPVisitor.getContainingScope(expr);
                return CPPVisitor.getImpliedObjectType(scope);
            }
        }
        return null;
    }

    private static boolean isAddressOf(IASTIdExpression expr) {
        IASTNode e = expr.getParent();
        while (e instanceof IASTUnaryExpression) {
            IASTUnaryExpression unary = (IASTUnaryExpression)e;
            int op = unary.getOperator();
            if (op == 11) {
                e = unary.getOperand();
                continue;
            }
            return op == 5;
        }
        return false;
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        IBinding nameOwner;
        ICPPEvaluation fieldOwner;
        ICPPTemplateArgument[] templateArgs = this.fTemplateArgs;
        if (templateArgs != null) {
            templateArgs = EvalID.instantiateArguments(templateArgs, context);
        }
        if ((fieldOwner = this.fFieldOwner) != null) {
            fieldOwner = fieldOwner.instantiate(context, maxDepth);
        }
        if ((nameOwner = this.fNameOwner) instanceof ICPPClassTemplate) {
            ICPPDeferredClassInstance deferred = CPPTemplates.createDeferredInstance((ICPPClassTemplate)nameOwner);
            nameOwner = EvalID.resolveUnknown(deferred, context);
        } else if (nameOwner instanceof IType) {
            IType type = CPPTemplates.instantiateType((IType)((Object)nameOwner), context);
            if (!((type = SemanticUtil.getNestedType(type, 13)) instanceof IBinding)) {
                return EvalFixed.INCOMPLETE;
            }
            nameOwner = (IBinding)((Object)type);
        }
        if (fieldOwner instanceof IProblemBinding || nameOwner instanceof IProblemBinding) {
            return EvalFixed.INCOMPLETE;
        }
        if (templateArgs == this.fTemplateArgs && fieldOwner == this.fFieldOwner && nameOwner == this.fNameOwner) {
            return this;
        }
        if (nameOwner instanceof ICPPClassType) {
            ICPPEvaluation eval = this.resolveName((ICPPClassType)nameOwner, templateArgs, null, context.getPoint());
            if (eval != null) {
                return eval;
            }
            if (!CPPTemplates.isDependentType((ICPPClassType)nameOwner)) {
                return EvalFixed.INCOMPLETE;
            }
        }
        if (fieldOwner != null && !fieldOwner.isTypeDependent()) {
            ICPPEvaluation eval;
            IType fieldOwnerClassTypeCV;
            IType fieldOwnerClassType;
            IType fieldOwnerType = fieldOwner.getType(context.getPoint());
            if (this.fIsPointerDeref) {
                if ((fieldOwnerType = SemanticUtil.getSimplifiedType(fieldOwnerType)) instanceof IPointerType) {
                    fieldOwnerType = ((IPointerType)fieldOwnerType).getType();
                } else {
                    return EvalFixed.INCOMPLETE;
                }
            }
            if ((fieldOwnerClassType = SemanticUtil.getNestedType(fieldOwnerClassTypeCV = SemanticUtil.getNestedType(fieldOwnerType, 5), 8)) instanceof ICPPClassType && (eval = this.resolveName((ICPPClassType)fieldOwnerClassType, templateArgs, fieldOwnerClassTypeCV, context.getPoint())) != null) {
                return eval;
            }
        }
        return new EvalID(fieldOwner, nameOwner, this.fName, this.fAddressOf, this.fQualified, this.fIsPointerDeref, templateArgs, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.fFieldOwner == null) {
            return this;
        }
        ICPPEvaluation fieldOwner = this.fFieldOwner.computeForFunctionCall(parameterMap, context.recordStep());
        if (fieldOwner == this.fFieldOwner) {
            return this;
        }
        return new EvalID(fieldOwner, this.fNameOwner, this.fName, this.fAddressOf, this.fQualified, this.fIsPointerDeref, this.fTemplateArgs, this.getTemplateDefinition());
    }

    private ICPPEvaluation resolveName(ICPPClassType nameOwner, ICPPTemplateArgument[] templateArgs, IType impliedObjectType, IASTNode point) {
        IBinding binding;
        LookupData data = new LookupData(this.fName, templateArgs, point);
        data.qualified = this.fQualified;
        try {
            CPPSemantics.lookup(data, nameOwner.getCompositeScope());
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        IBinding[] bindings = data.getFoundBindings();
        if (bindings.length > 1 && bindings[0] instanceof ICPPFunction) {
            ICPPFunction[] functions = new ICPPFunction[bindings.length];
            System.arraycopy(bindings, 0, functions, 0, bindings.length);
            return new EvalFunctionSet(new CPPFunctionSet(functions, templateArgs, null), this.fQualified, this.fAddressOf, impliedObjectType, this.getTemplateDefinition());
        }
        IBinding iBinding = binding = bindings.length == 1 ? bindings[0] : null;
        if (binding instanceof IEnumerator) {
            return new EvalBinding(binding, null, this.getTemplateDefinition());
        }
        if (binding instanceof ICPPMember) {
            return new EvalMemberAccess((IType)nameOwner, IASTExpression.ValueCategory.PRVALUE, binding, false, this.getTemplateDefinition());
        }
        if (binding instanceof CPPFunctionSet) {
            return new EvalFunctionSet((CPPFunctionSet)binding, this.fQualified, this.fAddressOf, impliedObjectType, this.getTemplateDefinition());
        }
        return null;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r;
        int n = r = this.fFieldOwner != null ? this.fFieldOwner.determinePackSize(tpMap) : Integer.MAX_VALUE;
        if (this.fNameOwner instanceof ICPPUnknownBinding) {
            r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize((ICPPUnknownBinding)this.fNameOwner, tpMap));
        }
        if (this.fTemplateArgs != null) {
            ICPPTemplateArgument[] iCPPTemplateArgumentArray = this.fTemplateArgs;
            int n2 = this.fTemplateArgs.length;
            int n3 = 0;
            while (n3 < n2) {
                ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n3];
                r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(arg, tpMap));
                ++n3;
            }
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fFieldOwner != null && this.fFieldOwner.referencesTemplateParameter();
    }
}

