/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalBinary
extends CPPDependentEvaluation {
    public static final int op_arrayAccess = 127;
    private final int fOperator;
    private final ICPPEvaluation fArg1;
    private final ICPPEvaluation fArg2;
    private ICPPFunction fOverload = CPPFunction.UNINITIALIZED_FUNCTION;
    private IType fType;

    public EvalBinary(int operator, ICPPEvaluation arg1, ICPPEvaluation arg2, IASTNode pointOfDefinition) {
        this(operator, arg1, arg2, EvalBinary.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalBinary(int operator, ICPPEvaluation arg1, ICPPEvaluation arg2, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOperator = operator;
        this.fArg1 = arg1;
        this.fArg2 = arg2;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public ICPPEvaluation getArg1() {
        return this.fArg1;
    }

    public ICPPEvaluation getArg2() {
        return this.fArg2;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public IType getType(IASTNode point) {
        if (this.fType == null) {
            ICPPFunction overload;
            this.fType = this.isTypeDependent() ? new TypeOfDependentExpression(this) : ((overload = this.getOverload(point)) != null ? ExpressionTypes.restoreTypedefs(ExpressionTypes.typeFromFunctionCall(overload), this.fArg1.getType(point), this.fArg2.getType(point)) : this.computeType(point));
        }
        return this.fType;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.getOverload(point) != null) {
            return Value.create(this);
        }
        IValue v1 = this.fArg1.getValue(point);
        if (v1 == null || v1 == Value.UNKNOWN) {
            return Value.UNKNOWN;
        }
        IValue v2 = this.fArg2.getValue(point);
        if (v2 == null || v2 == Value.UNKNOWN) {
            return Value.UNKNOWN;
        }
        switch (this.fOperator) {
            case 28: {
                if (!v1.equals(v2)) break;
                return Value.create(1L);
            }
            case 29: {
                if (!v1.equals(v2)) break;
                return Value.create(0L);
            }
        }
        Long num1 = v1.numericalValue();
        if (num1 != null) {
            if (num1 == 0L ? this.fOperator == 15 : this.fOperator == 16) {
                return v1;
            }
            Long num2 = v2.numericalValue();
            if (num2 != null) {
                return Value.evaluateBinaryExpression(this.fOperator, num1, num2);
            }
        }
        return Value.create(this);
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fType != null) {
            return this.fType instanceof TypeOfDependentExpression;
        }
        return this.fArg1.isTypeDependent() || this.fArg2.isTypeDependent();
    }

    @Override
    public boolean isValueDependent() {
        return this.fArg1.isValueDependent() || this.fArg2.isValueDependent();
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        return this.fArg1.isConstantExpression(point) && this.fArg2.isConstantExpression(point) && EvalBinary.isNullOrConstexprFunc(this.getOverload(point));
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        if (this.isTypeDependent()) {
            return IASTExpression.ValueCategory.PRVALUE;
        }
        ICPPFunction overload = this.getOverload(point);
        if (overload != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(overload);
        }
        switch (this.fOperator) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 127: {
                return IASTExpression.ValueCategory.LVALUE;
            }
            case 30: {
                if (this.getType(point) instanceof ICPPFunctionType) break;
                return this.fArg1.getValueCategory(point);
            }
            case 31: {
                if (this.getType(point) instanceof ICPPFunctionType) break;
                return IASTExpression.ValueCategory.LVALUE;
            }
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    public ICPPFunction getOverload(IASTNode point) {
        if (this.fOverload == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fOverload = this.computeOverload(point);
        }
        return this.fOverload;
    }

    private ICPPFunction computeOverload(IASTNode point) {
        if (this.isTypeDependent()) {
            return null;
        }
        if (this.fOperator == 127) {
            IType type = this.fArg1.getType(point);
            if ((type = SemanticUtil.getNestedType(type, 13)) instanceof ICPPClassType) {
                return CPPSemantics.findOverloadedBinaryOperator(point, this.getTemplateDefinitionScope(), OverloadableOperator.BRACKET, this.fArg1, this.fArg2);
            }
        } else {
            OverloadableOperator op = OverloadableOperator.fromBinaryExpression(this.fOperator);
            if (op != null) {
                return CPPSemantics.findOverloadedBinaryOperator(point, this.getTemplateDefinitionScope(), op, this.fArg1, this.fArg2);
            }
        }
        return null;
    }

    public IType computeType(IASTNode point) {
        ICPPFunction o = this.getOverload(point);
        if (o != null) {
            return ExpressionTypes.typeFromFunctionCall(o);
        }
        IType originalType1 = this.fArg1.getType(point);
        IType type1 = ExpressionTypes.prvalueTypeWithResolvedTypedefs(originalType1);
        if (type1 instanceof ISemanticProblem) {
            return type1;
        }
        IType originalType2 = this.fArg2.getType(point);
        IType type2 = ExpressionTypes.prvalueTypeWithResolvedTypedefs(originalType2);
        if (type2 instanceof ISemanticProblem) {
            return type2;
        }
        IType type = CPPArithmeticConversion.convertCppOperandTypes(this.fOperator, type1, type2);
        if (type != null) {
            return ExpressionTypes.restoreTypedefs(type, originalType1, originalType2);
        }
        switch (this.fOperator) {
            case 127: {
                if (type1 instanceof IPointerType) {
                    return ExpressionTypes.glvalueType(((IPointerType)type1).getType());
                }
                if (type2 instanceof IPointerType) {
                    return ExpressionTypes.glvalueType(((IPointerType)type2).getType());
                }
                return ProblemType.UNKNOWN_FOR_EXPRESSION;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 28: 
            case 29: {
                return CPPBasicType.BOOLEAN;
            }
            case 4: {
                if (type1 instanceof IPointerType) {
                    return ExpressionTypes.restoreTypedefs(type1, originalType1);
                }
                if (!(type2 instanceof IPointerType)) break;
                return ExpressionTypes.restoreTypedefs(type2, originalType2);
            }
            case 5: {
                if (!(type1 instanceof IPointerType)) break;
                if (type2 instanceof IPointerType) {
                    return CPPVisitor.getPointerDiffType(point);
                }
                return originalType1;
            }
            case 30: 
            case 31: {
                if (type2 instanceof ICPPPointerToMemberType) {
                    IType t = ((ICPPPointerToMemberType)type2).getType();
                    if (t instanceof ICPPFunctionType) {
                        return t;
                    }
                    if (this.fOperator == 30 && this.fArg1.getValueCategory(point) == IASTExpression.ValueCategory.PRVALUE) {
                        return ExpressionTypes.prvalueType(t);
                    }
                    return ExpressionTypes.glvalueType(t);
                }
                return ProblemType.UNKNOWN_FOR_EXPRESSION;
            }
        }
        return type1;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)1);
        buffer.putByte((byte)this.fOperator);
        buffer.marshalEvaluation(this.fArg1, includeValue);
        buffer.marshalEvaluation(this.fArg2, includeValue);
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        ICPPEvaluation arg1 = (ICPPEvaluation)buffer.unmarshalEvaluation();
        ICPPEvaluation arg2 = (ICPPEvaluation)buffer.unmarshalEvaluation();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalBinary(op, arg1, arg2, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation arg1 = this.fArg1.instantiate(context, maxDepth);
        ICPPEvaluation arg2 = this.fArg2.instantiate(context, maxDepth);
        if (arg1 == this.fArg1 && arg2 == this.fArg2) {
            return this;
        }
        return new EvalBinary(this.fOperator, arg1, arg2, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation arg1 = this.fArg1.computeForFunctionCall(parameterMap, context.recordStep());
        ICPPEvaluation arg2 = this.fArg2.computeForFunctionCall(parameterMap, context.recordStep());
        if (arg1 == this.fArg1 && arg2 == this.fArg2) {
            return this;
        }
        return new EvalBinary(this.fOperator, arg1, arg2, this.getTemplateDefinition());
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.combinePackSize(this.fArg1.determinePackSize(tpMap), this.fArg2.determinePackSize(tpMap));
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fArg1.referencesTemplateParameter() || this.fArg2.referencesTemplateParameter();
    }
}

