/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IncludeGroupStyleBlock
extends OptionsConfigurationBlock {
    private final String description;
    private IncludeGroupStyle style;
    private final ArrayList<Button> checkBoxes = new ArrayList();
    private final ArrayList<Text> textBoxes = new ArrayList();
    private PixelConverter pixelConverter;
    private Button checkBoxBlankLine;
    private static final OptionsConfigurationBlock.Key[] EMPTY_KEY_ARRAY = new OptionsConfigurationBlock.Key[0];

    public IncludeGroupStyleBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, String description) {
        super(context, project, EMPTY_KEY_ARRAY, container);
        this.description = description;
    }

    public IncludeGroupStyle getStyle() {
        return this.style;
    }

    public void setStyle(IncludeGroupStyle style) {
        this.style = style;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.pixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.pixelConverter.convertHeightInCharsToPixels(1);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        Group group = ControlFactory.createGroup(composite, this.description, 1);
        group.setLayoutData((Object)new GridData(1808));
        Composite envelope = new Composite((Composite)group, 0);
        layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        envelope.setLayout((Layout)layout);
        this.addCheckBox(envelope, PreferencesMessages.IncludeGroupStyleBlock_keep_includes_together, 0, new BooleanDataSource(){

            @Override
            public boolean get() {
                return IncludeGroupStyleBlock.this.style.isKeepTogether();
            }

            @Override
            public void set(boolean value) {
                IncludeGroupStyleBlock.this.style.setKeepTogether(value);
            }
        });
        this.checkBoxBlankLine = this.addCheckBox(envelope, PreferencesMessages.IncludeGroupStyleBlock_blank_line_before, this.pixelConverter.convertHorizontalDLUsToPixels(10), new BooleanDataSource(){

            @Override
            public boolean get() {
                return IncludeGroupStyleBlock.this.style.isBlankLineBefore();
            }

            @Override
            public void set(boolean value) {
                IncludeGroupStyleBlock.this.style.setBlankLineBefore(value);
            }
        });
        if (!this.style.getIncludeKind().hasChildren()) {
            this.addCheckBox(envelope, PreferencesMessages.IncludeGroupStyleBlock_use_relative_path, 0, new BooleanDataSource(){

                @Override
                public boolean get() {
                    return IncludeGroupStyleBlock.this.style.isRelativePath();
                }

                @Override
                public void set(boolean value) {
                    IncludeGroupStyleBlock.this.style.setRelativePath(value);
                }
            });
            this.addCheckBox(envelope, PreferencesMessages.IncludeGroupStyleBlock_use_angle_brackets, 0, new BooleanDataSource(){

                @Override
                public boolean get() {
                    return IncludeGroupStyleBlock.this.style.isAngleBrackets();
                }

                @Override
                public void set(boolean value) {
                    IncludeGroupStyleBlock.this.style.setAngleBrackets(value);
                }
            });
        }
        this.updateControls();
        this.updateDependent();
        return composite;
    }

    private Button addCheckBox(Composite parent, String label, int indent, BooleanDataSource dataSource) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setText(label);
        checkBox.setData((Object)dataSource);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.getSelectionListener());
        this.makeScrollableCompositeAware((Control)checkBox);
        checkBox.setSelection(dataSource.get());
        this.checkBoxes.add(checkBox);
        return checkBox;
    }

    @Override
    protected void updateControls() {
        super.updateControls();
        int i = this.checkBoxes.size() - 1;
        while (i >= 0) {
            this.updateCheckBox(this.checkBoxes.get(i));
            --i;
        }
    }

    @Override
    protected void updateCheckBox(Button checkBox) {
        BooleanDataSource dataSource = (BooleanDataSource)checkBox.getData();
        checkBox.setSelection(dataSource.get());
    }

    @Override
    protected void controlChanged(Widget widget) {
        if (widget instanceof Button) {
            BooleanDataSource dataSource = (BooleanDataSource)widget.getData();
            dataSource.set(((Button)widget).getSelection());
        }
        this.updateDependent();
    }

    private void updateDependent() {
        this.checkBoxBlankLine.setEnabled(this.style.isKeepTogether());
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        StatusInfo status = new StatusInfo();
        this.fContext.statusChanged(status);
    }

    private static interface BooleanDataSource {
        public boolean get();

        public void set(boolean var1);
    }

    private static interface StringDataSource {
        public String get();

        public void set(String var1);
    }
}

