/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.templates.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.tools.templates.core.IGenerator;
import org.eclipse.tools.templates.freemarker.FileTemplate;
import org.eclipse.tools.templates.freemarker.TemplateManifest;
import org.eclipse.tools.templates.freemarker.internal.Activator;
import org.eclipse.tools.templates.freemarker.internal.Messages;
import org.osgi.framework.Bundle;

public abstract class FMGenerator
implements IGenerator,
TemplateLoader {
    private final Configuration templateConfig;
    private final String manifestPath;
    private TemplateManifest manifest;
    private List<IFile> filesToOpen = new ArrayList<IFile>();

    protected FMGenerator(String manifestPath) {
        this.templateConfig = new Configuration(Configuration.VERSION_2_3_22);
        this.templateConfig.setTemplateLoader((TemplateLoader)this);
        this.manifestPath = manifestPath;
    }

    protected abstract Bundle getSourceBundle();

    protected Class<? extends TemplateManifest> getManifestClass() {
        return TemplateManifest.class;
    }

    protected TemplateManifest getManifest() {
        return this.manifest;
    }

    public void generate(Map<String, Object> model, IProgressMonitor monitor) throws CoreException {
        if (this.manifestPath == null) {
            return;
        }
        this.manifest = null;
        try {
            StringWriter writer = new StringWriter();
            this.loadFile(this.manifestPath, model, writer);
            JAXBContext xmlContext = JAXBContext.newInstance((Class[])new Class[]{this.getManifestClass()});
            Unmarshaller unmarshaller = xmlContext.createUnmarshaller();
            this.manifest = (TemplateManifest)unmarshaller.unmarshal((Reader)new StringReader(writer.toString()));
        }
        catch (JAXBException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), Messages.FMGenerator_0, (Throwable)e));
        }
        if (this.manifest != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile fileToShow = null;
            for (FileTemplate fileTemplate : this.manifest.getFiles()) {
                Path destPath = new Path(fileTemplate.getDest());
                IProject project = root.getProject(destPath.segment(0));
                IFile file = project.getFile(destPath.removeFirstSegments(1));
                if (!fileTemplate.isCopy()) {
                    this.generateFile(fileTemplate.getSrc(), model, file, monitor);
                } else {
                    try {
                        URL url = FileLocator.find((Bundle)this.getSourceBundle(), (IPath)new Path(fileTemplate.getSrc()), null);
                        Throwable throwable = null;
                        Object var12_15 = null;
                        try (InputStream in = url.openStream();){
                            FMGenerator.createParent((IResource)file, monitor);
                            if (file.exists()) {
                                file.setContents(in, true, true, monitor);
                            } else {
                                file.create(in, true, monitor);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, Activator.getId(), String.format(Messages.FMGenerator_1, fileTemplate.getSrc()), (Throwable)e));
                    }
                }
                if (!fileTemplate.isOpen()) continue;
                if (fileTemplate.isShow()) {
                    if (fileToShow != null) {
                        this.filesToOpen.add(fileToShow);
                    }
                    fileToShow = file;
                    continue;
                }
                this.filesToOpen.add(file);
            }
            if (fileToShow != null) {
                this.filesToOpen.add(fileToShow);
            }
        }
    }

    protected void loadFile(String templateFile, Map<String, Object> model, Writer out) throws CoreException {
        try {
            Template template = this.templateConfig.getTemplate(templateFile);
            template.process(model, out);
        }
        catch (TemplateException | IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), String.format(Messages.FMGenerator_2, templateFile), e));
        }
    }

    public void generateFile(String templateFile, Map<String, Object> model, IFile outputFile, IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (StringWriter writer = new StringWriter();){
                this.loadFile(templateFile, model, writer);
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (ByteArrayInputStream in = new ByteArrayInputStream(writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8));){
                    FMGenerator.createParent((IResource)outputFile, monitor);
                    if (outputFile.exists()) {
                        outputFile.setContents((InputStream)in, true, true, monitor);
                    } else {
                        outputFile.create((InputStream)in, true, monitor);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), String.format(Messages.FMGenerator_3, templateFile), (Throwable)e));
        }
    }

    protected static void createParent(IResource child, IProgressMonitor monitor) throws CoreException {
        if (child == null) {
            return;
        }
        IContainer container = child.getParent();
        if (container.exists()) {
            return;
        }
        IFolder parent = (IFolder)container.getAdapter(IFolder.class);
        FMGenerator.createParent((IResource)parent, monitor);
        parent.create(true, true, monitor);
    }

    public IFile[] getFilesToOpen() {
        return this.filesToOpen.toArray(new IFile[this.filesToOpen.size()]);
    }

    public Object findTemplateSource(String name) throws IOException {
        return FileLocator.find((Bundle)this.getSourceBundle(), (IPath)new Path(name), null);
    }

    public long getLastModified(Object source) {
        try {
            URL url = (URL)source;
            if (url.getProtocol().equals("file")) {
                File file = new File(url.toURI());
                return file.lastModified();
            }
            return 0L;
        }
        catch (URISyntaxException uRISyntaxException) {
            return 0L;
        }
    }

    public Reader getReader(Object source, String encoding) throws IOException {
        URL url = (URL)source;
        return new InputStreamReader(url.openStream(), encoding);
    }

    public void closeTemplateSource(Object arg0) throws IOException {
    }
}

