/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IBuildPropertiesRestriction;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IModificationStatus;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildPropertyManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildSettingsUtil;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ConverterInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.MatchKey;
import org.eclipse.cdt.managedbuilder.internal.core.ModificationStatus;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChainModificationHelper;
import org.eclipse.cdt.managedbuilder.internal.core.ToolListModificationInfo;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildFolderData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildLanguageData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ConfigurationDataProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FolderInfo
extends ResourceInfo
implements IFolderInfo {
    private ToolChain toolChain;
    private boolean isExtensionElement;
    private boolean containsDiscoveredScannerInfo = true;

    public FolderInfo(FolderInfo folderInfo, String id, String resourceName, IPath path) {
        super(folderInfo, path, id, resourceName);
        IToolChain parTc;
        IToolChain extTc;
        this.isExtensionElement = folderInfo.isExtensionElement();
        if (!this.isExtensionElement) {
            this.setResourceData((CResourceData)new BuildFolderData(this));
        }
        if (folderInfo.getParent() != null) {
            this.setManagedBuildRevision(folderInfo.getParent().getManagedBuildRevision());
        }
        if ((extTc = ManagedBuildManager.getExtensionToolChain(parTc = folderInfo.getToolChain())) == null) {
            extTc = parTc;
        }
        String tcId = ManagedBuildManager.calculateChildId(extTc.getId(), null);
        this.createToolChain(extTc, tcId, parTc.getName(), false);
        this.toolChain.createOptions(parTc);
        this.toolChain.setUnusedChildren(parTc.getUnusedChildren());
        ITool[] tools = parTc.getTools();
        String subId = "";
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            ITool extTool = ManagedBuildManager.getExtensionTool(tool);
            if (extTool == null) {
                extTool = tool;
            }
            subId = ManagedBuildManager.calculateChildId(extTool.getId(), null);
            this.toolChain.createTool(tool, subId, tool.getName(), false);
            ++n2;
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    public FolderInfo(IConfiguration parent, IManagedConfigElement element, String managedBuildRevision, boolean hasBody) {
        super(parent, element, hasBody);
        this.isExtensionElement = true;
        IManagedConfigElement tcEl = null;
        if (!hasBody) {
            this.setPath((IPath)Path.ROOT);
            this.setId(ManagedBuildManager.calculateChildId(parent.getId(), null));
            this.setName("/");
            tcEl = element;
        } else {
            IManagedConfigElement[] children = element.getChildren("toolChain");
            if (children.length > 0) {
                tcEl = children[0];
            }
        }
        if (tcEl != null) {
            this.toolChain = new ToolChain((IFolderInfo)this, tcEl, managedBuildRevision);
        }
    }

    public FolderInfo(IConfiguration parent, ICStorageElement element, String managedBuildRevision, boolean hasBody) {
        super(parent, element, hasBody);
        this.isExtensionElement = false;
        this.setResourceData((CResourceData)new BuildFolderData(this));
        ICStorageElement tcEl = null;
        if (!hasBody) {
            this.setPath((IPath)Path.ROOT);
            this.setId(ManagedBuildManager.calculateChildId(parent.getId(), null));
            this.setName("/");
            tcEl = element;
        } else {
            ICStorageElement[] nodes;
            ICStorageElement[] iCStorageElementArray = nodes = element.getChildren();
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement node = iCStorageElementArray[n2];
                if ("toolChain".equals(node.getName())) {
                    tcEl = node;
                }
                ++n2;
            }
        }
        if (tcEl != null) {
            this.toolChain = new ToolChain((IFolderInfo)this, tcEl, managedBuildRevision);
        }
    }

    public FolderInfo(IConfiguration parent, IPath path, String id, String name, boolean isExtensionElement) {
        super(parent, path, id, name);
        this.isExtensionElement = isExtensionElement;
        if (!isExtensionElement) {
            this.setResourceData((CResourceData)new BuildFolderData(this));
        }
    }

    public FolderInfo(IConfiguration cfg, FolderInfo cloneInfo, String id, Map<IPath, Map<String, String>> superIdMap, boolean cloneChildren) {
        super(cfg, cloneInfo, id);
        this.isExtensionElement = cfg.isExtensionElement();
        if (!this.isExtensionElement) {
            this.setResourceData((CResourceData)new BuildFolderData(this));
        }
        if (!cloneInfo.isExtensionElement) {
            cloneChildren = true;
        }
        boolean copyIds = cloneChildren && id.equals(cloneInfo.id);
        IToolChain cloneToolChain = cloneInfo.getToolChain();
        IToolChain extToolChain = ManagedBuildManager.getExtensionToolChain(cloneToolChain);
        if (extToolChain == null) {
            extToolChain = cloneToolChain;
        }
        String subName = cloneToolChain.getName();
        if (cloneChildren) {
            String subId = copyIds ? cloneToolChain.getId() : ManagedBuildManager.calculateChildId(extToolChain.getId(), null);
            this.toolChain = new ToolChain((IFolderInfo)this, subId, subName, superIdMap, (ToolChain)cloneToolChain);
        } else {
            TargetPlatform tp;
            ITargetPlatform tpBase;
            ITool[] tools;
            String subId = ManagedBuildManager.calculateChildId(extToolChain.getId(), null);
            ToolChain newChain = this.createToolChain(extToolChain, subId, extToolChain.getName(), false);
            newChain.createOptions(extToolChain);
            ITool[] iToolArray = tools = extToolChain.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                Tool toolChild = (Tool)tool;
                subId = ManagedBuildManager.calculateChildId(toolChild.getId(), null);
                newChain.createTool(toolChild, subId, toolChild.getName(), false);
                ++n2;
            }
            ITargetPlatform extTp = tpBase = cloneInfo.getToolChain().getTargetPlatform();
            while (extTp != null && !extTp.isExtensionElement()) {
                extTp = extTp.getSuperClass();
            }
            if (extTp != null) {
                int nnn = ManagedBuildManager.getRandomNumber();
                subId = copyIds ? tpBase.getId() : String.valueOf(extTp.getId()) + "." + nnn;
                tp = new TargetPlatform(newChain, subId, tpBase.getName(), (TargetPlatform)tpBase);
            } else {
                subId = copyIds ? tpBase.getId() : ManagedBuildManager.calculateChildId(this.getId(), null);
                subName = tpBase != null ? tpBase.getName() : "";
                tp = new TargetPlatform(newChain, null, subId, subName, false);
            }
            newChain.setTargetPlatform(tp);
        }
        if (this.isRoot()) {
            this.containsDiscoveredScannerInfo = cloneInfo.containsDiscoveredScannerInfo;
        }
        if (copyIds) {
            this.isDirty = cloneInfo.isDirty;
            this.needsRebuild = cloneInfo.needsRebuild;
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    private boolean conflictsWithRootTools(ITool tool) {
        IFolderInfo rf = this.getParent().getRootFolderInfo();
        ITool[] rootTools = rf.getFilteredTools();
        ITool tt = this.getParent().getTargetTool();
        ITool[] iToolArray = rootTools;
        int n = rootTools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool rootTool = iToolArray[n2];
            if ((rootTool == tt || this.getMultipleOfType(rootTool) != null) && this.getConflictingInputExts(rootTool, tool).length != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IInputType getMultipleOfType(ITool tool) {
        IInputType[] types = tool.getInputTypes();
        IInputType mType = null;
        boolean foundNonMultiplePrimary = false;
        IInputType[] iInputTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IInputType type = iInputTypeArray[n2];
            if (type.getMultipleOfType()) {
                if (type.getPrimaryInput()) {
                    foundNonMultiplePrimary = false;
                    mType = type;
                    break;
                }
                if (mType == null) {
                    mType = type;
                }
            } else if (type.getPrimaryInput()) {
                foundNonMultiplePrimary = true;
            }
            ++n2;
        }
        return foundNonMultiplePrimary ? null : mType;
    }

    public ITool[] filterTools(ITool[] localTools, IManagedProject manProj) {
        if (manProj == null) {
            return localTools;
        }
        IProject project = (IProject)manProj.getOwner();
        Vector<Tool> tools = new Vector<Tool>(localTools.length);
        ITool[] iToolArray = localTools;
        int n = localTools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool t = iToolArray[n2];
            Tool tool = (Tool)t;
            if (tool.isEnabled(this) && (this.isRoot() || !this.conflictsWithRootTools(tool))) {
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                tools.add(tool);
                            }
                            break;
                        }
                        case 1: {
                            if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                tools.add(tool);
                            }
                            break;
                        }
                        case 2: {
                            tools.add(tool);
                            break;
                        }
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return tools.toArray(new Tool[tools.size()]);
    }

    @Override
    public ITool[] getFilteredTools() {
        if (this.toolChain == null) {
            return new ITool[0];
        }
        ITool[] localTools = this.toolChain.getTools();
        IManagedProject manProj = this.getParent().getManagedProject();
        return this.filterTools(localTools, manProj);
    }

    @Override
    public final int getKind() {
        return 4;
    }

    @Override
    public boolean isDirty() {
        if (super.isDirty()) {
            return true;
        }
        return this.toolChain.isDirty();
    }

    @Override
    public boolean needsRebuild() {
        return super.needsRebuild() || this.toolChain.needsRebuild();
    }

    @Override
    public void setRebuildState(boolean rebuild) {
        super.setRebuildState(rebuild);
        if (!rebuild) {
            this.toolChain.setRebuildState(false);
        }
    }

    @Override
    public IToolChain getToolChain() {
        return this.toolChain;
    }

    @Override
    public ITool[] getTools() {
        return this.toolChain.getTools();
    }

    @Override
    public ITool getTool(String id) {
        return this.toolChain.getTool(id);
    }

    @Override
    public ITool[] getToolsBySuperClassId(String id) {
        return this.toolChain.getToolsBySuperClassId(id);
    }

    ToolChain createToolChain(IToolChain superClass, String Id, String name, boolean isExtensionElement) {
        this.toolChain = new ToolChain((IFolderInfo)this, superClass, Id, name, isExtensionElement);
        this.setDirty(true);
        return this.toolChain;
    }

    @Override
    void serialize(ICStorageElement element) {
        super.serialize(element);
        ICStorageElement toolChainElement = element.createChild("toolChain");
        this.toolChain.serialize(toolChainElement);
    }

    @Override
    void resolveReferences() {
        if (this.toolChain != null) {
            this.toolChain.resolveReferences();
        }
    }

    @Override
    public void updateManagedBuildRevision(String revision) {
        super.updateManagedBuildRevision(revision);
        if (this.toolChain != null) {
            this.toolChain.updateManagedBuildRevision(revision);
        }
    }

    @Override
    public boolean isExtensionElement() {
        return this.isExtensionElement;
    }

    public String getErrorParserIds() {
        if (this.toolChain != null) {
            return this.toolChain.getErrorParserIds(this.getParent());
        }
        return null;
    }

    @Override
    public CFolderData getFolderData() {
        return (CFolderData)this.getResourceData();
    }

    @Override
    public CLanguageData[] getCLanguageDatas() {
        ArrayList<CLanguageData> list = new ArrayList<CLanguageData>();
        ITool[] iToolArray = this.getFilteredTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool t = iToolArray[n2];
            CLanguageData[] cLanguageDataArray = t.getCLanguageDatas();
            int n3 = cLanguageDataArray.length;
            int n4 = 0;
            while (n4 < n3) {
                CLanguageData d = cLanguageDataArray[n4];
                list.add(d);
                ++n4;
            }
            ++n2;
        }
        return list.toArray(new BuildLanguageData[list.size()]);
    }

    @Override
    public ITool getToolFromOutputExtension(String extension) {
        ITool[] tools;
        String ext = extension == null ? "" : extension;
        ITool[] iToolArray = tools = this.getFilteredTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool.producesFileType(ext)) {
                return tool;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ITool getToolFromInputExtension(String sourceExtension) {
        ITool[] tools;
        ITool[] iToolArray = tools = this.getFilteredTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool.buildsFileType(sourceExtension)) {
                return tool;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void propertiesChanged() {
        if (this.isExtensionElement) {
            return;
        }
        this.toolChain.propertiesChanged();
        super.propertiesChanged();
    }

    @Override
    public void setDirty(boolean isDirty) {
        if (this.isExtensionElement && isDirty) {
            return;
        }
        super.setDirty(isDirty);
        if (!isDirty && this.toolChain != null) {
            this.toolChain.setDirty(false);
        }
    }

    private Map<String, String> typeIdsToMap(String[] ids, IBuildObjectProperties props) {
        HashMap<String, String> map = new HashMap<String, String>(ids.length);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IBuildProperty prop = props.getProperty(id);
            map.put(id, prop.getValue().getId());
            ++n2;
        }
        return map;
    }

    private Map<String, String> propsToMap(IBuildProperty[] props) {
        HashMap<String, String> map = new HashMap<String, String>(props.length);
        IBuildProperty[] iBuildPropertyArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildProperty p = iBuildPropertyArray[n2];
            map.put(p.getPropertyType().getId(), p.getValue().getId());
            ++n2;
        }
        return map;
    }

    private boolean checkPropertiesModificationCompatibility(IBuildPropertiesRestriction r, Map<String, String> unspecifiedRequiredProps, Map<String, String> unspecifiedProps, Set<String> undefinedSet) {
        IBuildObjectProperties props = null;
        IConfiguration cfg = this.getParent();
        if (cfg != null) {
            props = cfg.getBuildProperties();
        }
        unspecifiedProps.clear();
        unspecifiedRequiredProps.clear();
        if (props != null && props.getSupportedTypeIds().length != 0) {
            String[] requiredIds = props.getRequiredTypeIds();
            IBuildPropertyType[] supportedTypes = props.getSupportedTypes();
            if (supportedTypes.length != 0 || requiredIds.length != 0) {
                if (requiredIds.length == 0 && props.getProperty("org.eclipse.cdt.build.core.buildArtefactType") != null) {
                    requiredIds = new String[]{"org.eclipse.cdt.build.core.buildArtefactType"};
                }
                Map<String, String> requiredMap = this.typeIdsToMap(requiredIds, props);
                this.getUnsupportedProperties(requiredMap, r, unspecifiedRequiredProps, undefinedSet);
                unspecifiedProps.putAll(unspecifiedRequiredProps);
                IBuildProperty[] ps = props.getProperties();
                Map<String, String> propsMap = this.propsToMap(ps);
                this.getUnsupportedProperties(propsMap, r, unspecifiedProps, undefinedSet);
            }
            return unspecifiedRequiredProps.size() == 0;
        }
        return false;
    }

    private void getUnsupportedProperties(Map<String, String> props, IBuildPropertiesRestriction restriction, Map<String, String> unsupported, Set<String> inexistent) {
        BuildPropertyManager mngr = BuildPropertyManager.getInstance();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String propId = entry.getKey();
            String valueId = entry.getValue();
            IBuildPropertyType type = mngr.getPropertyType(propId);
            if (type == null && inexistent != null) {
                inexistent.add(propId);
            }
            if (!restriction.supportsType(propId)) {
                unsupported.put(propId, null);
                continue;
            }
            if (restriction.supportsValue(propId, valueId)) continue;
            unsupported.put(propId, valueId);
        }
    }

    public void checkPropertiesModificationCompatibility(final ITool[] tools, Map<String, String> unspecifiedRequiredProps, Map<String, String> unspecifiedProps, Set<String> undefinedSet) {
        final ToolChain tc = (ToolChain)this.getToolChain();
        IBuildPropertiesRestriction r = new IBuildPropertiesRestriction(){

            @Override
            public boolean supportsType(String typeId) {
                if (tc.supportsType(typeId, false)) {
                    return true;
                }
                ITool[] iToolArray = tools;
                int n = tools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    if (((Tool)tool).supportsType(typeId)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            @Override
            public boolean supportsValue(String typeId, String valueId) {
                if (tc.supportsValue(typeId, valueId, false)) {
                    return true;
                }
                ITool[] iToolArray = tools;
                int n = tools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    if (((Tool)tool).supportsValue(typeId, valueId)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            @Override
            public String[] getRequiredTypeIds() {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(tc.getRequiredTypeIds(false)));
                ITool[] iToolArray = tools;
                int n = tools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    list.addAll(Arrays.asList(((Tool)tool).getRequiredTypeIds()));
                    ++n2;
                }
                return list.toArray(new String[list.size()]);
            }

            @Override
            public String[] getSupportedTypeIds() {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(tc.getSupportedTypeIds(false)));
                ITool[] iToolArray = tools;
                int n = tools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    list.addAll(Arrays.asList(((Tool)tool).getSupportedTypeIds()));
                    ++n2;
                }
                return list.toArray(new String[list.size()]);
            }

            @Override
            public String[] getSupportedValueIds(String typeId) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(tc.getSupportedValueIds(typeId, false)));
                ITool[] iToolArray = tools;
                int n = tools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    list.addAll(Arrays.asList(((Tool)tool).getSupportedValueIds(typeId)));
                    ++n2;
                }
                return list.toArray(new String[list.size()]);
            }

            @Override
            public boolean requiresType(String typeId) {
                if (tc.requiresType(typeId, false)) {
                    return true;
                }
                ITool[] iToolArray = tools;
                int n = tools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    if (((Tool)tool).requiresType(typeId)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        this.checkPropertiesModificationCompatibility(r, unspecifiedRequiredProps, unspecifiedProps, undefinedSet);
    }

    public boolean checkPropertiesModificationCompatibility(IToolChain tc, Map<String, String> unspecifiedRequiredProps, Map<String, String> unspecifiedProps, Set<String> undefinedSet) {
        return this.checkPropertiesModificationCompatibility((IBuildPropertiesRestriction)((Object)tc), unspecifiedRequiredProps, unspecifiedProps, undefinedSet);
    }

    public boolean isPropertiesModificationCompatible(IToolChain tc) {
        HashMap<String, String> requiredMap = new HashMap<String, String>();
        HashMap<String, String> unsupportedMap = new HashMap<String, String>();
        HashSet<String> undefinedSet = new HashSet<String>();
        return this.checkPropertiesModificationCompatibility(tc, requiredMap, unsupportedMap, undefinedSet);
    }

    private Set<String> getRequiredUnspecifiedProperties() {
        IBuildObjectProperties props = null;
        HashSet<String> set = new HashSet<String>();
        IConfiguration cfg = this.getParent();
        if (cfg != null) {
            props = cfg.getBuildProperties();
        }
        if (props != null) {
            String[] stringArray = props.getRequiredTypeIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (props.getProperty(s) == null) {
                    set.add(s);
                }
                ++n2;
            }
        }
        return set;
    }

    @Override
    public boolean isToolChainCompatible(IToolChain tCh) {
        return this.isToolChainCompatible(this.toolChain, tCh);
    }

    public boolean isToolChainCompatible(ToolChain fromTc, IToolChain tCh) {
        IToolChain newReal;
        boolean compatible = false;
        if (tCh == fromTc) {
            return true;
        }
        if (tCh == null) {
            tCh = ManagedBuildManager.getExtensionToolChain("org.eclipse.cdt.build.core.prefbase.toolchain");
        }
        if (tCh == null) {
            return false;
        }
        IToolChain curReal = ManagedBuildManager.getRealToolChain(fromTc);
        if (curReal == (newReal = ManagedBuildManager.getRealToolChain(tCh))) {
            return true;
        }
        if (this.getToolChainConverterInfo(fromTc, tCh) != null) {
            compatible = true;
        }
        if (!compatible) {
            compatible = this.isPropertiesModificationCompatible(tCh);
        }
        return compatible;
    }

    @Override
    public IToolChain changeToolChain(IToolChain newSuperClass, String Id, String name) throws BuildException {
        boolean usePrefTc = false;
        if (newSuperClass == null) {
            newSuperClass = ManagedBuildManager.getExtensionToolChain("org.eclipse.cdt.build.core.prefbase.toolchain");
            usePrefTc = true;
        }
        if (newSuperClass == null) {
            return this.toolChain;
        }
        IToolChain curReal = ManagedBuildManager.getRealToolChain(this.toolChain);
        IToolChain newReal = ManagedBuildManager.getRealToolChain(newSuperClass);
        if (Id == null) {
            Id = ManagedBuildManager.calculateChildId(newSuperClass.getId(), null);
        }
        if (name == null) {
            name = newSuperClass.getName();
        }
        if (newReal != curReal) {
            IToolChain extTc = ManagedBuildManager.getExtensionToolChain(newSuperClass);
            if (extTc != null) {
                newSuperClass = extTc;
            }
            ToolChain oldToolChain = this.toolChain;
            ConverterInfo cInfo = this.getToolChainConverterInfo(this.toolChain, newSuperClass);
            ITool[] oldTools = oldToolChain.getTools();
            if (cInfo != null) {
                this.updateToolChainWithConverter(cInfo, Id, name);
            } else {
                this.updateToolChainWithProperties(usePrefTc ? null : newSuperClass, Id, name);
            }
            BuildSettingsUtil.disconnectDepentents(this.getParent(), oldTools);
        }
        return this.toolChain;
    }

    void updateToolChainWithProperties(IToolChain newSuperClass, String Id, String name) {
        ToolChain oldTc = (ToolChain)this.getToolChain();
        if (newSuperClass != null) {
            ITool[] tools;
            this.createToolChain(newSuperClass, Id, name, false);
            this.toolChain.createOptions(newSuperClass);
            ITool[] iToolArray = tools = newSuperClass.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                Tool toolChild = (Tool)tool;
                String subId = ManagedBuildManager.calculateChildId(toolChild.getId(), null);
                this.toolChain.createTool(toolChild, subId, toolChild.getName(), false);
                ++n2;
            }
        } else {
            Configuration cfg = ConfigurationDataProvider.getClearPreference(null);
            ToolChain prefTch = (ToolChain)cfg.getRootFolderInfo().getToolChain();
            this.toolChain = new ToolChain((IFolderInfo)this, ManagedBuildManager.calculateChildId(prefTch.getSuperClass().getId(), null), prefTch.getName(), new HashMap<IPath, Map<String, String>>(), prefTch);
        }
        if (this.isRoot()) {
            Builder oldBuilder = (Builder)oldTc.getBuilder();
            Builder newBuilder = (Builder)this.getParent().getEditableBuilder();
            newBuilder.copySettings(oldBuilder, false);
        }
        IManagedProject mProj = this.getParent().getManagedProject();
        ITool[] filteredTools = this.getFilteredTools();
        ITool[] oldFilteredTools = this.filterTools(oldTc.getTools(), mProj);
        this.copySettings(oldFilteredTools, filteredTools);
        this.toolChain.propertiesChanged();
    }

    private void copySettings(ITool[] fromTools, ITool[] toTools) {
        ITool[][] matches;
        ITool[][] iToolArray = matches = this.getBestMatches(fromTools, toTools);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            ITool[] match = iToolArray[n2];
            BuildSettingsUtil.copyCommonSettings(match[0], match[1]);
            ++n2;
        }
    }

    private ITool[][] getBestMatches(ITool[] tools1, ITool[] tools2) {
        HashSet<ITool> set = new HashSet<ITool>(Arrays.asList(tools2));
        ArrayList<ITool[]> list = new ArrayList<ITool[]>(tools1.length);
        ITool[] iToolArray = tools1;
        int n = tools1.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool1 = iToolArray[n2];
            ITool bestMatchTool = null;
            int num = 0;
            for (ITool tool2 : set) {
                int extsNum = this.getConflictingInputExts(tool1, tool2).length;
                if (extsNum <= num) continue;
                bestMatchTool = tool2;
                num = extsNum;
            }
            if (bestMatchTool != null) {
                list.add(new ITool[]{tool1, bestMatchTool});
                set.remove(bestMatchTool);
            }
            ++n2;
        }
        return (ITool[][])list.toArray((T[])new ITool[list.size()][]);
    }

    void updateToolChainWithConverter(ConverterInfo cInfo, String Id, String name) throws BuildException {
        IBuildObject bo = cInfo.getConvertedFromObject();
        ToolChain updatedToolChain = null;
        if (bo instanceof Configuration) {
            Configuration cfg = (Configuration)bo;
            if (cfg != this.getParent()) {
                IResourceInfo rcInfo = cfg.getResourceInfo(this.getPath(), true);
                if (rcInfo instanceof FolderInfo) {
                    IToolChain tc = ((FolderInfo)rcInfo).getToolChain();
                    IToolChain realToToolChain = ManagedBuildManager.getRealToolChain((IToolChain)cInfo.getToObject());
                    if (ManagedBuildManager.getRealToolChain(tc) == realToToolChain) {
                        updatedToolChain = (ToolChain)tc;
                    }
                }
                if (updatedToolChain == null) {
                    updatedToolChain = (ToolChain)cfg.getRootFolderInfo().getToolChain();
                }
            } else {
                updatedToolChain = this.toolChain;
            }
        } else if (bo instanceof ToolChain) {
            updatedToolChain = (ToolChain)bo;
        } else {
            throw new BuildException(ManagedMakeMessages.getResourceString("FolderInfo.4"));
        }
        if (updatedToolChain != null && this.toolChain != updatedToolChain) {
            this.setUpdatedToolChain(updatedToolChain);
        }
        this.toolChain.setName(name);
    }

    void setUpdatedToolChain(ToolChain tch) {
        tch.copyNonoverriddenSettings(this.toolChain);
        this.toolChain = tch;
        tch.updateParentFolderInfo(this);
    }

    private ConverterInfo getToolChainConverterInfo(ToolChain fromTc, IToolChain toTc) {
        IConfigurationElement el = this.getToolChainConverterElement(fromTc, toTc);
        IToolChain foundToTc = toTc;
        if (el == null) {
            IToolChain[] tcs;
            IToolChain[] iToolChainArray = tcs = ManagedBuildManager.findIdenticalToolChains(toTc);
            int n = tcs.length;
            int n2 = 0;
            while (n2 < n) {
                IToolChain tc = iToolChainArray[n2];
                foundToTc = tc;
                if (foundToTc != toTc && (el = this.getToolChainConverterElement(fromTc, foundToTc)) != null) break;
                ++n2;
            }
        }
        if (el != null) {
            return new ConverterInfo(this, this.getToolChain(), foundToTc, el);
        }
        return null;
    }

    private IConfigurationElement getToolChainConverterElement(ToolChain fromTc, IToolChain tCh) {
        if (tCh == null) {
            return null;
        }
        if (fromTc != null) {
            return fromTc.getConverterModificationElement(tCh);
        }
        return null;
    }

    private ITool[][] checkDups(ITool[] removed, ITool[] added) {
        LinkedHashMap<Object, ITool> removedMap = this.createRealToExtToolMap(removed, false);
        LinkedHashMap<Object, ITool> addedMap = this.createRealToExtToolMap(added, true);
        LinkedHashMap rmCopy = (LinkedHashMap)removedMap.clone();
        removedMap.keySet().removeAll(addedMap.keySet());
        addedMap.keySet().removeAll(rmCopy.keySet());
        if (removedMap.size() != 0) {
            LinkedHashMap<Object, ITool> curMap = this.createRealToExtToolMap(this.getTools(), false);
            Iterator<Map.Entry<Object, ITool>> iter = removedMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, ITool> entry = iter.next();
                Object key = entry.getKey();
                ITool curTool = curMap.get(key);
                if (curTool != null) {
                    entry.setValue(curTool);
                    continue;
                }
                iter.remove();
            }
        }
        ITool[][] result = new Tool[][]{removedMap.values().toArray(new Tool[removedMap.size()]), addedMap.values().toArray(new Tool[addedMap.size()])};
        return result;
    }

    private LinkedHashMap<Object, ITool> createRealToExtToolMap(ITool[] tools, boolean extValues) {
        LinkedHashMap<Object, ITool> map = new LinkedHashMap<Object, ITool>();
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool toolValue;
            ITool t = iToolArray[n2];
            Tool realTool = (Tool)ManagedBuildManager.getRealTool(t);
            MatchKey<Tool> key = realTool.getMatchKey();
            ITool iTool = toolValue = extValues ? ManagedBuildManager.getExtensionTool(t) : t;
            if (toolValue != null) {
                map.put(key, toolValue);
            }
            ++n2;
        }
        return map;
    }

    @Override
    public void modifyToolChain(ITool[] removed, ITool[] added) {
        ToolListModificationInfo info = ToolChainModificationHelper.getModificationInfo(this, this.getTools(), added, removed);
        info.apply();
    }

    private void adjustTargetTools(ITool[] removed, ITool[] added) {
        if (!this.isRoot()) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        String[] ids = this.toolChain.getTargetToolList();
        boolean targetToolsModified = false;
        set.addAll(Arrays.asList(ids));
        ITool[] iToolArray = removed;
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            Object[] tInfo = this.getTargetTool(tool);
            if (tInfo != null) {
                ITool newTargetTool;
                ITool target = (ITool)tInfo[0];
                String tId = (String)tInfo[1];
                if (BuildSettingsUtil.calcDependentTools(added, target, null).size() == 0 && (newTargetTool = this.findCompatibleTargetTool(target, added)) != null && (newTargetTool = ManagedBuildManager.getExtensionTool(newTargetTool)) != null) {
                    set.remove(tId);
                    set.add(newTargetTool.getId());
                    targetToolsModified = true;
                }
            }
            ++n2;
        }
        if (targetToolsModified) {
            this.toolChain.setTargetToolIds(CDataUtil.arrayToString((String[])set.toArray(new String[set.size()]), (String)";"));
        }
    }

    private ITool findCompatibleTargetTool(ITool tool, ITool[] allTools) {
        int n;
        IProject project = this.getParent().getOwner().getProject();
        String[] exts = ((Tool)tool).getAllOutputExtensions(project);
        HashSet<String> extsSet = new HashSet<String>(Arrays.asList(exts));
        ITool compatibleTool = null;
        ITool[] iToolArray = allTools;
        int n2 = allTools.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] otherExts;
            ITool t = iToolArray[n3];
            String[] stringArray = otherExts = ((Tool)t).getAllOutputExtensions(project);
            n = otherExts.length;
            int n4 = 0;
            while (n4 < n) {
                String otherExt = stringArray[n4];
                if (extsSet.contains(otherExt)) {
                    compatibleTool = t;
                    break;
                }
                ++n4;
            }
            if (compatibleTool != null) break;
            ++n3;
        }
        if (compatibleTool == null) {
            Set<String> set = this.getToolOutputVars(tool);
            ITool[] iToolArray2 = allTools;
            int n5 = allTools.length;
            n2 = 0;
            while (n2 < n5) {
                IOutputType[] types;
                ITool t = iToolArray2[n2];
                IOutputType[] iOutputTypeArray = types = t.getOutputTypes();
                int n6 = types.length;
                n = 0;
                while (n < n6) {
                    IOutputType type = iOutputTypeArray[n];
                    String var = type.getBuildVariable();
                    if (var != null && set.contains(var)) {
                        compatibleTool = t;
                        break;
                    }
                    ++n;
                }
                if (compatibleTool != null) break;
                ++n2;
            }
        }
        return compatibleTool;
    }

    private Set<String> getToolOutputVars(ITool tool) {
        IOutputType[] types;
        HashSet<String> set = new HashSet<String>();
        IOutputType[] iOutputTypeArray = types = tool.getOutputTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IOutputType type = iOutputTypeArray[n2];
            String var = type.getBuildVariable();
            if (var != null) {
                set.add(var);
            }
            ++n2;
        }
        return set;
    }

    private Object[] getTargetTool(ITool tool) {
        String[] ids;
        String[] stringArray = ids = this.toolChain.getTargetToolList();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            ITool target = tool;
            while (target != null) {
                if (id.equals(target.getId())) break;
                target = target.getSuperClass();
            }
            if (target != null) {
                return new Object[]{target, id};
            }
            ++n2;
        }
        return null;
    }

    private ITool[] calculateToolsArray(ITool[] removed, ITool[] added) {
        LinkedHashMap<Object, ITool> map = this.createRealToExtToolMap(this.getTools(), false);
        LinkedHashMap<Object, ITool> removedMap = this.createRealToExtToolMap(removed, false);
        map.keySet().removeAll(removedMap.keySet());
        map.putAll(this.createRealToExtToolMap(added, true));
        return map.values().toArray(new ITool[map.size()]);
    }

    private ITool[][] calculateConflictingTools(ITool[] newTools) {
        HashSet set = new HashSet();
        set.addAll(Arrays.asList(newTools));
        ArrayList<ITool[]> result = new ArrayList<ITool[]>();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ITool t = (ITool)iter.next();
            iter.remove();
            HashSet tmp = (HashSet)set.clone();
            ArrayList<ITool> list = new ArrayList<ITool>();
            Iterator tmpIt = tmp.iterator();
            while (tmpIt.hasNext()) {
                ITool other = (ITool)tmpIt.next();
                String[] conflicts = this.getConflictingInputExts(t, other);
                if (conflicts.length == 0) continue;
                list.add(other);
                tmpIt.remove();
            }
            if (list.size() != 0) {
                list.add(t);
                result.add(list.toArray(new Tool[list.size()]));
            }
            set = tmp;
            iter = set.iterator();
        }
        return (ITool[][])result.toArray((T[])new ITool[result.size()][]);
    }

    private String[] getConflictingInputExts(ITool tool1, ITool tool2) {
        IProject project = this.getParent().getOwner().getProject();
        String[] ext1 = ((Tool)tool1).getAllInputExtensions(project);
        String[] ext2 = ((Tool)tool2).getAllInputExtensions(project);
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(ext1));
        HashSet<String> result = new HashSet<String>();
        String[] stringArray = ext2;
        int n = ext2.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (set1.remove(e)) {
                result.add(e);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public IModificationStatus getToolChainModificationStatus(ITool[] removed, ITool[] added) {
        ITool[][] checked = this.checkDups(removed, added);
        removed = checked[0];
        added = checked[1];
        ITool[] newTools = this.calculateToolsArray(removed, added);
        ITool[][] conflicting = this.calculateConflictingTools(this.filterTools(newTools, this.getParent().getManagedProject()));
        HashMap<String, String> unspecifiedRequiredProps = new HashMap<String, String>();
        HashMap<String, String> unspecifiedProps = new HashMap<String, String>();
        HashSet<String> undefinedSet = new HashSet<String>();
        IConfiguration cfg = this.getParent();
        ITool[] nonManagedTools = null;
        if (cfg.isManagedBuildOn() && cfg.supportsBuild(true)) {
            ArrayList<ITool> list = new ArrayList<ITool>();
            ITool[] iToolArray = newTools;
            int n = newTools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool t = iToolArray[n2];
                if (!t.supportsBuild(true)) {
                    list.add(t);
                }
                ++n2;
            }
            if (list.size() != 0) {
                nonManagedTools = list.toArray(new Tool[list.size()]);
            }
        }
        return new ModificationStatus(unspecifiedRequiredProps, unspecifiedProps, undefinedSet, conflicting, nonManagedTools);
    }

    @Override
    public boolean supportsBuild(boolean managed) {
        if (this.getRequiredUnspecifiedProperties().size() != 0) {
            return false;
        }
        ToolChain tCh = (ToolChain)this.getToolChain();
        if (tCh == null || !tCh.getSupportsManagedBuildAttribute()) {
            return !managed;
        }
        ITool[] tools = this.getFilteredTools();
        int i = 0;
        while (i < tools.length) {
            if (!tools[i].supportsBuild(managed)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean buildsFileType(String srcExt) {
        ITool[] tools;
        ITool[] iToolArray = tools = this.getFilteredTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool != null && tool.buildsFileType(srcExt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getOutputExtension(String resourceExtension) {
        ITool[] tools;
        String outputExtension = null;
        ITool[] iToolArray = tools = this.getFilteredTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            outputExtension = tool.getOutputExtension(resourceExtension);
            if (outputExtension != null) {
                return outputExtension;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean isHeaderFile(String ext) {
        ITool[] tools;
        IManagedProject manProj = this.getParent().getManagedProject();
        IProject project = null;
        if (manProj != null) {
            project = (IProject)manProj.getOwner();
        }
        ITool[] iToolArray = tools = this.getFilteredTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                ITool tool = iToolArray[n2];
                try {
                    if (project != null) {
                        switch (tool.getNatureFilter()) {
                            case 0: {
                                if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                    return tool.isHeaderFile(ext);
                                }
                                break block12;
                            }
                            case 1: {
                                if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                    return tool.isHeaderFile(ext);
                                }
                                break block12;
                            }
                            case 2: {
                                return tool.isHeaderFile(ext);
                            }
                        }
                        break block12;
                    }
                    return tool.isHeaderFile(ext);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Set<String> contributeErrorParsers(Set<String> set) {
        if (this.toolChain != null) {
            set = this.toolChain.contributeErrorParsers(this, set, true);
        }
        return set;
    }

    @Override
    public void resetErrorParsers() {
        if (this.toolChain != null) {
            this.toolChain.resetErrorParsers(this);
        }
    }

    @Override
    void removeErrorParsers(Set<String> set) {
        if (this.toolChain != null) {
            this.toolChain.removeErrorParsers(this, set);
        }
    }

    @Override
    public ITool getToolById(String id) {
        if (this.toolChain != null) {
            return this.toolChain.getTool(id);
        }
        return null;
    }

    @Override
    void resolveProjectReferences(boolean onLoad) {
        if (this.toolChain != null) {
            this.toolChain.resolveProjectReferences(onLoad);
        }
    }

    private void resetOptionSettings(IHoldsOptions holder) {
        IOption[] opts;
        IOption[] iOptionArray = opts = holder.getOptions();
        int n = opts.length;
        int n2 = 0;
        while (n2 < n) {
            IOption opt = iOptionArray[n2];
            Object val = opt.getDefaultValue();
            if (val instanceof Boolean) {
                ManagedBuildManager.setOption(this.toolChain.getParent(), holder, opt, (boolean)((Boolean)val));
            } else if (val instanceof String[]) {
                ManagedBuildManager.setOption(this.toolChain.getParent(), holder, opt, (String[])val);
            } else if (val instanceof String) {
                ManagedBuildManager.setOption(this.toolChain.getParent(), holder, opt, (String)val);
            } else if (val == null) {
                holder.removeOption(opt);
            } else {
                ManagedBuilderCorePlugin.error("Unknown type of value " + val + " for " + opt);
            }
            ++n2;
        }
    }

    public void resetOptionSettings() {
        ITool[] tools = this.getTools();
        IToolChain toolChain = this.getToolChain();
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            this.resetOptionSettings(tool);
            ++n2;
        }
        this.resetOptionSettings(toolChain);
    }

    @Override
    public boolean hasCustomSettings() {
        IFolderInfo parentFo = this.getParentFolderInfo();
        if (parentFo == null) {
            return true;
        }
        return this.toolChain.hasCustomSettings((ToolChain)parentFo.getToolChain());
    }

    public boolean containsDiscoveredScannerInfo() {
        if (!this.isRoot()) {
            return true;
        }
        return this.containsDiscoveredScannerInfo;
    }

    public void setContainsDiscoveredScannerInfo(boolean contains) {
        this.containsDiscoveredScannerInfo = contains;
    }

    @Override
    public boolean isFolderInfo() {
        return true;
    }

    @Override
    void performPostModificationAdjustments(ToolListModificationInfo info) {
        this.adjustTargetTools(info.getRemovedTools(), info.getAddedTools(true));
        super.performPostModificationAdjustments(info);
    }

    @Override
    void applyToolsInternal(ITool[] resultingTools, ToolListModificationInfo info) {
        ITool[] removedTools;
        ITool[] iToolArray = removedTools = info.getRemovedTools();
        int n = removedTools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            ITool extTool = ManagedBuildManager.getExtensionTool(tool);
            if (extTool.getParent() == this.toolChain.getSuperClass()) {
                this.toolChain.addUnusedChild(extTool);
            }
            ++n2;
        }
        this.toolChain.setToolsInternal(resultingTools);
        this.adjustTargetTools(removedTools, info.getAddedTools(true));
        this.setRebuildState(true);
    }

    @Override
    public boolean isSupported() {
        if (this.toolChain != null) {
            return this.toolChain.isSupported();
        }
        return false;
    }
}

