/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class ProblemMarkerInfo {
    public IResource file;
    public int lineNumber;
    public int startChar;
    public int endChar;
    public String description;
    public int severity;
    public String variableName;
    public IPath externalPath;
    private Map<String, String> attributes;
    private String type;

    public ProblemMarkerInfo(IResource file, int lineNumber, String description, int severity, String variableName) {
        this(file, lineNumber, -1, -1, description, severity, variableName);
    }

    public ProblemMarkerInfo(IResource file, int lineNumber, int startChar, int endChar, String description, int severity, String variableName) {
        this.file = file != null ? file : ResourcesPlugin.getWorkspace().getRoot();
        this.lineNumber = lineNumber;
        this.description = description;
        this.severity = severity;
        this.variableName = variableName;
        this.externalPath = null;
        this.type = null;
        this.attributes = new HashMap<String, String>();
        this.startChar = startChar;
        this.endChar = endChar;
    }

    public ProblemMarkerInfo(IResource file, int lineNumber, String description, int severity, String variableName, IPath externalPath) {
        this(file, lineNumber, description, severity, variableName);
        this.externalPath = externalPath;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

