/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.model.IChangeReverseMethodHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl_7_6;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl2;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.CLIInfoRecordInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBRunControl_7_10
extends GDBRunControl_7_6
implements IReverseRunControl2 {
    private IMICommandControl fCommandControl;
    private CommandFactory fCommandFactory;
    private IChangeReverseMethodHandler.ReverseDebugMethod fReverseTraceMethod;

    public GDBRunControl_7_10(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            public void handleSuccess() {
                GDBRunControl_7_10.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class);
        this.fCommandFactory = this.fCommandControl.getCommandFactory();
        this.fReverseTraceMethod = IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
        if (this.fCommandControl == null) {
            requestMonitor.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Service is not available"));
            return;
        }
        this.register(new String[]{IReverseRunControl2.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    protected void setReverseTraceMethod(IChangeReverseMethodHandler.ReverseDebugMethod traceMethod) {
        if (this.fReverseTraceMethod != traceMethod) {
            boolean enabled = false;
            this.fReverseTraceMethod = traceMethod;
            if (this.fReverseTraceMethod != IChangeReverseMethodHandler.ReverseDebugMethod.OFF) {
                enabled = true;
            }
            this.setReverseModeEnabled(enabled);
        }
    }

    @Override
    public void getReverseTraceMethod(ICommandControlService.ICommandControlDMContext context, DataRequestMonitor<IChangeReverseMethodHandler.ReverseDebugMethod> rm) {
        rm.setData((Object)this.fReverseTraceMethod);
        rm.done();
    }

    @Override
    public void enableReverseMode(final ICommandControlService.ICommandControlDMContext context, final IChangeReverseMethodHandler.ReverseDebugMethod traceMethod, final RequestMonitor rm) {
        if (!this.getReverseSupported()) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Reverse mode is not supported.", null));
            return;
        }
        if (this.fReverseTraceMethod == traceMethod) {
            rm.done();
            return;
        }
        if (this.fReverseTraceMethod == IChangeReverseMethodHandler.ReverseDebugMethod.OFF || traceMethod == IChangeReverseMethodHandler.ReverseDebugMethod.OFF) {
            this.getConnection().queueCommand(this.fCommandFactory.createCLIRecord(context, traceMethod), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                public void handleSuccess() {
                    boolean enabled = false;
                    GDBRunControl_7_10.this.fReverseTraceMethod = traceMethod;
                    if (GDBRunControl_7_10.this.fReverseTraceMethod != IChangeReverseMethodHandler.ReverseDebugMethod.OFF) {
                        enabled = true;
                    }
                    GDBRunControl_7_10.this.setReverseModeEnabled(enabled);
                    rm.done();
                }

                public void handleFailure() {
                    rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Trace method could not be selected", null));
                }
            });
            return;
        }
        this.getConnection().queueCommand(this.fCommandFactory.createCLIRecord(context, IChangeReverseMethodHandler.ReverseDebugMethod.OFF), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleSuccess() {
                GDBRunControl_7_10.this.setReverseModeEnabled(false);
                GDBRunControl_7_10.this.getConnection().queueCommand(GDBRunControl_7_10.this.fCommandFactory.createCLIRecord(context, traceMethod), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)GDBRunControl_7_10.this.getExecutor(), rm){

                    public void handleSuccess() {
                        GDBRunControl_7_10.this.fReverseTraceMethod = traceMethod;
                        GDBRunControl_7_10.this.setReverseModeEnabled(true);
                        rm.done();
                    }

                    public void handleFailure() {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Trace method could not be selected", null));
                        GDBRunControl_7_10.this.setReverseModeEnabled(false);
                        GDBRunControl_7_10.this.fReverseTraceMethod = IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
                        rm.done();
                    }
                });
            }
        });
    }

    @Override
    public void eventReceived(Object output) {
        if (output instanceof MIOutput) {
            MIOOBRecord[] records;
            MIOOBRecord[] mIOOBRecordArray = records = ((MIOutput)output).getMIOOBRecords();
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                MINotifyAsyncOutput notifyOutput;
                String asyncClass;
                MIOOBRecord r = mIOOBRecordArray[n2];
                if (r instanceof MINotifyAsyncOutput && ("record-started".equals(asyncClass = (notifyOutput = (MINotifyAsyncOutput)r).getAsyncClass()) || "record-stopped".equals(asyncClass))) {
                    if ("record-stopped".equals(asyncClass)) {
                        this.setReverseTraceMethod(IChangeReverseMethodHandler.ReverseDebugMethod.OFF);
                    } else {
                        IChangeReverseMethodHandler.ReverseDebugMethod newMethod = this.getTraceMethodFromOutput(notifyOutput);
                        if (newMethod != null) {
                            this.setReverseTraceMethod(newMethod);
                        } else {
                            this.getConnection().queueCommand(this.fCommandFactory.createCLIInfoRecord(this.getConnection().getContext()), (DataRequestMonitor)new DataRequestMonitor<CLIInfoRecordInfo>((Executor)this.getExecutor(), null){

                                public void handleCompleted() {
                                    if (this.isSuccess()) {
                                        GDBRunControl_7_10.this.setReverseTraceMethod(((CLIInfoRecordInfo)this.getData()).getReverseMethod());
                                    } else {
                                        GDBRunControl_7_10.this.setReverseTraceMethod(IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE);
                                    }
                                }
                            });
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private IChangeReverseMethodHandler.ReverseDebugMethod getTraceMethodFromOutput(MINotifyAsyncOutput notifyOutput) {
        String methodStr = "";
        String formatStr = "";
        MIResult[] results = notifyOutput.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue val = results[i].getMIValue();
            if (var.equals("method")) {
                if (val instanceof MIConst) {
                    methodStr = ((MIConst)val).getString();
                }
            } else if (var.equals("format") && val instanceof MIConst) {
                formatStr = ((MIConst)val).getString();
            }
            ++i;
        }
        if (methodStr.equals("full")) {
            assert (formatStr.isEmpty()) : "Unexpected format string for full method in =record-started: " + formatStr;
            return IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE;
        }
        if (methodStr.equals("btrace")) {
            if (formatStr.equals("bts")) {
                return IChangeReverseMethodHandler.ReverseDebugMethod.BRANCH_TRACE;
            }
            if (formatStr.equals("pt")) {
                return IChangeReverseMethodHandler.ReverseDebugMethod.PROCESSOR_TRACE;
            }
            assert (false) : "Unexpected format string for bts method in =record-started: " + formatStr;
        }
        assert (methodStr.isEmpty()) : "Unexpected trace method in =record-started: " + methodStr;
        assert (formatStr.isEmpty()) : "Unexpected format string in =record-started: " + formatStr;
        return null;
    }
}

