/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.command.CLIEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.LargePipedInputStream;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIInterpreterExecConsole;
import org.eclipse.cdt.dsf.mi.service.command.commands.RawCommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MILogStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

@ThreadSafe
public abstract class AbstractCLIProcess
extends Process
implements IEventListener,
ICommandListener {
    public static final String PRIMARY_PROMPT = "(gdb)";
    public static final String SECONDARY_PROMPT = ">";
    private static final String SECONDARY_PROMPT_END_COMMAND = "end";
    private final DsfSession fSession;
    private final ICommandControlService fCommandControl;
    private final OutputStream fOutputStream;
    private PipedInputStream fMIInConsolePipe;
    private PipedOutputStream fMIOutConsolePipe;
    private PipedInputStream fMIInLogPipe;
    private PipedOutputStream fMIOutLogPipe;
    private boolean fDisposed;
    private int fSuppressConsoleOutputCounter;
    private PromptType fPrompt;

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public AbstractCLIProcess(ICommandControlService commandControl) throws IOException {
        PipedOutputStream miOutLogPipe;
        LargePipedInputStream miInLogPipe;
        PipedOutputStream miOutConsolePipe;
        LargePipedInputStream miInConsolePipe;
        block2: {
            this.fOutputStream = new CLIOutputStream();
            this.fDisposed = false;
            this.fSuppressConsoleOutputCounter = 0;
            this.fPrompt = PromptType.IN_PRIMARY_PROMPT;
            this.fSession = commandControl.getSession();
            this.fCommandControl = commandControl;
            commandControl.addEventListener((IEventListener)this);
            commandControl.addCommandListener((ICommandListener)this);
            miInConsolePipe = null;
            miOutConsolePipe = null;
            miInLogPipe = null;
            miOutLogPipe = null;
            try {
                miOutConsolePipe = new PipedOutputStream();
                miInConsolePipe = new LargePipedInputStream(miOutConsolePipe);
                miOutLogPipe = new PipedOutputStream();
                miInLogPipe = new LargePipedInputStream(miOutLogPipe);
            }
            catch (IOException e) {
                ILog log = GdbPlugin.getDefault().getLog();
                if (log == null) break block2;
                log.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Error when creating log pipes", (Throwable)e));
            }
        }
        this.fMIOutConsolePipe = miOutConsolePipe;
        this.fMIInConsolePipe = miInConsolePipe;
        this.fMIOutLogPipe = miOutLogPipe;
        this.fMIInLogPipe = miInLogPipe;
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected ICommandControlService getCommandControlService() {
        return this.fCommandControl;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public void dispose() {
        if (this.fDisposed) {
            return;
        }
        this.fCommandControl.removeEventListener((IEventListener)this);
        this.fCommandControl.removeCommandListener((ICommandListener)this);
        this.closeIO();
        this.fDisposed = true;
        this.fMIInConsolePipe = null;
        this.fMIInLogPipe = null;
        this.fMIOutConsolePipe = null;
        this.fMIOutLogPipe = null;
    }

    private void closeIO() {
        try {
            this.fMIOutConsolePipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fMIInConsolePipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fMIOutLogPipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fMIInLogPipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public InputStream getErrorStream() {
        return this.fMIInLogPipe;
    }

    @Override
    public InputStream getInputStream() {
        return this.fMIInConsolePipe;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public void eventReceived(Object output) {
        if (this.fSuppressConsoleOutputCounter > 0) {
            return;
        }
        MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
        int n = mIOOBRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            MIStreamRecord out;
            MIOOBRecord oobr = mIOOBRecordArray[n2];
            if (oobr instanceof MIConsoleStreamOutput) {
                out = (MIConsoleStreamOutput)oobr;
                str = out.getString();
                if (str.trim().equals(SECONDARY_PROMPT)) {
                    if (this.inMissingSecondaryPrompt()) {
                        return;
                    }
                    str = "> ";
                }
                this.setPrompt(str);
                try {
                    if (this.fMIOutConsolePipe != null) {
                        this.fMIOutConsolePipe.write(str.getBytes());
                        this.fMIOutConsolePipe.flush();
                    }
                }
                catch (IOException iOException) {}
            } else if (oobr instanceof MILogStreamOutput && (str = (out = (MILogStreamOutput)oobr).getString()) != null) {
                try {
                    if (this.fMIOutLogPipe != null) {
                        this.fMIOutLogPipe.write(str.getBytes());
                        this.fMIOutLogPipe.flush();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
        ICommand command = token.getCommand();
        if ((command instanceof CLICommand || command instanceof MIInterpreterExecConsole) && !(command instanceof ProcessCLICommand) && !(command instanceof ProcessMIInterpreterExecConsole)) {
            ++this.fSuppressConsoleOutputCounter;
        }
        if (command instanceof MICommand) {
            this.checkMissingSecondaryPrompt((MICommand)command);
        }
    }

    private void checkMissingSecondaryPrompt(MICommand<?> command) {
        int indx;
        String operation;
        int indx2;
        String operation2;
        String[] operations;
        if (command instanceof ProcessMIInterpreterExecConsole && (operations = ((ProcessMIInterpreterExecConsole)command).getParameters()) != null && operations.length > 0 && this.isMissingSecondaryPromptCommand(operation2 = (indx2 = (operation2 = operations[0]).indexOf(32)) != -1 ? operation2.substring(0, indx2).trim() : operation2.trim())) {
            this.fPrompt = PromptType.IN_SECONDARY_PROMPT_MISSING;
        }
        if (this.fPrompt == PromptType.IN_SECONDARY_PROMPT_MISSING && (operation = command.getOperation()) != null && !(operation = (indx = operation.indexOf(32)) != -1 ? operation.substring(0, indx).trim() : operation.trim()).equals(SECONDARY_PROMPT_END_COMMAND)) {
            String str = "> ";
            try {
                if (this.fMIOutConsolePipe != null) {
                    this.fMIOutConsolePipe.write(str.getBytes());
                    this.fMIOutConsolePipe.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected boolean isMissingSecondaryPromptCommand(String operation) {
        return false;
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        this.fPrompt = PromptType.IN_PRIMARY_PROMPT;
        ICommand command = token.getCommand();
        if ((command instanceof CLICommand || command instanceof MIInterpreterExecConsole) && !(command instanceof ProcessCLICommand) && !(command instanceof ProcessMIInterpreterExecConsole)) {
            --this.fSuppressConsoleOutputCounter;
        }
    }

    void setPrompt(String line) {
        this.fPrompt = PromptType.IN_PRIMARY_PROMPT;
        if (line == null) {
            return;
        }
        if ((line = line.trim()).equals(SECONDARY_PROMPT)) {
            this.fPrompt = PromptType.IN_SECONDARY_PROMPT;
        }
    }

    public boolean inPrimaryPrompt() {
        return this.fPrompt == PromptType.IN_PRIMARY_PROMPT;
    }

    public boolean inSecondaryPrompt() {
        return this.fPrompt == PromptType.IN_SECONDARY_PROMPT || this.fPrompt == PromptType.IN_SECONDARY_PROMPT_MISSING;
    }

    public boolean inMissingSecondaryPrompt() {
        return this.fPrompt == PromptType.IN_SECONDARY_PROMPT_MISSING;
    }

    private boolean isMIOperation(String operation) {
        return operation.startsWith("-");
    }

    private class CLIOutputStream
    extends OutputStream {
        private final StringBuilder buf = new StringBuilder();

        private CLIOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.buf.append((char)b);
            if (b == 10) {
                final String bufString = this.buf.toString().trim();
                this.buf.setLength(0);
                try {
                    AbstractCLIProcess.this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            try {
                                CLIOutputStream.this.post(bufString);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        public void post(String str) throws IOException {
            if (AbstractCLIProcess.this.isDisposed()) {
                return;
            }
            MICommand cmd = null;
            boolean secondary = AbstractCLIProcess.this.inSecondaryPrompt();
            cmd = secondary ? new RawCommand((IDMContext)AbstractCLIProcess.this.getCommandControlService().getContext(), str) : (!AbstractCLIProcess.this.isMIOperation(str) && !CLIEventProcessor.isSteppingOperation(str) ? new ProcessMIInterpreterExecConsole((IDMContext)AbstractCLIProcess.this.getCommandControlService().getContext(), str) : new ProcessCLICommand((IDMContext)AbstractCLIProcess.this.getCommandControlService().getContext(), str));
            final RawCommand finalCmd = cmd;
            AbstractCLIProcess.this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (AbstractCLIProcess.this.isDisposed()) {
                        return;
                    }
                    AbstractCLIProcess.this.getCommandControlService().queueCommand(finalCmd, null);
                }
            });
        }
    }

    private class ProcessCLICommand
    extends CLICommand<MIInfo> {
        public ProcessCLICommand(IDMContext ctx, String oper) {
            super(ctx, oper);
        }
    }

    private class ProcessMIInterpreterExecConsole
    extends MIInterpreterExecConsole<MIInfo> {
        public ProcessMIInterpreterExecConsole(IDMContext ctx, String cmd) {
            super(ctx, cmd);
        }
    }

    private static enum PromptType {
        IN_PRIMARY_PROMPT,
        IN_SECONDARY_PROMPT,
        IN_SECONDARY_PROMPT_MISSING;

    }
}

