/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action;

import java.util.HashMap;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenMap;

public class TokenMap
implements ITokenMap {
    public static final int INVALID_KIND = -1;
    private final int[] kindMap;

    public TokenMap(String[] toSymbols, String[] fromSymbols) {
        if (toSymbols == fromSymbols) {
            this.kindMap = null;
            return;
        }
        this.kindMap = new int[fromSymbols.length];
        HashMap<String, Integer> toMap = new HashMap<String, Integer>();
        int i = 0;
        int n = toSymbols.length;
        while (i < n) {
            toMap.put(toSymbols[i], i);
            ++i;
        }
        i = 0;
        n = fromSymbols.length;
        while (i < n) {
            Integer kind = (Integer)toMap.get(fromSymbols[i]);
            this.kindMap[i] = kind == null ? -1 : kind;
            ++i;
        }
    }

    @Override
    public int mapKind(int kind) {
        if (this.kindMap == null) {
            return kind;
        }
        if (kind < 0 || kind >= this.kindMap.length) {
            return -1;
        }
        return this.kindMap[kind];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        boolean first = true;
        int i = 0;
        int n = this.kindMap.length;
        while (i < n) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(i).append('=').append(this.kindMap[i]);
            first = false;
            ++i;
        }
        return sb.append(')').toString();
    }
}

