/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.build.QtBuildConfigurationProvider;
import org.eclipse.cdt.qt.core.IQtBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.LaunchConfigurationTargetedDelegate;

public abstract class QtLaunchConfigurationDelegate
extends LaunchConfigurationTargetedDelegate {
    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        IQtBuildConfiguration qtBuildConfig = this.getQtBuildConfiguration(configuration, mode, target, monitor);
        if (qtBuildConfig != null) {
            IProject project = qtBuildConfig.getBuildConfiguration().getProject();
            IProjectDescription desc = project.getDescription();
            desc.setActiveBuildConfig(qtBuildConfig.getBuildConfiguration().getName());
            project.setDescription(desc, monitor);
            return this.superBuildForLaunch(configuration, mode, monitor);
        }
        return false;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project = configuration.getMappedResources()[0].getProject();
        return new IProject[]{project};
    }

    protected void populateToolChainProperties(ILaunchTarget target, Map<String, String> properties) {
        String arch;
        String os = target.getAttribute("os", null);
        if (os != null) {
            properties.put("os", os.toLowerCase());
        }
        if ((arch = target.getAttribute("arch", null)) != null) {
            properties.put("arch", arch.toLowerCase());
        }
    }

    protected IQtBuildConfiguration getQtBuildConfiguration(ILaunchConfiguration configuration, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        ICBuildConfigurationManager configManager = Activator.getService(ICBuildConfigurationManager.class);
        QtBuildConfigurationProvider provider = (QtBuildConfigurationProvider)configManager.getProvider("org.eclipse.cdt.qt.core.qtBuildConfigProvider");
        IProject project = configuration.getMappedResources()[0].getProject();
        HashMap<String, String> properties = new HashMap<String, String>();
        this.populateToolChainProperties(target, properties);
        IQtBuildConfiguration qtConfig = provider.getConfiguration(project, properties, mode, monitor);
        if (qtConfig != null) {
            return qtConfig;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.qt.core", String.format("No suitable SDK found for target %s.", target.getId())));
    }
}

