/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.dom.rewrite.TypeHelper;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterOptions;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarationStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTEqualsInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionCallExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ClassMemberInserter;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.MethodContext;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoringDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.FunctionExtractor;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.NonExtractableStatementFinder;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ReturnStatementFinder;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.SimilarFinderVisitor;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.SimilarReplacerVisitor;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.TrailName;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.TrailNodeEqualityChecker;
import org.eclipse.cdt.internal.ui.refactoring.utils.ASTHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.CPPASTAllVisitor;
import org.eclipse.cdt.internal.ui.refactoring.utils.Checks;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractFunctionRefactoring
extends CRefactoring {
    public static final String ID = "org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoring";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final Integer NULL_INTEGER = 0;
    private NodeContainer container;
    private final ExtractFunctionInformation info = new ExtractFunctionInformation();
    final Map<String, Integer> names;
    final Container<Integer> namesCounter;
    final Container<Integer> trailPos;
    private int returnNumber;
    HashMap<String, Integer> nameTrail;
    private FunctionExtractor extractor;
    private INodeFactory nodeFactory;
    private final DefaultCodeFormatterOptions formattingOptions;
    private IIndex index;
    private IASTTranslationUnit ast;

    public ExtractFunctionRefactoring(ICElement element, ISelection selection, ICProject project) {
        super(element, selection, project);
        this.name = Messages.ExtractFunctionRefactoring_ExtractFunction;
        this.names = new HashMap<String, Integer>();
        this.namesCounter = new Container<Integer>(NULL_INTEGER);
        this.trailPos = new Container<Integer>(NULL_INTEGER);
        this.formattingOptions = new DefaultCodeFormatterOptions(project.getOptions(true));
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        try {
            RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(8));
            if (status.hasError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            this.index = this.getIndex();
            this.ast = this.getAST(this.tu, (IProgressMonitor)sm.newChild(1));
            this.nodeFactory = this.ast.getASTNodeFactory();
            this.container = this.findExtractableNodes();
            if (ExtractFunctionRefactoring.isProgressMonitorCanceled((IProgressMonitor)sm, this.initStatus)) {
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            if (this.container.isEmpty()) {
                this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_NoStmtSelected);
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            this.checkForNonExtractableStatements(this.container, this.initStatus);
            List<NameInformation> returnValueCandidates = this.container.getReturnValueCandidates();
            if (returnValueCandidates.size() > 1) {
                this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_TooManyDeclarations);
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            if (returnValueCandidates.size() == 1) {
                this.info.setMandatoryReturnVariable(returnValueCandidates.get(0));
            }
            this.info.setParameters(this.container.getParameterCandidates());
            this.initStatus.merge(this.checkParameterAndReturnTypes());
            if (this.initStatus.hasFatalError()) {
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            this.extractor = FunctionExtractor.createFor(this.container.getNodesToWrite());
            if (this.extractor.canChooseReturnValue() && this.info.getMandatoryReturnVariable() == null) {
                this.chooseReturnVariable();
            }
            IPreferencesService preferences = Platform.getPreferencesService();
            boolean outFirst = preferences.getBoolean("org.eclipse.cdt.ui", "function_output_parameters_before_input", false, PreferenceConstants.getPreferenceScopes(this.project.getProject()));
            this.info.sortParameters(outFirst);
            boolean isExtractExpression = this.container.getNodesToWrite().get(0) instanceof IASTExpression;
            this.info.setExtractExpression(isExtractExpression);
            this.info.setDeclarator(this.getDeclaration(this.container.getNodesToWrite().get(0)));
            MethodContext context = NodeHelper.findMethodContext(this.container.getNodesToWrite().get(0), this.refactoringContext, (IProgressMonitor)sm.newChild(1));
            if (context.getType() == MethodContext.ContextType.METHOD && context.getMethodDeclarationName() == null) {
                this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_no_declaration_of_surrounding_method);
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            this.info.setMethodContext(context);
            RefactoringStatus refactoringStatus = this.initStatus;
            return refactoringStatus;
        }
        finally {
            sm.done();
        }
    }

    private void chooseReturnVariable() {
        NameInformation candidate = null;
        for (NameInformation param : this.info.getParameters()) {
            if (!param.isOutput()) continue;
            IASTDeclarator declarator = param.getDeclarator();
            IType type = TypeHelper.createType((IASTDeclarator)declarator);
            if ((type = SemanticUtil.getNestedType((IType)type, (int)9)) instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eBoolean) {
                param.setReturnValue(true);
                return;
            }
            if (candidate != null || TypeHelper.shouldBePassedByReference((IType)type, (IASTTranslationUnit)declarator.getTranslationUnit())) continue;
            candidate = param;
        }
        if (candidate != null) {
            candidate.setReturnValue(true);
        }
    }

    private void checkForNonExtractableStatements(NodeContainer container, RefactoringStatus status) {
        NonExtractableStatementFinder finder = new NonExtractableStatementFinder();
        for (IASTNode node : container.getNodesToWrite()) {
            node.accept((ASTVisitor)finder);
            if (finder.containsContinue()) {
                this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_Error_Continue);
                break;
            }
            if (!finder.containsBreak()) continue;
            this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_Error_Break);
            break;
        }
        ReturnStatementFinder returnFinder = new ReturnStatementFinder();
        for (IASTNode node : container.getNodesToWrite()) {
            node.accept((ASTVisitor)returnFinder);
            if (!returnFinder.containsReturn()) continue;
            this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_Error_Return);
            break;
        }
    }

    private ICPPASTFunctionDeclarator getDeclaration(IASTNode node) {
        IASTFunctionDeclarator declarator;
        while (node != null && !(node instanceof IASTFunctionDefinition)) {
            node = node.getParent();
        }
        if (node != null && (declarator = ((IASTFunctionDefinition)node).getDeclarator()) instanceof ICPPASTFunctionDeclarator) {
            return (ICPPASTFunctionDeclarator)declarator;
        }
        return null;
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        CPPASTName methodName = new CPPASTName(this.info.getMethodName().toCharArray());
        MethodContext context = this.info.getMethodContext();
        if (context.getType() == MethodContext.ContextType.METHOD && !context.isInline()) {
            IASTDeclaration contextDeclaration = context.getMethodDeclaration();
            ICPPASTCompositeTypeSpecifier classDeclaration = (ICPPASTCompositeTypeSpecifier)contextDeclaration.getParent();
            IASTSimpleDeclaration methodDeclaration = this.getDeclaration((IASTName)methodName);
            if (this.isMethodAllreadyDefined(methodDeclaration, classDeclaration, this.getIndex())) {
                status.addError(Messages.ExtractFunctionRefactoring_name_in_use);
            }
        }
        return status;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        CPPASTName methodName = new CPPASTName(this.info.getMethodName().toCharArray());
        MethodContext context = this.info.getMethodContext();
        if (context.getType() == MethodContext.ContextType.METHOD && !context.isInline()) {
            this.createMethodDeclaration((IASTName)methodName, context, collector);
        }
        IASTNode firstNode = this.container.getNodesToWrite().get(0);
        this.createMethodDefinition((IASTName)methodName, context, firstNode, collector);
        this.createMethodCalls((IASTName)methodName, context, collector);
    }

    private void createMethodCalls(IASTName methodName, MethodContext context, ModificationCollector collector) throws CoreException {
        String title = context.getType() == MethodContext.ContextType.METHOD ? Messages.ExtractFunctionRefactoring_CreateMethodCall : Messages.ExtractFunctionRefactoring_CreateFunctionCall;
        IASTNode methodCall = this.getMethodCall(methodName);
        IASTNode firstNodeToWrite = this.container.getNodesToWrite().get(0);
        ASTRewrite rewriter = collector.rewriterForTranslationUnit(firstNodeToWrite.getTranslationUnit());
        TextEditGroup editGroup = new TextEditGroup(title);
        if (methodCall instanceof IASTDeclaration) {
            CPPASTDeclarationStatement declarationStatement = new CPPASTDeclarationStatement((IASTDeclaration)methodCall);
            methodCall = declarationStatement;
        }
        this.insertCallIntoTree(methodCall, this.container.getNodesToWrite(), rewriter, editGroup);
        if (this.info.isReplaceDuplicates()) {
            this.replaceSimilar(collector, methodName);
        }
        for (IASTNode node : this.container.getNodesToWrite()) {
            if (node == firstNodeToWrite) continue;
            rewriter.remove(node, editGroup);
        }
    }

    private void insertCallIntoTree(IASTNode methodCall, List<IASTNode> list, ASTRewrite rewriter, TextEditGroup editGroup) {
        IASTNode firstNode = list.get(0);
        if (list.size() > 1 && firstNode.getParent() instanceof IASTBinaryExpression && firstNode.getParent().getParent() instanceof IASTBinaryExpression) {
            IASTBinaryExpression parent = (IASTBinaryExpression)firstNode.getParent();
            IASTExpression leftSubTree = parent.getOperand1();
            int op = parent.getOperator();
            CPPASTBinaryExpression newParentNode = new CPPASTBinaryExpression();
            IASTBinaryExpression rootBinExp = this.getRootBinExp(parent, list);
            newParentNode.setParent(rootBinExp.getParent());
            newParentNode.setOperand1(leftSubTree.copy(IASTNode.CopyStyle.withLocations));
            newParentNode.setOperator(op);
            newParentNode.setOperand2((IASTExpression)methodCall);
            rewriter.replace((IASTNode)rootBinExp, (IASTNode)newParentNode, editGroup);
        } else {
            rewriter.replace(firstNode, methodCall, editGroup);
        }
    }

    private IASTBinaryExpression getRootBinExp(IASTBinaryExpression binExp, List<IASTNode> nodeList) {
        while (binExp.getParent() instanceof IASTBinaryExpression && nodeList.contains(((IASTBinaryExpression)binExp.getParent()).getOperand2())) {
            binExp = (IASTBinaryExpression)binExp.getParent();
        }
        return binExp;
    }

    private void createMethodDefinition(IASTName methodName, MethodContext context, IASTNode firstExtractedNode, ModificationCollector collector) {
        IASTFunctionDefinition functionToExtractFrom = (IASTFunctionDefinition)ASTQueries.findAncestorWithType((IASTNode)firstExtractedNode, IASTFunctionDefinition.class);
        if (functionToExtractFrom != null) {
            String title = context.getType() == MethodContext.ContextType.METHOD ? Messages.ExtractFunctionRefactoring_CreateMethodDef : Messages.ExtractFunctionRefactoring_CreateFunctionDef;
            ASTRewrite rewriter = collector.rewriterForTranslationUnit(functionToExtractFrom.getTranslationUnit());
            this.addMethod(methodName, context, rewriter, (IASTNode)functionToExtractFrom, new TextEditGroup(title));
        }
    }

    private void createMethodDeclaration(IASTName astMethodName, MethodContext context, ModificationCollector collector) {
        ICPPASTCompositeTypeSpecifier classDeclaration = (ICPPASTCompositeTypeSpecifier)context.getMethodDeclaration().getParent();
        IASTSimpleDeclaration methodDeclaration = this.getDeclaration(collector, astMethodName);
        ASTRewrite rewrite = ClassMemberInserter.createChange(classDeclaration, this.info.getVisibility(), (IASTNode)methodDeclaration, false, collector);
        if (classDeclaration.getTranslationUnit().isHeaderUnit()) {
            this.qualifyExternalReferences((IASTNode)methodDeclaration, classDeclaration, rewrite);
        }
    }

    private void qualifyExternalReferences(IASTNode node, ICPPASTCompositeTypeSpecifier classDeclaration, final ASTRewrite rewrite) {
        String[] contextQualifiers;
        ICPPBinding owner = (ICPPBinding)classDeclaration.getName().resolveBinding();
        try {
            contextQualifiers = owner.getQualifiedName();
        }
        catch (DOMException e) {
            CUIPlugin.log(e);
            return;
        }
        node.accept(new ASTVisitor(true){

            public int visit(IASTName name) {
                ExtractFunctionRefactoring.this.qualifyForContext((ICPPASTName)name, contextQualifiers, rewrite);
                return 1;
            }
        });
    }

    private void qualifyForContext(ICPPASTName name, String[] contextQualifiers, ASTRewrite rewrite) {
        ICPPASTName originalName = (ICPPASTName)name.getOriginalNode();
        IBinding binding = originalName.resolveBinding();
        try {
            ICPPASTQualifiedName qualifiedName;
            if (!(binding instanceof ICPPBinding)) {
                return;
            }
            String[] names = ((ICPPBinding)binding).getQualifiedName();
            if ((names = this.removeCommonPrefix(names, contextQualifiers)).length <= 1) {
                return;
            }
            if (name instanceof ICPPASTQualifiedName) {
                qualifiedName = (ICPPASTQualifiedName)name;
                if (qualifiedName.getQualifier().length >= names.length - 1) {
                    return;
                }
            } else {
                qualifiedName = new CPPASTQualifiedName(name.copy(IASTNode.CopyStyle.withLocations));
            }
            int i = 0;
            while (i < names.length - qualifiedName.getQualifier().length) {
                qualifiedName.addNameSpecifier((ICPPASTNameSpecifier)new CPPASTName(names[i].toCharArray()));
                ++i;
            }
            if (!(name instanceof ICPPASTQualifiedName)) {
                rewrite.replace((IASTNode)name, (IASTNode)qualifiedName, null);
            }
        }
        catch (DOMException e) {
            CUIPlugin.log(e);
            return;
        }
    }

    private String[] removeCommonPrefix(String[] array1, String[] array2) {
        int i = 0;
        while (i < array1.length && i < array2.length) {
            if (!array1[i].equals(array2[i])) {
                if (i == 0) {
                    return array1;
                }
                return Arrays.copyOfRange(array1, i, array1.length);
            }
            ++i;
        }
        return EMPTY_STRING_ARRAY;
    }

    private void replaceSimilar(ModificationCollector collector, IASTName methodName) {
        List<IASTNode> nodesToRewriteWithoutComments = this.getNodesWithoutComments(this.container.getNodesToWrite());
        List<IASTNode> initTrail = this.getTrail(nodesToRewriteWithoutComments);
        IASTTranslationUnit ast = nodesToRewriteWithoutComments.get(0).getTranslationUnit();
        ast.accept((ASTVisitor)new SimilarReplacerVisitor(this, this.container, collector, initTrail, methodName, nodesToRewriteWithoutComments));
    }

    public int getNumberOfDuplicates() {
        List<IASTNode> nodesToRewriteWithoutComments = this.getNodesWithoutComments(this.container.getNodesToWrite());
        List<IASTNode> initTrail = this.getTrail(nodesToRewriteWithoutComments);
        final int[] count = new int[1];
        IASTTranslationUnit ast = nodesToRewriteWithoutComments.get(0).getTranslationUnit();
        ast.accept((ASTVisitor)new SimilarFinderVisitor(this, this.container, initTrail, nodesToRewriteWithoutComments){

            @Override
            protected void foundSimilar() {
                count[0] = count[0] + 1;
            }
        });
        return count[0];
    }

    private List<IASTNode> getNodesWithoutComments(List<IASTNode> nodes) {
        ArrayList<IASTNode> nodesWithoutComments = new ArrayList<IASTNode>(nodes.size());
        for (IASTNode node : nodes) {
            if (node instanceof IASTComment) continue;
            nodesWithoutComments.add(node);
        }
        return nodesWithoutComments;
    }

    private List<IASTNode> getTrail(List<IASTNode> stmts) {
        final ArrayList<IASTNode> trail = new ArrayList<IASTNode>();
        this.nameTrail = new HashMap();
        final Container<Integer> trailCounter = new Container<Integer>(NULL_INTEGER);
        for (IASTNode node : stmts) {
            node.accept((ASTVisitor)new CPPASTAllVisitor(){

                @Override
                public int visitAll(IASTNode node) {
                    if (node instanceof IASTComment) {
                        return super.visitAll(node);
                    }
                    if (node instanceof IASTNamedTypeSpecifier) {
                        trail.add(node);
                        return 1;
                    }
                    if (node instanceof IASTName) {
                        if (node instanceof ICPPASTConversionName && node instanceof ICPPASTOperatorName && node instanceof ICPPASTTemplateId) {
                            trail.add(node);
                            return super.visitAll(node);
                        }
                        IASTName name = (IASTName)node;
                        TrailName trailName = new TrailName(name);
                        int actCount = (Integer)trailCounter.getObject();
                        if (ExtractFunctionRefactoring.this.nameTrail.containsKey(name.getRawSignature())) {
                            Integer value = ExtractFunctionRefactoring.this.nameTrail.get(name.getRawSignature());
                            actCount = value;
                        } else {
                            trailCounter.setObject(++actCount);
                            ExtractFunctionRefactoring.this.nameTrail.put(name.getRawSignature(), (Integer)trailCounter.getObject());
                        }
                        trailName.setNameNumber(actCount);
                        if (ExtractFunctionRefactoring.this.info.getReturnVariable() != null && ExtractFunctionRefactoring.this.info.getReturnVariable().getName().getRawSignature().equals(name.getRawSignature())) {
                            ExtractFunctionRefactoring.this.returnNumber = actCount;
                        }
                        trail.add(trailName);
                        return 1;
                    }
                    trail.add(node);
                    return super.visitAll(node);
                }
            });
        }
        return trail;
    }

    boolean isStatementInTrail(IASTStatement stmt, final List<IASTNode> trail) {
        final boolean[] same = new boolean[]{true};
        final TrailNodeEqualityChecker equalityChecker = new TrailNodeEqualityChecker(this.names, this.namesCounter, this.index);
        stmt.accept((ASTVisitor)new CPPASTAllVisitor(){

            @Override
            public int visitAll(IASTNode node) {
                int pos = ExtractFunctionRefactoring.this.trailPos.getObject();
                if (trail.size() <= 0 || pos >= trail.size()) {
                    same[0] = false;
                    return 2;
                }
                if (node instanceof IASTComment) {
                    return super.visitAll(node);
                }
                IASTNode trailNode = (IASTNode)trail.get(pos);
                ExtractFunctionRefactoring.this.trailPos.setObject(pos + 1);
                if (equalityChecker.isEqual(trailNode, node)) {
                    if (node instanceof ICPPASTQualifiedName || node instanceof IASTNamedTypeSpecifier) {
                        return 1;
                    }
                    return super.visitAll(node);
                }
                same[0] = false;
                return 2;
            }
        });
        return same[0];
    }

    private boolean isMethodAllreadyDefined(IASTSimpleDeclaration methodDeclaration, ICPPASTCompositeTypeSpecifier classDeclaration, IIndex index) {
        TrailNodeEqualityChecker equalityChecker = new TrailNodeEqualityChecker(this.names, this.namesCounter, index);
        IBinding bind = classDeclaration.getName().resolveBinding();
        IASTStandardFunctionDeclarator declarator = (IASTStandardFunctionDeclarator)methodDeclaration.getDeclarators()[0];
        String name = new String(declarator.getName().toCharArray());
        if (bind instanceof ICPPClassType) {
            ICPPMethod[] methods;
            IField[] fields;
            ICPPClassType classBind = (ICPPClassType)bind;
            IField[] iFieldArray = fields = classBind.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (field.getName().equals(name)) {
                    return true;
                }
                ++n2;
            }
            ICPPMethod[] iCPPMethodArray = methods = classBind.getAllDeclaredMethods();
            int n3 = methods.length;
            n = 0;
            while (n < n3) {
                ICPPParameter[] parameters;
                ICPPMethod method = iCPPMethodArray[n];
                if (!method.takesVarArgs() && name.equals(method.getName()) && (parameters = method.getParameters()).length == declarator.getParameters().length) {
                    int i = 0;
                    while (i < parameters.length) {
                        IASTName[] origParameterName = this.ast.getDeclarationsInAST((IBinding)parameters[i]);
                        IASTParameterDeclaration origParameter = (IASTParameterDeclaration)origParameterName[0].getParent().getParent();
                        IASTParameterDeclaration newParameter = declarator.getParameters()[i];
                        if (!equalityChecker.isEqual((IASTNode)origParameter.getDeclSpecifier(), (IASTNode)newParameter.getDeclSpecifier()) || !ASTHelper.samePointers(origParameter.getDeclarator().getPointerOperators(), newParameter.getDeclarator().getPointerOperators(), equalityChecker)) break;
                        if (i >= parameters.length - 1) {
                            return true;
                        }
                        ++i;
                    }
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    private void addMethod(IASTName methodName, MethodContext context, ASTRewrite rewrite, IASTNode functionToExtractFrom, TextEditGroup group) {
        ClassMemberInserter.InsertionInfo insertion;
        CPPASTQualifiedName qname = new CPPASTQualifiedName((ICPPASTName)methodName);
        if (context.getType() == MethodContext.ContextType.METHOD && context.getMethodQName() != null) {
            ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = context.getMethodQName().getQualifier();
            int n = iCPPASTNameSpecifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTNameSpecifier segment = iCPPASTNameSpecifierArray[n2];
                qname.addNameSpecifier(segment.copy());
                ++n2;
            }
        }
        CPPASTFunctionDefinition func = new CPPASTFunctionDefinition();
        func.setParent((IASTNode)this.ast);
        ArrayList<IASTPointerOperator> pointerOperators = new ArrayList<IASTPointerOperator>();
        IASTDeclSpecifier returnType = this.getReturnType(pointerOperators);
        func.setDeclSpecifier(returnType);
        IASTStandardFunctionDeclarator declarator = this.extractor.createFunctionDeclarator((IASTName)qname, (IASTStandardFunctionDeclarator)this.info.getDeclarator(), this.info.getReturnVariable(), this.container.getNodesToWrite(), this.info.getParameters(), this.nodeFactory);
        for (IASTPointerOperator operator : pointerOperators) {
            declarator.addPointerOperator(operator);
        }
        func.setDeclarator((IASTFunctionDeclarator)declarator);
        CPPASTCompoundStatement compound = new CPPASTCompoundStatement();
        func.setBody((IASTStatement)compound);
        IASTNode parent = functionToExtractFrom.getParent();
        CPPASTFunctionDefinition nodeToInsert = func;
        if (parent instanceof ICPPASTTemplateDeclaration) {
            ICPPASTTemplateDeclaration parentTemplate = (ICPPASTTemplateDeclaration)parent;
            CPPASTTemplateDeclaration templateDeclaration = new CPPASTTemplateDeclaration();
            templateDeclaration.setParent((IASTNode)this.ast);
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = parentTemplate.getTemplateParameters();
            int n = iCPPASTTemplateParameterArray.length;
            int n3 = 0;
            while (n3 < n) {
                ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n3];
                templateDeclaration.addTemplateParameter(param.copy(IASTNode.CopyStyle.withLocations));
                ++n3;
            }
            functionToExtractFrom = parentTemplate;
            templateDeclaration.setDeclaration((IASTDeclaration)func);
            nodeToInsert = templateDeclaration;
            parent = parent.getParent();
        }
        if ((insertion = parent instanceof ICPPASTCompositeTypeSpecifier ? ClassMemberInserter.findInsertionPoint((ICPPASTCompositeTypeSpecifier)parent, this.info.getVisibility(), false) : new ClassMemberInserter.InsertionInfo(parent, functionToExtractFrom)).getPrologue() != null) {
            rewrite.insertBefore(insertion.getParentNode(), insertion.getInsertBeforeNode(), (IASTNode)insertion.getPrologue(), group);
        }
        ASTRewrite subRewrite = rewrite.insertBefore(insertion.getParentNode(), insertion.getInsertBeforeNode(), (IASTNode)nodeToInsert, group);
        if (insertion.getEpilogue() != null) {
            rewrite.insertBefore(insertion.getParentNode(), insertion.getInsertBeforeNode(), (IASTNode)insertion.getEpilogue(), group);
        }
        this.extractor.constructMethodBody((IASTCompoundStatement)compound, this.container.getNodesToWrite(), this.info.getParameters(), subRewrite, group);
        NameInformation returnVariable = this.info.getReturnVariable();
        if (returnVariable != null) {
            CPPASTReturnStatement returnStmt = new CPPASTReturnStatement();
            CPPASTIdExpression expr = new CPPASTIdExpression();
            if (returnVariable.getNewName() == null) {
                expr.setName(this.newName(returnVariable.getName()));
            } else {
                expr.setName((IASTName)new CPPASTName(returnVariable.getNewName().toCharArray()));
            }
            returnStmt.setReturnValue((IASTExpression)expr);
            subRewrite.insertBefore((IASTNode)compound, null, (IASTNode)returnStmt, group);
        }
    }

    private IASTName newName(IASTName declaration) {
        return new CPPASTName(declaration.toCharArray());
    }

    private IASTDeclSpecifier getReturnType(List<IASTPointerOperator> pointerOperators) {
        IASTNode firstNodeToWrite = this.container.getNodesToWrite().get(0);
        NameInformation returnVariable = this.info.getReturnVariable();
        return this.extractor.determineReturnType(firstNodeToWrite, returnVariable, pointerOperators);
    }

    protected IASTNode getMethodCall(IASTName astMethodName, Map<String, Integer> trailNameTable, Map<String, Integer> similarNameTable, NodeContainer myContainer, NodeContainer mySimilarContainer) {
        CPPASTExpressionStatement stmt = new CPPASTExpressionStatement();
        CPPASTFunctionCallExpression callExpression = new CPPASTFunctionCallExpression();
        CPPASTIdExpression idExpression = new CPPASTIdExpression();
        idExpression.setName(astMethodName);
        ArrayList<IASTInitializerClause> args = new ArrayList<IASTInitializerClause>();
        HashSet<IASTName> declarations = new HashSet<IASTName>();
        CPPASTName retName = null;
        boolean theRetName = false;
        for (NameInformation nameInfo : this.info.getParameters()) {
            String origName = null;
            Integer trailSeqNumber = trailNameTable.get(nameInfo.getDeclarationName().getRawSignature());
            if (trailSeqNumber != null) {
                for (Map.Entry<String, Integer> entry : similarNameTable.entrySet()) {
                    if (!entry.getValue().equals(trailSeqNumber)) continue;
                    origName = entry.getKey();
                    if (this.info.getReturnVariable() == null || trailSeqNumber != this.returnNumber) continue;
                    theRetName = true;
                }
            } else {
                origName = String.valueOf(nameInfo.getDeclarationName().getSimpleID());
            }
            if (origName == null) continue;
            boolean found = false;
            for (NameInformation simNameInfo : mySimilarContainer.getNames()) {
                if (!origName.equals(simNameInfo.getDeclarationName().getRawSignature())) continue;
                this.addParameterIfPossible(args, declarations, simNameInfo);
                found = true;
                if (!theRetName) continue;
                theRetName = false;
                retName = new CPPASTName(simNameInfo.getDeclarationName().getRawSignature().toCharArray());
            }
            if (found) continue;
            CPPASTIdExpression expression = new CPPASTIdExpression();
            CPPASTName fieldName = new CPPASTName(origName.toCharArray());
            expression.setName((IASTName)fieldName);
            args.add((IASTInitializerClause)expression);
            if (!theRetName) continue;
            theRetName = false;
            retName = fieldName;
        }
        callExpression.setArguments(args.toArray(new IASTInitializerClause[args.size()]));
        callExpression.setFunctionNameExpression((IASTExpression)idExpression);
        if (this.info.getReturnVariable() == null) {
            return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTExpression)callExpression);
        }
        return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTFunctionCallExpression)callExpression, (IASTName)retName);
    }

    private IASTNode getMethodCall(IASTName methodName) {
        CPPASTExpressionStatement statement = new CPPASTExpressionStatement();
        CPPASTFunctionCallExpression callExpression = new CPPASTFunctionCallExpression();
        CPPASTIdExpression idExpression = new CPPASTIdExpression();
        idExpression.setName((IASTName)new CPPASTName(methodName.toCharArray()));
        List<IASTInitializerClause> args = this.getCallParameters();
        callExpression.setArguments(args.toArray(new IASTInitializerClause[args.size()]));
        callExpression.setFunctionNameExpression((IASTExpression)idExpression);
        if (this.info.getReturnVariable() == null) {
            return this.getReturnAssignment((IASTExpressionStatement)statement, (IASTExpression)callExpression);
        }
        IASTName retName = this.newName(this.info.getReturnVariable().getName());
        return this.getReturnAssignment((IASTExpressionStatement)statement, (IASTFunctionCallExpression)callExpression, retName);
    }

    private IASTNode getReturnAssignment(IASTExpressionStatement stmt, IASTFunctionCallExpression callExpression, IASTName retname) {
        if (this.info.getReturnVariable().equals(this.info.getMandatoryReturnVariable())) {
            IASTSimpleDeclaration orgDecl = (IASTSimpleDeclaration)ASTQueries.findAncestorWithType((IASTNode)this.info.getReturnVariable().getDeclarationName(), IASTSimpleDeclaration.class);
            CPPASTSimpleDeclaration decl = new CPPASTSimpleDeclaration();
            decl.setDeclSpecifier(orgDecl.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations));
            CPPASTDeclarator declarator = new CPPASTDeclarator();
            declarator.setName(retname);
            IASTPointerOperator[] iASTPointerOperatorArray = orgDecl.getDeclarators()[0].getPointerOperators();
            int n = iASTPointerOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
                declarator.addPointerOperator(pointer.copy(IASTNode.CopyStyle.withLocations));
                ++n2;
            }
            CPPASTEqualsInitializer initializer = new CPPASTEqualsInitializer();
            initializer.setInitializerClause((IASTInitializerClause)callExpression);
            declarator.setInitializer((IASTInitializer)initializer);
            decl.addDeclarator((IASTDeclarator)declarator);
            return decl;
        }
        CASTBinaryExpression binaryExpression = new CASTBinaryExpression();
        binaryExpression.setOperator(17);
        CPPASTIdExpression nameExpression = new CPPASTIdExpression();
        nameExpression.setName(retname);
        binaryExpression.setOperand1((IASTExpression)nameExpression);
        binaryExpression.setOperand2((IASTExpression)callExpression);
        return this.getReturnAssignment(stmt, (IASTExpression)binaryExpression);
    }

    private IASTNode getReturnAssignment(IASTExpressionStatement stmt, IASTExpression callExpression) {
        IASTNode node = this.container.getNodesToWrite().get(0);
        return this.extractor.createReturnAssignment(node, stmt, callExpression);
    }

    private IASTSimpleDeclaration getDeclaration(IASTName name) {
        CPPASTSimpleDeclaration simpleDecl = new CPPASTSimpleDeclaration();
        IASTStandardFunctionDeclarator declarator = this.extractor.createFunctionDeclarator(name, (IASTStandardFunctionDeclarator)this.info.getDeclarator(), this.info.getReturnVariable(), this.container.getNodesToWrite(), this.info.getParameters(), this.nodeFactory);
        simpleDecl.addDeclarator((IASTDeclarator)declarator);
        return simpleDecl;
    }

    private IASTSimpleDeclaration getDeclaration(ModificationCollector collector, IASTName name) {
        ArrayList<IASTPointerOperator> pointerOperators = new ArrayList<IASTPointerOperator>();
        IASTDeclSpecifier declSpec = this.getReturnType(pointerOperators);
        IASTSimpleDeclaration simpleDecl = this.nodeFactory.newSimpleDeclaration(declSpec);
        if (this.info.isVirtual() && declSpec instanceof ICPPASTDeclSpecifier) {
            ((ICPPASTDeclSpecifier)declSpec).setVirtual(true);
        }
        simpleDecl.setParent((IASTNode)this.ast);
        IASTStandardFunctionDeclarator declarator = this.extractor.createFunctionDeclarator(name, (IASTStandardFunctionDeclarator)this.info.getDeclarator(), this.info.getReturnVariable(), this.container.getNodesToWrite(), this.info.getParameters(), this.nodeFactory);
        for (IASTPointerOperator operator : pointerOperators) {
            declarator.addPointerOperator(operator);
        }
        simpleDecl.addDeclarator((IASTDeclarator)declarator);
        return simpleDecl;
    }

    private NodeContainer findExtractableNodes() {
        final NodeContainer container = new NodeContainer();
        this.ast.accept(new ASTVisitor(){
            {
                this.shouldVisitStatements = true;
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTStatement stmt) {
                if (ExtractFunctionRefactoring.this.isNodeInsideSelection((IASTNode)stmt)) {
                    container.add((IASTNode)stmt);
                    return 1;
                }
                return super.visit(stmt);
            }

            public int visit(IASTExpression expression) {
                if (ExtractFunctionRefactoring.this.isNodeInsideSelection((IASTNode)expression)) {
                    container.add((IASTNode)expression);
                    return 1;
                }
                return super.visit(expression);
            }
        });
        return container;
    }

    private boolean isNodeInsideSelection(IASTNode node) {
        return node.isPartOfTranslationUnitFile() && SelectionHelper.isNodeInsideRegion(node, (IRegion)this.selectedRegion);
    }

    public List<IASTInitializerClause> getCallParameters() {
        ArrayList<IASTInitializerClause> args = new ArrayList<IASTInitializerClause>();
        HashSet<IASTName> declarations = new HashSet<IASTName>();
        for (NameInformation nameInfo : this.info.getParameters()) {
            this.addParameterIfPossible(args, declarations, nameInfo);
        }
        return args;
    }

    private void addParameterIfPossible(List<IASTInitializerClause> args, Set<IASTName> declarations, NameInformation nameInfo) {
        IASTName declaration;
        if (!this.container.isDeclaredInSelection(nameInfo) && declarations.add(declaration = nameInfo.getDeclarationName())) {
            IASTIdExpression expression = this.nodeFactory.newIdExpression(this.newName(declaration));
            if (nameInfo.getIndirection() == NameInformation.Indirection.POINTER) {
                expression = this.nodeFactory.newUnaryExpression(5, (IASTExpression)expression);
            }
            args.add((IASTInitializerClause)expression);
        }
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        Map<String, String> arguments = this.getArgumentMap();
        ExtractFunctionRefactoringDescriptor desc = new ExtractFunctionRefactoringDescriptor(this.project.getProject().getName(), "Extract Method Refactoring", "Create method " + this.info.getMethodName(), arguments);
        return desc;
    }

    private Map<String, String> getArgumentMap() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("fileName", this.tu.getLocationURI().toString());
        arguments.put("selection", String.valueOf(this.selectedRegion.getOffset()) + "," + this.selectedRegion.getLength());
        arguments.put("name", this.info.getMethodName());
        arguments.put("visibility", this.info.getVisibility().toString());
        arguments.put("replaceDuplicates", Boolean.toString(this.info.isReplaceDuplicates()));
        return arguments;
    }

    public ExtractFunctionInformation getRefactoringInfo() {
        return this.info;
    }

    public RefactoringStatus checkMethodName() {
        return Checks.checkIdentifier(this.info.getMethodName(), this.tu);
    }

    public RefactoringStatus checkParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        List<NameInformation> parameters = this.info.getParameters();
        HashSet<String> usedNames = new HashSet<String>();
        HashSet<IASTName> declarations = new HashSet<IASTName>();
        for (NameInformation nameInfo : this.container.getNames()) {
            IASTName declaration = nameInfo.getDeclarationName();
            if (!declarations.add(declaration) || parameters.contains(nameInfo)) continue;
            usedNames.add(String.valueOf(nameInfo.getName().getSimpleID()));
        }
        for (NameInformation parameter : parameters) {
            result.merge(Checks.checkIdentifier(parameter.getNewName(), this.tu));
            for (NameInformation other : parameters) {
                if (parameter == other || !other.getNewName().equals(parameter.getNewName())) continue;
                result.addError(NLS.bind((String)Messages.ExtractFunctionRefactoring_duplicate_parameter, (Object)BasicElementLabels.getCElementName(other.getNewName())));
                return result;
            }
            if (!parameter.isRenamed() || !usedNames.contains(parameter.getNewName())) continue;
            result.addError(NLS.bind((String)Messages.ExtractFunctionRefactoring_parameter_name_in_use, (Object)BasicElementLabels.getCElementName(parameter.getNewName())));
            return result;
        }
        return result;
    }

    public RefactoringStatus checkParameterAndReturnTypes() {
        RefactoringStatus result = new RefactoringStatus();
        for (NameInformation parameter : this.info.getParameters()) {
            String typeName = parameter.getTypeName();
            if (typeName != null && !typeName.isEmpty()) continue;
            result.addError(NLS.bind((String)Messages.ExtractFunctionRefactoring_invalid_type, (Object)BasicElementLabels.getCElementName(parameter.getNewName())));
            return result;
        }
        return result;
    }

    public String getSignature(String methodName) {
        StringBuilder buf = new StringBuilder();
        NameInformation returnVariable = this.info.getReturnVariable();
        if (returnVariable != null) {
            String type = returnVariable.getReturnType();
            if (type != null) {
                buf.append(type);
            } else {
                buf.append("<unknown type>");
            }
        } else {
            buf.append("void");
        }
        buf.append(' ');
        buf.append(methodName);
        if (this.formattingOptions.insert_space_before_opening_paren_in_method_declaration) {
            buf.append(' ');
        }
        buf.append('(');
        List<NameInformation> parameters = this.info.getParameters();
        if (!parameters.isEmpty()) {
            if (this.formattingOptions.insert_space_after_opening_paren_in_method_declaration) {
                buf.append(' ');
            }
            boolean first = true;
            for (NameInformation parameter : parameters) {
                if (!first) {
                    if (this.formattingOptions.insert_space_before_comma_in_method_declaration_parameters) {
                        buf.append(' ');
                    }
                    buf.append(',');
                    if (this.formattingOptions.insert_space_after_comma_in_method_declaration_parameters) {
                        buf.append(' ');
                    }
                }
                IASTParameterDeclaration declaration = parameter.getParameterDeclaration(this.nodeFactory);
                ASTWriterVisitor writer = new ASTWriterVisitor();
                declaration.accept((ASTVisitor)writer);
                buf.append(writer.toString());
                first = false;
            }
            if (this.formattingOptions.insert_space_before_closing_paren_in_method_declaration) {
                buf.append(' ');
            }
        } else if (this.formattingOptions.insert_space_between_empty_parens_in_method_declaration) {
            buf.append(' ');
        }
        buf.append(')');
        return buf.toString();
    }
}

