/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.util.ASTNodes;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;
import org.eclipse.cdt.internal.core.util.TextUtil;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.corext.codemanipulation.StyledInclude;
import org.eclipse.cdt.internal.formatter.ChangeFormatter;
import org.eclipse.cdt.internal.ui.refactoring.includes.BindingClassifier;
import org.eclipse.cdt.internal.ui.refactoring.includes.HeaderSubstitutor;
import org.eclipse.cdt.internal.ui.refactoring.includes.IHeaderChooser;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeCreationContext;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludePreferences;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeUtil;
import org.eclipse.cdt.internal.ui.refactoring.includes.InclusionRequest;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class IncludeOrganizer {
    private static boolean DEBUG_HEADER_SUBSTITUTION = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.ui/debug/includeOrganizer/headerSubstitution"));
    private static final Collator COLLATOR = Collator.getInstance();
    private final IHeaderChooser fHeaderChooser;
    private final IncludeCreationContext fContext;

    public IncludeOrganizer(ITranslationUnit tu, IIndex index, IHeaderChooser headerChooser) {
        this.fHeaderChooser = headerChooser;
        this.fContext = new IncludeCreationContext(tu, index);
    }

    public MultiTextEdit organizeIncludes(IASTTranslationUnit ast) throws CoreException {
        Object prototype;
        Object includeInfo;
        BindingClassifier bindingClassifier = new BindingClassifier(this.fContext);
        bindingClassifier.classifyNodeContents((IASTNode)ast);
        Set<IBinding> bindingsToInclude = bindingClassifier.getBindingsToDefine();
        IASTPreprocessorIncludeStatement[] existingIncludes = ast.getIncludeDirectives();
        this.fContext.addHeadersIncludedPreviously(existingIncludes);
        HeaderSubstitutor headerSubstitutor = new HeaderSubstitutor(this.fContext);
        IIndexFileSet reachableHeaders = ast.getIndexFileSet();
        List<InclusionRequest> requests = this.createInclusionRequests(ast, bindingsToInclude, false, reachableHeaders);
        this.processInclusionRequests(requests, existingIncludes, headerSubstitutor);
        NodeCommentMap commentedNodeMap = ASTCommenter.getCommentedNodeMap((IASTTranslationUnit)ast);
        HashMap<IncludePrototype, IncludePrototype> includePrototypes = new HashMap<IncludePrototype, IncludePrototype>();
        for (IPath header : this.fContext.getHeadersToInclude()) {
            IncludeGroupStyle style = this.fContext.getIncludeStyle(header);
            includeInfo = this.fContext.createIncludeInfo(header, style);
            IncludePrototype prototype2 = new IncludePrototype(header, (IncludeInfo)includeInfo, style);
            this.updateIncludePrototypes(includePrototypes, prototype2);
        }
        includeInfo = existingIncludes;
        int style = existingIncludes.length;
        int n = 0;
        while (n < style) {
            IASTPreprocessorIncludeStatement include = includeInfo[n];
            if (include.isPartOfTranslationUnitFile()) {
                String name = new String(include.getName().getSimpleID());
                IncludeInfo includeInfo2 = new IncludeInfo(name, include.isSystemInclude());
                String path = include.getPath();
                IPath header = path.isEmpty() ? null : Path.fromOSString((String)path);
                IncludeGroupStyle style2 = header != null ? this.fContext.getIncludeStyle(header) : this.fContext.getIncludeStyle(includeInfo2);
                boolean required = this.hasPragmaKeep(include, commentedNodeMap);
                prototype = new IncludePrototype(header, includeInfo2, style2, include, required);
                this.updateIncludePrototypes(includePrototypes, (IncludePrototype)prototype);
            }
            ++n;
        }
        IRegion includeReplacementRegion = IncludeUtil.getSafeIncludeReplacementRegion(this.fContext.getSourceContents(), ast, commentedNodeMap);
        IncludePreferences preferences = this.fContext.getPreferences();
        boolean allowReordering = preferences.allowReordering || existingIncludes.length == 0;
        MultiTextEdit rootEdit = new MultiTextEdit();
        List[] groupedPrototypes = new List[preferences.includeStyles.size()];
        for (IncludePrototype prototype3 : includePrototypes.keySet()) {
            if (prototype3.getExistingInclude() == null || allowReordering && IncludeUtil.isContainedInRegion((IASTNode)prototype3.getExistingInclude(), includeReplacementRegion)) {
                IncludeGroupStyle groupingStyle = prototype3.getStyle().getGroupingStyle(preferences.includeStyles);
                int position = allowReordering ? groupingStyle.getOrder() : 0;
                ArrayList<IncludePrototype> prototypes = groupedPrototypes[position];
                if (prototypes == null) {
                    groupedPrototypes[position] = prototypes = new ArrayList<IncludePrototype>();
                }
                prototypes.add(prototype3);
            }
            if (allowReordering || prototype3.getExistingInclude() == null || prototype3.isRequired() || prototype3.getHeader() == null || this.fContext.isPartnerFile(prototype3.getHeader()) || !IncludeUtil.isContainedInRegion((IASTNode)prototype3.getExistingInclude(), includeReplacementRegion)) continue;
            switch (preferences.unusedStatementsDisposition) {
                case REMOVE: {
                    this.createDelete(prototype3.getExistingInclude(), rootEdit);
                    break;
                }
                case COMMENT_OUT: {
                    this.createCommentOut(prototype3.getExistingInclude(), rootEdit);
                    break;
                }
            }
        }
        ArrayList<String> includeDirectives = new ArrayList<String>();
        IncludeGroupStyle previousStyle = null;
        prototype = groupedPrototypes;
        int prototypes = groupedPrototypes.length;
        int position = 0;
        while (position < prototypes) {
            List prototypes2 = prototype[position];
            if (prototypes2 != null && !prototypes2.isEmpty()) {
                Collections.sort(prototypes2, preferences);
                IncludeGroupStyle style3 = ((IncludePrototype)prototypes2.get(0)).getStyle();
                if (!includeDirectives.isEmpty() && style3.isBlankLineNeededAfter(previousStyle, preferences.includeStyles)) {
                    includeDirectives.add("");
                }
                previousStyle = style3;
                for (IncludePrototype prototype4 : prototypes2) {
                    String directive;
                    String trailingComment = "";
                    IASTPreprocessorIncludeStatement include = prototype4.getExistingInclude();
                    if (include != null && (!allowReordering || !IncludeUtil.isContainedInRegion((IASTNode)include, includeReplacementRegion))) continue;
                    if (include != null) {
                        List comments = commentedNodeMap.getTrailingCommentsForNode((IASTNode)include);
                        StringBuilder buf = new StringBuilder();
                        for (IASTComment comment : comments) {
                            buf.append(ASTNodes.getPrecedingWhitespaceInLine((String)this.fContext.getSourceContents(), (IASTNode)comment));
                            buf.append(comment.getRawSignature());
                        }
                        trailingComment = buf.toString();
                    }
                    if ((directive = this.createIncludeDirective(prototype4, trailingComment)) == null) continue;
                    includeDirectives.add(directive);
                }
            }
            ++position;
        }
        StringBuilder buf = new StringBuilder();
        for (String include : includeDirectives) {
            buf.append(include);
            buf.append(this.fContext.getLineDelimiter());
        }
        int offset = includeReplacementRegion.getOffset();
        int length = includeReplacementRegion.getLength();
        if (allowReordering) {
            String text;
            if (buf.length() != 0 && offset != 0 && !TextUtil.isPreviousLineBlank((String)this.fContext.getSourceContents(), (int)offset)) {
                buf.insert(0, this.fContext.getLineDelimiter());
            }
            if ((text = buf.toString()).length() != length || !this.fContext.getSourceContents().regionMatches(offset, text, 0, length)) {
                rootEdit.addChild((TextEdit)new ReplaceEdit(offset, length, text));
            }
        } else if (buf.length() != 0) {
            rootEdit.addChild((TextEdit)new InsertEdit(offset += length, buf.toString()));
        }
        this.createForwardDeclarations(ast, bindingClassifier, includeReplacementRegion.getOffset() + includeReplacementRegion.getLength(), buf.length() != 0, rootEdit);
        return ChangeFormatter.formatChangedCode((String)new String(this.fContext.getSourceContents()), (ITranslationUnit)this.fContext.getTranslationUnit(), (MultiTextEdit)rootEdit);
    }

    private void createForwardDeclarations(IASTTranslationUnit ast, BindingClassifier classifier, int offset, boolean pendingBlankLine, MultiTextEdit rootEdit) throws CoreException {
        ForwardDeclarationNode typeDeclarationsRoot = new ForwardDeclarationNode("");
        ForwardDeclarationNode nonTypeDeclarationsRoot = new ForwardDeclarationNode("");
        IIndexFileSet reachableHeaders = ast.getIndexFileSet();
        Set<IBinding> bindings = this.removeBindingsDefinedInIncludedHeaders(ast, classifier.getBindingsToForwardDeclare(), reachableHeaders);
        for (IBinding binding : bindings) {
            DeclarationType declarationType;
            StringBuilder declarationText = new StringBuilder();
            if (binding instanceof ICompositeType) {
                declarationType = DeclarationType.TYPE;
                ICompositeType compositeType = (ICompositeType)binding;
                ICPPTemplateDefinition templateDefinition = null;
                if (compositeType instanceof ICPPTemplateDefinition) {
                    templateDefinition = (ICPPTemplateDefinition)compositeType;
                } else if (compositeType instanceof ICPPTemplateInstance) {
                    templateDefinition = ((ICPPTemplateInstance)compositeType).getTemplateDefinition();
                }
                if (templateDefinition != null) {
                    declarationText.append("template ");
                    ICPPTemplateParameter[] templateParameters = templateDefinition.getTemplateParameters();
                    int i = 0;
                    while (i < templateParameters.length) {
                        ICPPTemplateParameter templateParameter = templateParameters[i];
                        if (i == 0) {
                            declarationText.append("<");
                        }
                        declarationText.append("typename ");
                        declarationText.append(templateParameter.getName());
                        if (i != templateParameters.length - 1) {
                            declarationText.append(", ");
                        }
                        ++i;
                    }
                    if (templateParameters.length > 0) {
                        declarationText.append("> ");
                    }
                }
                switch (compositeType.getKey()) {
                    case 3: {
                        declarationText.append("class");
                        break;
                    }
                    case 1: {
                        declarationText.append("struct");
                        break;
                    }
                    case 2: {
                        declarationText.append("union");
                    }
                }
                declarationText.append(' ');
                declarationText.append(binding.getName());
                declarationText.append(';');
            } else if (binding instanceof IEnumeration) {
                declarationType = DeclarationType.TYPE;
                declarationText.append("enum class ");
                declarationText.append(binding.getName());
                declarationText.append(';');
            } else if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
                declarationType = DeclarationType.FUNCTION;
                IFunction function = (IFunction)binding;
                IFunctionType functionType = function.getType();
                declarationText.append(ASTTypeUtil.getType((IType)functionType.getReturnType(), (boolean)false));
                declarationText.append(' ');
                declarationText.append(function.getName());
                declarationText.append('(');
                IType[] parameterTypes = functionType.getParameterTypes();
                IParameter[] parameters = function.getParameters();
                int i = 0;
                while (i < parameterTypes.length && i < parameters.length) {
                    if (i != 0) {
                        declarationText.append(", ");
                    }
                    declarationText.append(ASTTypeUtil.getType((IType)parameterTypes[i], (boolean)false));
                    char lastChar = declarationText.charAt(declarationText.length() - 1);
                    if (lastChar != '*' && lastChar != '&') {
                        declarationText.append(' ');
                    }
                    declarationText.append(parameters[i].getName());
                    ++i;
                }
                declarationText.append(");");
            } else if (binding instanceof IVariable) {
                declarationType = DeclarationType.VARIABLE;
                IVariable variable = (IVariable)binding;
                IType variableType = variable.getType();
                declarationText.append("extern ");
                declarationText.append(ASTTypeUtil.getType((IType)variableType, (boolean)false));
                declarationText.append(' ');
                declarationText.append(variable.getName());
                declarationText.append(';');
            } else {
                CUIPlugin.log(new IllegalArgumentException("Unexpected type of binding " + binding.getName() + " - " + binding.getClass().getSimpleName()));
                continue;
            }
            ArrayList<String> namespaces = new ArrayList<String>();
            try {
                IScope scope = binding.getScope();
                while (scope != null && scope.getKind() == EScopeKind.eNamespace) {
                    IName scopeName = scope.getScopeName();
                    if (scopeName != null) {
                        namespaces.add(new String(scopeName.getSimpleID()));
                    }
                    scope = scope.getParent();
                }
            }
            catch (DOMException scope) {
                // empty catch block
            }
            ForwardDeclarationNode parentNode = declarationType == DeclarationType.TYPE ? typeDeclarationsRoot : nonTypeDeclarationsRoot;
            Collections.reverse(namespaces);
            for (String ns : namespaces) {
                ForwardDeclarationNode node = new ForwardDeclarationNode(ns);
                parentNode = parentNode.findOrAddChild(node);
            }
            ForwardDeclarationNode node = new ForwardDeclarationNode(binding.getName(), declarationText.toString(), declarationType);
            parentNode.findOrAddChild(node);
        }
        StringBuilder buf = new StringBuilder();
        for (ForwardDeclarationNode node : typeDeclarationsRoot.children) {
            if (pendingBlankLine) {
                buf.append(this.fContext.getLineDelimiter());
                pendingBlankLine = false;
            }
            this.printNode(node, buf);
        }
        for (ForwardDeclarationNode node : nonTypeDeclarationsRoot.children) {
            if (pendingBlankLine) {
                buf.append(this.fContext.getLineDelimiter());
                pendingBlankLine = false;
            }
            this.printNode(node, buf);
        }
        if ((pendingBlankLine || buf.length() != 0) && !this.isBlankLineOrEndOfFile(offset)) {
            buf.append(this.fContext.getLineDelimiter());
        }
        if (buf.length() != 0) {
            rootEdit.addChild((TextEdit)new InsertEdit(offset, buf.toString()));
        }
    }

    private void printNode(ForwardDeclarationNode node, StringBuilder buf) throws CoreException {
        if (node.declaration == null) {
            buf.append(CodeGeneration.getNamespaceBeginContent(this.fContext.getTranslationUnit(), node.name, this.fContext.getLineDelimiter()));
            for (ForwardDeclarationNode child : node.children) {
                this.printNode(child, buf);
            }
            buf.append(CodeGeneration.getNamespaceEndContent(this.fContext.getTranslationUnit(), node.name, this.fContext.getLineDelimiter()));
        } else {
            buf.append(node.declaration);
        }
        buf.append(this.fContext.getLineDelimiter());
    }

    private void createCommentOut(IASTPreprocessorIncludeStatement include, MultiTextEdit rootEdit) {
        IASTFileLocation location = include.getFileLocation();
        int offset = location.getNodeOffset();
        if (this.fContext.getTranslationUnit().isCXXLanguage()) {
            offset = TextUtil.getLineStart((String)this.fContext.getSourceContents(), (int)offset);
            rootEdit.addChild((TextEdit)new InsertEdit(offset, "//"));
        } else {
            rootEdit.addChild((TextEdit)new InsertEdit(offset, "/*"));
            int endOffset = offset + location.getNodeLength();
            rootEdit.addChild((TextEdit)new InsertEdit(endOffset, "*/"));
        }
    }

    private void createDelete(IASTPreprocessorIncludeStatement include, MultiTextEdit rootEdit) {
        IASTFileLocation location = include.getFileLocation();
        int offset = location.getNodeOffset();
        int endOffset = offset + location.getNodeLength();
        offset = TextUtil.getLineStart((String)this.fContext.getSourceContents(), (int)offset);
        endOffset = TextUtil.skipToNextLine((String)this.fContext.getSourceContents(), (int)endOffset);
        rootEdit.addChild((TextEdit)new DeleteEdit(offset, endOffset - offset));
    }

    private void updateIncludePrototypes(Map<IncludePrototype, IncludePrototype> includePrototypes, IncludePrototype prototype) {
        IncludePrototype existing = includePrototypes.get(prototype);
        if (existing == null) {
            includePrototypes.put(prototype, prototype);
        } else {
            existing.setExistingInclude(prototype.getExistingInclude());
        }
    }

    private boolean isBlankLineOrEndOfFile(int offset) {
        String contents = this.fContext.getSourceContents();
        while (offset < contents.length()) {
            char c;
            if ((c = contents.charAt(offset++)) == '\n') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private Set<IBinding> removeBindingsDefinedInIncludedHeaders(IASTTranslationUnit ast, Set<IBinding> bindings, IIndexFileSet reachableHeaders) throws CoreException {
        List<InclusionRequest> requests = this.createInclusionRequests(ast, bindings, true, reachableHeaders);
        HashSet<IPath> allIncludedHeaders = new HashSet<IPath>();
        allIncludedHeaders.addAll(this.fContext.getHeadersAlreadyIncluded());
        allIncludedHeaders.addAll(this.fContext.getHeadersToInclude());
        HashSet<IBinding> filteredBindings = new HashSet<IBinding>(bindings);
        for (InclusionRequest request : requests) {
            if (!this.isSatisfiedByIncludedHeaders(request, allIncludedHeaders)) continue;
            filteredBindings.remove(request.getBinding());
        }
        return filteredBindings;
    }

    protected boolean isSatisfiedByIncludedHeaders(InclusionRequest request, Set<IPath> includedHeaders) throws CoreException {
        for (IIndexFile file : request.getDeclaringFiles().keySet()) {
            IIndexInclude[] includedBy;
            IPath path = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
            if (includedHeaders.contains(path)) {
                return true;
            }
            IIndexInclude[] iIndexIncludeArray = includedBy = this.fContext.getIndex().findIncludedBy(file, -1);
            int n = includedBy.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexInclude include = iIndexIncludeArray[n2];
                path = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)include.getIncludedByLocation());
                if (includedHeaders.contains(path)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void processInclusionRequests(List<InclusionRequest> requests, IASTPreprocessorIncludeStatement[] existingIncludes, HeaderSubstitutor headerSubstitutor) throws CoreException {
        IPath path;
        List<IPath> candidatePaths;
        IPath path22;
        IIndexFile partnerHeader = null;
        for (InclusionRequest request : requests) {
            List<IPath> candidatePaths2 = request.getCandidatePaths();
            if (candidatePaths2.size() != 1 || !this.fContext.isPartnerFile(path22 = candidatePaths2.iterator().next())) continue;
            request.resolve(path22);
            this.fContext.addHeaderToInclude(path22);
            partnerHeader = request.getDeclaringFiles().keySet().iterator().next();
            break;
        }
        if (this.fContext.getPreferences().allowPartnerIndirectInclusion) {
            IPath include;
            if (partnerHeader == null) {
                path22 = existingIncludes;
                int candidatePaths2 = ((IPath)path22).length;
                int n = 0;
                while (n < candidatePaths2) {
                    IIndexFile iIndexFile;
                    include = path22[n];
                    if (include.isPartOfTranslationUnitFile() && (iIndexFile = include.getImportedIndexFile()) != null && this.fContext.isPartnerFile((IPath)new Path(include.getPath()))) {
                        partnerHeader = iIndexFile;
                        break;
                    }
                    ++n;
                }
            }
            if (partnerHeader != null) {
                path22 = partnerHeader.getIncludes();
                int candidatePaths2 = ((IIndexInclude[])path22).length;
                int n = 0;
                while (n < candidatePaths2) {
                    include = path22[n];
                    IIndexFileLocation iIndexFileLocation = include.getIncludesLocation();
                    if (iIndexFileLocation != null) {
                        this.fContext.addHeaderAlreadyIncluded(IndexLocationFactory.getAbsolutePath((IIndexFileLocation)iIndexFileLocation));
                    }
                    ++n;
                }
            }
        }
        for (InclusionRequest request : requests) {
            if (request.isResolved() || this.isExportedBinding(request, headerSubstitutor)) continue;
            candidatePaths = request.getCandidatePaths();
            HashSet<IPath> representativeHeaders = new HashSet<IPath>();
            HashSet<IPath> hashSet = new HashSet<IPath>();
            boolean allRepresented = true;
            for (IPath path3 : candidatePaths) {
                if (this.fContext.isIncluded(path3)) {
                    request.resolve(path3);
                    if (!DEBUG_HEADER_SUBSTITUTION) break;
                    System.out.println(String.valueOf(request.toString()) + (this.fContext.isToBeIncluded(path3) ? " (decided earlier)" : " (was previously included)"));
                    break;
                }
                IPath header2 = headerSubstitutor.getUniqueRepresentativeHeader(path3);
                if (header2 != null) {
                    representativeHeaders.add(header2);
                    hashSet.add(path3);
                    continue;
                }
                allRepresented = false;
            }
            if (request.isResolved() || !allRepresented || representativeHeaders.size() != 1) continue;
            path = (IPath)representativeHeaders.iterator().next();
            request.resolve(path);
            if (DEBUG_HEADER_SUBSTITUTION) {
                System.out.println(String.valueOf(request.toString()) + " (unique representative)");
            }
            if (!this.fContext.isAlreadyIncluded(path)) {
                this.fContext.addHeaderToInclude(path);
            }
            for (IPath header3 : hashSet) {
                if (header3.equals((Object)path)) continue;
                this.fContext.addHeaderAlreadyIncluded(header3);
            }
        }
        for (InclusionRequest request : requests) {
            void var9_21;
            if (request.isResolved() || this.isExportedBinding(request, headerSubstitutor) || (candidatePaths = request.getCandidatePaths()).size() != 1) continue;
            IPath path2 = candidatePaths.iterator().next();
            if (this.fContext.isIncluded(path2)) {
                request.resolve(path2);
                if (!DEBUG_HEADER_SUBSTITUTION) continue;
                System.out.println(String.valueOf(request.toString()) + (this.fContext.isToBeIncluded(path2) ? " (decided earlier)" : " (was previously included)"));
                continue;
            }
            IPath iPath = headerSubstitutor.getPreferredRepresentativeHeader(path2);
            if (iPath.equals((Object)path2) && this.fContext.getPreferences().heuristicHeaderSubstitution) {
                IPath iPath2 = headerSubstitutor.getPreferredRepresentativeHeaderByHeuristic(request);
            }
            request.resolve((IPath)var9_21);
            if (DEBUG_HEADER_SUBSTITUTION) {
                System.out.println(String.valueOf(request.toString()) + " (preferred representative)");
            }
            if (!this.fContext.isAlreadyIncluded((IPath)var9_21)) {
                this.fContext.addHeaderToInclude((IPath)var9_21);
            }
            if (var9_21.equals((Object)path2)) continue;
            this.fContext.addHeaderAlreadyIncluded(path2);
        }
        for (InclusionRequest request : requests) {
            if (request.isResolved() || this.isExportedBinding(request, headerSubstitutor)) continue;
            candidatePaths = request.getCandidatePaths();
            for (IPath path2 : candidatePaths) {
                if (!this.fContext.isIncluded(path2)) continue;
                request.resolve(path2);
                if (!DEBUG_HEADER_SUBSTITUTION) break;
                System.out.println(String.valueOf(request.toString()) + (this.fContext.isToBeIncluded(path2) ? " (decided earlier)" : " (was previously included)"));
                break;
            }
            if (request.isResolved()) continue;
            IPath header4 = this.fHeaderChooser.chooseHeader(request.getBinding().getName(), candidatePaths);
            if (header4 == null) {
                throw new OperationCanceledException();
            }
            request.resolve(header4);
            if (DEBUG_HEADER_SUBSTITUTION) {
                System.out.println(String.valueOf(request.toString()) + " (user's choice)");
            }
            if (this.fContext.isAlreadyIncluded(header4)) continue;
            this.fContext.addHeaderToInclude(header4);
        }
        for (InclusionRequest request : requests) {
            if (request.isResolved()) continue;
            IPath firstIncludedPreviously = null;
            Set<IncludeInfo> exportingHeaders = this.getExportingHeaders(request, headerSubstitutor);
            for (IncludeInfo includeInfo : exportingHeaders) {
                path = this.fContext.resolveInclude(includeInfo);
                if (path == null) continue;
                if (this.fContext.isIncluded(path)) {
                    request.resolve(path);
                    if (!DEBUG_HEADER_SUBSTITUTION) break;
                    System.out.println(String.valueOf(request.toString()) + (this.fContext.isToBeIncluded(path) ? " (decided earlier)" : " (was previously included)"));
                    break;
                }
                if (firstIncludedPreviously != null || !this.fContext.wasIncludedPreviously(path)) continue;
                firstIncludedPreviously = path;
            }
            if (request.isResolved()) continue;
            List<IPath> list = request.getCandidatePaths();
            for (IPath path4 : list) {
                if (this.fContext.isIncluded(path4)) {
                    request.resolve(path4);
                    if (!DEBUG_HEADER_SUBSTITUTION) break;
                    System.out.println(String.valueOf(request.toString()) + (this.fContext.isToBeIncluded(path4) ? " (decided earlier)" : " (was previously included)"));
                    break;
                }
                if (firstIncludedPreviously != null || !this.fContext.wasIncludedPreviously(path4)) continue;
                firstIncludedPreviously = path4;
            }
            if (request.isResolved()) continue;
            if (firstIncludedPreviously != null) {
                request.resolve(firstIncludedPreviously);
                if (DEBUG_HEADER_SUBSTITUTION) {
                    System.out.println(String.valueOf(request.toString()) + " (present in old includes)");
                }
                if (!this.fContext.isAlreadyIncluded(firstIncludedPreviously)) {
                    this.fContext.addHeaderToInclude(firstIncludedPreviously);
                }
            }
            if (request.isResolved()) continue;
            IPath header6 = this.fHeaderChooser.chooseHeader(request.getBinding().getName(), list);
            if (header6 == null) {
                throw new OperationCanceledException();
            }
            request.resolve(header6);
            if (DEBUG_HEADER_SUBSTITUTION) {
                System.out.println(String.valueOf(request.toString()) + (list.size() == 1 ? " (the only choice)" : " (user's choice)"));
            }
            if (this.fContext.isAlreadyIncluded(header6)) continue;
            this.fContext.addHeaderToInclude(header6);
        }
        this.fContext.removeExportedHeaders();
    }

    private boolean isExportedBinding(InclusionRequest request, HeaderSubstitutor headerSubstitutor) {
        return !this.getExportingHeaders(request, headerSubstitutor).isEmpty();
    }

    private Set<IncludeInfo> getExportingHeaders(InclusionRequest request, HeaderSubstitutor headerSubstitutor) {
        String symbol = request.getBindingQualifiedName();
        if (symbol == null) {
            return Collections.emptySet();
        }
        return headerSubstitutor.getExportingHeaders(symbol);
    }

    private List<InclusionRequest> createInclusionRequests(IASTTranslationUnit ast, Set<IBinding> bindingsToInclude, boolean allowDeclarations, IIndexFileSet reachableHeaders) throws CoreException {
        ArrayList<InclusionRequest> requests = new ArrayList<InclusionRequest>(bindingsToInclude.size());
        IIndex index = this.fContext.getIndex();
        block0: for (IBinding binding : bindingsToInclude) {
            int n;
            IASTName[] iASTNameArray;
            IASTName[] declarations;
            IIndexName[] indexNames;
            if (binding instanceof IMacroBinding) {
                indexNames = IIndexName.EMPTY_ARRAY;
                ILocationResolver resolver = (ILocationResolver)ast.getAdapter(ILocationResolver.class);
                iASTNameArray = declarations = resolver.getDeclarations((IMacroBinding)binding);
                int n2 = declarations.length;
                n = 0;
                while (n < n2) {
                    IIndexName indexName;
                    IASTName name = iASTNameArray[n];
                    if (name instanceof IAdaptable && (indexName = (IIndexName)((IAdaptable)name).getAdapter(IIndexName.class)) != null) {
                        indexNames = Arrays.copyOf(indexNames, indexNames.length + 1);
                        indexNames[indexNames.length - 1] = indexName;
                    }
                    ++n;
                }
            } else if (allowDeclarations || binding instanceof IVariable) {
                indexNames = index.findDeclarations(binding);
            } else if (binding instanceof ICPPMethod) {
                HashSet<IIndexFile> declarationFiles = new HashSet<IIndexFile>();
                iASTNameArray = declarations = index.findNames(binding, 1);
                int n3 = declarations.length;
                n = 0;
                while (n < n3) {
                    IASTName declaration = iASTNameArray[n];
                    IIndexFile file = declaration.getFile();
                    if (file != null) {
                        declarationFiles.add(file);
                    }
                    ++n;
                }
                IIndexName[] definitions = index.findDefinitions(binding);
                indexNames = this.filterIncludableNotInBlacklistedFiles(definitions, declarationFiles);
            } else {
                indexNames = index.findDefinitions(binding);
                if (binding instanceof IFunction) {
                    indexNames = this.filterIncludableNotInBlacklistedFiles(indexNames, Collections.emptySet());
                }
                if (indexNames.length == 0) {
                    indexNames = index.findDeclarations(binding);
                }
            }
            if (indexNames.length == 0) continue;
            IIndexName[] iIndexNameArray = indexNames;
            int definitions = indexNames.length;
            int declarations2 = 0;
            while (declarations2 < definitions) {
                IIndexName indexName = iIndexNameArray[declarations2];
                IIndexFile indexFile = indexName.getFile();
                if (indexFile.getLocation().getURI().equals(this.fContext.getTranslationUnit().getLocationURI())) continue block0;
                ++declarations2;
            }
            HashMap<IIndexFile, IPath> declaringHeaders = new HashMap<IIndexFile, IPath>();
            HashMap<IIndexFile, IPath> reachableDeclaringHeaders = new HashMap<IIndexFile, IPath>();
            iASTNameArray = indexNames;
            int n4 = indexNames.length;
            int n5 = 0;
            while (n5 < n4) {
                IASTName indexName = iASTNameArray[n5];
                IIndexFile indexFile = indexName.getFile();
                if (this.fContext.canBeIncluded(indexFile)) {
                    IPath path = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)indexFile.getLocation());
                    declaringHeaders.put(indexFile, path);
                    if (reachableHeaders.contains(indexFile)) {
                        reachableDeclaringHeaders.put(indexFile, path);
                    }
                }
                ++n5;
            }
            if (declaringHeaders.isEmpty()) continue;
            boolean reachable = false;
            if (!reachableDeclaringHeaders.isEmpty()) {
                reachable = true;
                declaringHeaders = reachableDeclaringHeaders;
            }
            requests.add(new InclusionRequest(binding, declaringHeaders, reachable));
        }
        return requests;
    }

    private IIndexName[] filterIncludableNotInBlacklistedFiles(IIndexName[] names, Set<IIndexFile> blacklist) throws CoreException {
        Object[] includable = IIndexName.EMPTY_ARRAY;
        int pos = 0;
        IIndexName[] iIndexNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexName name = iIndexNameArray[n2];
            IIndexFile file = name.getFile();
            if (file != null && !blacklist.contains(file) && this.fContext.canBeIncluded(file)) {
                includable = (IIndexName[])ArrayUtil.appendAt((Object[])includable, (int)pos++, (Object)name);
            }
            ++n2;
        }
        return (IIndexName[])ArrayUtil.trim((Object[])includable, (int)pos);
    }

    private String createIncludeDirective(IncludePrototype include, String lineComment) {
        StringBuilder buf = new StringBuilder();
        if (!include.isRequired() && include.getHeader() != null && !this.fContext.isPartnerFile(include.getHeader())) {
            switch (this.fContext.getPreferences().unusedStatementsDisposition) {
                case REMOVE: {
                    return null;
                }
                case COMMENT_OUT: {
                    buf.append("//");
                    break;
                }
            }
        }
        buf.append(include.getIncludeInfo().composeIncludeStatement());
        buf.append(lineComment);
        return buf.toString();
    }

    private boolean hasPragmaKeep(IASTPreprocessorIncludeStatement include, NodeCommentMap commentedNodeMap) {
        List comments = commentedNodeMap.getTrailingCommentsForNode((IASTNode)include);
        for (IASTComment comment : comments) {
            String text = this.getTrimmedCommentText(comment);
            if (!this.fContext.getKeepPragmaPattern().matcher(text).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private String getTrimmedCommentText(IASTComment comment) {
        text = comment.getComment();
        end = text.length - (comment.isBlockComment() != false ? 2 : 0);
        begin = 2;
        while (begin < end) {
            if (!Character.isWhitespace(text[begin])) break;
            ++begin;
        }
        if (end > begin) ** GOTO lbl-1000
        return "";
        while (Character.isWhitespace(text[end])) lbl-1000:
        // 2 sources

        {
            if (--end >= begin) continue;
        }
        return new String(text, begin, end + 1 - begin);
    }

    private static enum DeclarationType {
        TYPE,
        FUNCTION,
        VARIABLE,
        NAMESPACE;

    }

    private static class ForwardDeclarationNode
    implements Comparable<ForwardDeclarationNode> {
        final String name;
        final String declaration;
        final DeclarationType type;
        final List<ForwardDeclarationNode> children;

        ForwardDeclarationNode(String name) {
            this.name = name;
            this.declaration = null;
            this.type = DeclarationType.NAMESPACE;
            this.children = new ArrayList<ForwardDeclarationNode>();
        }

        ForwardDeclarationNode(String name, String declaration, DeclarationType type) {
            this.name = name;
            this.declaration = declaration;
            this.type = type;
            this.children = null;
        }

        ForwardDeclarationNode findOrAddChild(ForwardDeclarationNode node) {
            int i = Collections.binarySearch(this.children, node);
            if (i >= 0) {
                return this.children.get(i);
            }
            this.children.add(-(i + 1), node);
            return node;
        }

        @Override
        public int compareTo(ForwardDeclarationNode other) {
            int c = this.type.ordinal() - other.type.ordinal();
            if (c != 0) {
                return c;
            }
            c = COLLATOR.compare(this.name, other.name);
            if (this.declaration == null || c != 0) {
                return c;
            }
            return COLLATOR.compare(this.declaration, other.declaration);
        }
    }

    private static class IncludePrototype
    extends StyledInclude {
        private final boolean required;

        IncludePrototype(IPath header, IncludeInfo includeInfo, IncludeGroupStyle style) {
            super(header, includeInfo, style);
            this.required = true;
        }

        IncludePrototype(IPath header, IncludeInfo includeInfo, IncludeGroupStyle style, IASTPreprocessorIncludeStatement existingInclude, boolean required) {
            super(header, includeInfo, style, existingInclude);
            this.required = required;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

