/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl2;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class RunToLine
implements IRunToLine,
IRunToAddress {
    private final IRunControl.IExecutionDMContext fContext;

    public RunToLine(IRunControl.IExecutionDMContext context) {
        this.fContext = context;
    }

    public boolean canRunToLine(IFile file, int lineNumber) {
        return this.canRunToLine(file.getLocation().makeAbsolute().toOSString(), lineNumber);
    }

    public boolean canRunToLine(final String fileName, final int lineNumber) {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            try {
                Query<Boolean> query = new Query<Boolean>(){

                    protected void execute(DataRequestMonitor<Boolean> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), RunToLine.this.fContext.getSessionId());
                        IRunControl2 runControl = (IRunControl2)tracker.getService(IRunControl2.class);
                        if (runControl != null) {
                            runControl.canRunToLine(RunToLine.this.fContext, fileName, lineNumber, rm);
                        } else {
                            rm.setData((Object)false);
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                return (Boolean)query.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        return false;
    }

    public void runToLine(IFile file, int lineNumber, boolean skipBreakpoints) throws DebugException {
        this.runToLine(file.getLocation().makeAbsolute().toOSString(), lineNumber, skipBreakpoints);
    }

    public void runToLine(final String fileName, final int lineNumber, final boolean skipBreakpoints) throws DebugException {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            Exception exception = null;
            try {
                Query<Object> query = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), RunToLine.this.fContext.getSessionId());
                        IRunControl2 runControl = (IRunControl2)tracker.getService(IRunControl2.class);
                        if (runControl != null) {
                            runControl.runToLine(RunToLine.this.fContext, fileName, lineNumber, skipBreakpoints, rm);
                        } else {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "IRunControl2 service not available", null));
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                query.get();
            }
            catch (RejectedExecutionException e) {
                exception = e;
            }
            catch (InterruptedException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                exception = e;
            }
            if (exception != null) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Failed executing run to line", (Throwable)exception));
            }
        } else {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Debug session is not active", null));
        }
    }

    public boolean canRunToAddress(final IAddress address) {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            try {
                Query<Boolean> query = new Query<Boolean>(){

                    protected void execute(DataRequestMonitor<Boolean> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), RunToLine.this.fContext.getSessionId());
                        IRunControl2 runControl = (IRunControl2)tracker.getService(IRunControl2.class);
                        if (runControl != null) {
                            runControl.canRunToAddress(RunToLine.this.fContext, address, rm);
                        } else {
                            rm.setData((Object)false);
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                return (Boolean)query.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        return false;
    }

    public void runToAddress(final IAddress address, final boolean skipBreakpoints) throws DebugException {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            Exception exception = null;
            try {
                Query<Object> query = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), RunToLine.this.fContext.getSessionId());
                        IRunControl2 runControl = (IRunControl2)tracker.getService(IRunControl2.class);
                        if (runControl != null) {
                            runControl.runToAddress(RunToLine.this.fContext, address, skipBreakpoints, rm);
                        } else {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "IRunControl2 service not available", null));
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                query.get();
            }
            catch (RejectedExecutionException e) {
                exception = e;
            }
            catch (InterruptedException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                exception = e;
            }
            if (exception != null) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Failed executing run to line", (Throwable)exception));
            }
        } else {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Debug session is not active", null));
        }
    }
}

