/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.core.runtime.PlatformObject;

public class CVariable
extends PlatformObject
implements ICInternalBinding,
IVariable {
    private IASTName[] declarations = null;
    private IType type = null;
    private static final ThreadLocal<Set<CVariable>> fInitialValueInProgress = new ThreadLocal<Set<CVariable>>(){

        @Override
        protected Set<CVariable> initialValue() {
            return new HashSet<CVariable>();
        }
    };

    public CVariable(IASTName name) {
        this.declarations = new IASTName[]{name};
    }

    @Override
    public IASTNode getPhysicalNode() {
        return this.declarations[0];
    }

    public void addDeclaration(IASTName name) {
        if (name != null && name.isActive()) {
            this.declarations = ArrayUtil.append(IASTName.class, this.declarations, name);
        }
    }

    @Override
    public IType getType() {
        if (this.type == null && this.declarations[0].getParent() instanceof IASTDeclarator) {
            this.type = CVisitor.createType((IASTDeclarator)this.declarations[0].getParent());
        }
        return this.type;
    }

    @Override
    public String getName() {
        return this.declarations[0].toString();
    }

    @Override
    public char[] getNameCharArray() {
        return this.declarations[0].toCharArray();
    }

    @Override
    public IScope getScope() {
        IASTDeclarator declarator = (IASTDeclarator)this.declarations[0].getParent();
        return CVisitor.getContainingScope(declarator.getParent());
    }

    @Override
    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    public boolean hasStorageClass(int storage) {
        if (this.declarations == null) {
            return false;
        }
        int i = 0;
        while (i < this.declarations.length && this.declarations[i] != null) {
            IASTDeclSpecifier declSpec;
            IASTName name = this.declarations[i];
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            if (parent instanceof IASTSimpleDeclaration && (declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier()).getStorageClass() == storage) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    @Override
    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    @Override
    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    @Override
    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public IASTNode getDefinition() {
        return this.getPhysicalNode();
    }

    @Override
    public IBinding getOwner() {
        if (this.declarations == null || this.declarations.length == 0) {
            return null;
        }
        return CVisitor.findDeclarationOwner(this.declarations[0], true);
    }

    @Override
    public IValue getInitialValue() {
        block8: {
            Set<CVariable> recursionProtectionSet = fInitialValueInProgress.get();
            if (!recursionProtectionSet.add(this)) {
                return Value.UNKNOWN;
            }
            try {
                if (this.declarations == null) break block8;
                IASTName[] iASTNameArray = this.declarations;
                int n = this.declarations.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName decl = iASTNameArray[n2];
                    if (decl == null) {
                        break;
                    }
                    IValue val = this.getInitialValue(decl);
                    if (val != null) {
                        IValue iValue = val;
                        return iValue;
                    }
                    ++n2;
                }
            }
            finally {
                recursionProtectionSet.remove(this);
            }
        }
        return null;
    }

    private IValue getInitialValue(IASTName name) {
        IASTDeclarator dtor = this.findDeclarator(name);
        if (dtor != null) {
            IASTInitializerClause initClause;
            IASTInitializer init = dtor.getInitializer();
            if (init instanceof IASTEqualsInitializer && (initClause = ((IASTEqualsInitializer)init).getInitializerClause()) instanceof IASTExpression) {
                return Value.create((IASTExpression)initClause);
            }
            if (init != null) {
                return Value.UNKNOWN;
            }
        }
        return null;
    }

    private IASTDeclarator findDeclarator(IASTName name) {
        IASTNode node = name.getParent();
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        return ASTQueries.findOutermostDeclarator((IASTDeclarator)node);
    }

    public String toString() {
        return this.getName();
    }
}

