/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalEnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPEnumerator
extends PlatformObject
implements ICPPInternalEnumerator,
ICPPInternalBinding {
    private IASTName enumName;
    private IType internalType;

    public CPPEnumerator(IASTName enumerator) {
        this.enumName = enumerator;
        enumerator.setBinding(this);
    }

    @Override
    public IASTNode[] getDeclarations() {
        return null;
    }

    @Override
    public IASTNode getDefinition() {
        return this.enumName;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        return this.enumName.getSimpleID();
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.enumName);
    }

    public IASTNode getPhysicalNode() {
        return this.enumName;
    }

    @Override
    public IType getType() {
        IASTEnumerationSpecifier.IASTEnumerator etor = (IASTEnumerationSpecifier.IASTEnumerator)this.enumName.getParent();
        IASTInternalEnumerationSpecifier enumSpec = (IASTInternalEnumerationSpecifier)etor.getParent();
        if (enumSpec.isValueComputationInProgress()) {
            if (this.internalType != null) {
                return this.internalType;
            }
            ICPPEnumeration binding = (ICPPEnumeration)enumSpec.getName().resolveBinding();
            IType fixedType = binding.getFixedType();
            return fixedType != null ? fixedType : ProblemType.UNKNOWN_FOR_EXPRESSION;
        }
        return (IType)((Object)enumSpec.getName().resolveBinding());
    }

    @Override
    public IType getInternalType() {
        if (this.internalType == null) {
            this.getValue();
        }
        return this.internalType;
    }

    public void setInternalType(IType type) {
        this.internalType = type;
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    @Override
    public void addDefinition(IASTNode node) {
    }

    @Override
    public void addDeclaration(IASTNode node) {
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        return CPPVisitor.findDeclarationOwner(this.enumName, true);
    }

    @Override
    public IValue getValue() {
        IASTNode parent = this.enumName.getParent();
        if (parent instanceof ASTEnumerator) {
            return ((ASTEnumerator)parent).getIntegralValue();
        }
        return Value.UNKNOWN;
    }

    public String toString() {
        return this.getName();
    }
}

