/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

class LazyProgressMonitor
extends ProgressMonitorWrapper {
    private static final int MAX_STEPS = 100;
    private final IProgressMonitor monitor;
    private int totalWork;
    private int work;
    private int lastWorked;
    private int treshold;

    protected LazyProgressMonitor(IProgressMonitor monitor) {
        super(monitor);
        this.monitor = monitor;
    }

    public void beginTask(String name, int totalWork) {
        if (totalWork > 0) {
            this.totalWork = totalWork;
        }
        this.monitor.beginTask(name, totalWork);
        this.work = 0;
        this.lastWorked = 0;
        this.treshold = 1 + totalWork / 100;
    }

    public void worked(int newWork) {
        this.work += newWork;
        if (this.work >= this.treshold) {
            this.monitor.worked(this.work - this.lastWorked);
            this.lastWorked = this.work;
            this.treshold = this.work + 1 + this.totalWork / 100;
        }
    }
}

