/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.commenthandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.rewrite.util.ASTNodes;

public class NodeCommentMap {
    protected final Map<IASTNode, List<IASTComment>> leadingMap = new HashMap<IASTNode, List<IASTComment>>();
    protected final Map<IASTNode, List<IASTComment>> trailingMap = new HashMap<IASTNode, List<IASTComment>>();
    protected final Map<IASTNode, List<IASTComment>> freestandingMap = new HashMap<IASTNode, List<IASTComment>>();
    protected final List<IASTTranslationUnit> coveredUnits = new ArrayList<IASTTranslationUnit>();

    public void addTrailingCommentToNode(IASTNode node, IASTComment comment) {
        List<IASTComment> comments = this.trailingMap.get(node);
        if (comments == null) {
            comments = new ArrayList<IASTComment>();
        }
        comments.add(comment);
        this.trailingMap.put(node, comments);
    }

    public List<IASTComment> getTrailingCommentsForNode(IASTNode node) {
        ArrayList list = this.trailingMap.get(node);
        return list != null ? list : new ArrayList();
    }

    public void addLeadingCommentToNode(IASTNode node, IASTComment comment) {
        List<IASTComment> comments = this.leadingMap.get(node);
        if (comments == null) {
            comments = new ArrayList<IASTComment>();
        }
        comments.add(comment);
        this.leadingMap.put(node, comments);
    }

    public List<IASTComment> getLeadingCommentsForNode(IASTNode node) {
        ArrayList list = this.leadingMap.get(node);
        return list != null ? list : new ArrayList();
    }

    public void addFreestandingCommentToNode(IASTNode node, IASTComment comment) {
        List<IASTComment> comments = this.freestandingMap.get(node);
        if (comments == null) {
            comments = new ArrayList<IASTComment>();
        }
        comments.add(comment);
        this.freestandingMap.put(node, comments);
    }

    public List<IASTComment> getFreestandingCommentsForNode(IASTNode node) {
        ArrayList list = this.freestandingMap.get(node);
        return list != null ? list : new ArrayList();
    }

    public Map<IASTNode, List<IASTComment>> getLeadingMap() {
        return this.leadingMap;
    }

    public Map<IASTNode, List<IASTComment>> getTrailingMap() {
        return this.trailingMap;
    }

    public Map<IASTNode, List<IASTComment>> getFreestandingMap() {
        return this.freestandingMap;
    }

    public List<IASTComment> getAllCommentsForNode(IASTNode node) {
        ArrayList<IASTComment> comment = new ArrayList<IASTComment>();
        comment.addAll(this.getFreestandingCommentsForNode(node));
        comment.addAll(this.getLeadingCommentsForNode(node));
        comment.addAll(this.getTrailingCommentsForNode(node));
        return comment;
    }

    public int getOffsetIncludingComments(IASTNode node) {
        int offset = ASTNodes.offset(node);
        List<IASTComment> comments = this.leadingMap.get(node);
        if (comments != null && !comments.isEmpty()) {
            for (IASTComment comment : comments) {
                int commentOffset = ASTNodes.offset(comment);
                if (commentOffset >= offset) continue;
                offset = commentOffset;
            }
        }
        return offset;
    }

    public int getEndOffsetIncludingComments(IASTNode node) {
        int endOffset = 0;
        while (true) {
            IASTNode[] children;
            List<IASTComment> comments;
            IASTFileLocation fileLocation;
            if ((fileLocation = node.getFileLocation()) != null) {
                endOffset = Math.max(endOffset, fileLocation.getNodeOffset() + fileLocation.getNodeLength());
            }
            if ((comments = this.trailingMap.get(node)) != null && !comments.isEmpty()) {
                for (IASTComment comment : comments) {
                    int commentEndOffset = ASTNodes.endOffset(comment);
                    if (commentEndOffset < endOffset) continue;
                    endOffset = commentEndOffset;
                }
            }
            if ((children = node.getChildren()).length == 0) break;
            node = children[children.length - 1];
        }
        return endOffset;
    }

    public void setASTCovered(IASTTranslationUnit ast) {
        this.coveredUnits.add(ast);
    }

    public boolean isASTCovered(IASTTranslationUnit ast) {
        return this.coveredUnits.contains(ast);
    }
}

