/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal.target;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.launchbar.core.internal.target.LaunchTarget;
import org.eclipse.launchbar.core.internal.target.LaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetWorkingCopy;
import org.osgi.service.prefs.BackingStoreException;

public class LaunchTargetWorkingCopy
extends PlatformObject
implements ILaunchTargetWorkingCopy {
    private final LaunchTarget original;
    private final Map<String, String> changes = new HashMap<String, String>();
    private String newId;

    public LaunchTargetWorkingCopy(LaunchTarget original) {
        this.original = original;
    }

    @Override
    public ILaunchTarget getOriginal() {
        return this.original;
    }

    @Override
    public String getTypeId() {
        return this.original.getTypeId();
    }

    @Override
    public String getId() {
        return this.newId != null ? this.newId : this.original.getId();
    }

    @Override
    public void setId(String id) {
        this.newId = id;
    }

    @Override
    public ILaunchTargetWorkingCopy getWorkingCopy() {
        return this;
    }

    @Override
    public String getAttribute(String key, String defValue) {
        if (this.changes.containsKey(key)) {
            return this.changes.get(key);
        }
        return this.original.getAttribute(key, defValue);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.changes.put(key, value);
    }

    @Override
    public ILaunchTarget save() {
        try {
            LaunchTarget target;
            if (this.newId == null) {
                target = this.original;
            } else {
                LaunchTargetManager manager = Activator.getLaunchTargetManager();
                target = (LaunchTarget)manager.addLaunchTarget(this.original.getTypeId(), this.newId);
                String[] stringArray = this.original.attributes.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    target.attributes.put(key, this.original.getAttribute(key, ""));
                    ++n2;
                }
                manager.removeLaunchTarget(this.original);
            }
            for (Map.Entry<String, String> entry : this.changes.entrySet()) {
                target.attributes.put(entry.getKey(), entry.getValue());
            }
            target.attributes.flush();
            return target;
        }
        catch (BackingStoreException e) {
            Activator.log(e);
            return this.original;
        }
    }
}

