/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPMethod
extends PDOMCPPFunction
implements ICPPMethod {
    private static final int ANNOTATION1 = 64;
    protected static final int RECORD_SIZE = 65;
    private static final int CV_OFFSET = 7;
    private byte annotation1 = (byte)-1;

    public PDOMCPPMethod(PDOMCPPLinkage linkage, PDOMNode parent, ICPPMethod method, IASTNode point) throws CoreException, DOMException {
        super(linkage, parent, method, true, point);
        Database db = this.getDB();
        try {
            this.annotation1 = PDOMCPPAnnotation.encodeExtraAnnotation(method);
            db.putByte(this.record + 64L, this.annotation1);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPMethod(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    public final void update(PDOMLinkage linkage, IBinding newBinding, IASTNode point) throws CoreException {
        if (newBinding instanceof ICPPMethod) {
            ICPPMethod method = (ICPPMethod)newBinding;
            super.update(linkage, newBinding, point);
            this.annotation1 = (byte)-1;
            try {
                byte annot = PDOMCPPAnnotation.encodeExtraAnnotation(method);
                this.getDB().putByte(this.record + 64L, annot);
                this.annotation1 = annot;
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
        } else if (newBinding == null && this.isImplicit()) {
            byte annot = (byte)(this.getAnnotation1() ^ 4);
            this.getDB().putByte(this.record + 64L, annot);
            this.annotation1 = annot;
        }
    }

    @Override
    protected int getRecordSize() {
        return 65;
    }

    @Override
    public int getNodeType() {
        return 10;
    }

    @Override
    public boolean isVirtual() {
        return PDOMCPPMethod.getBit(this.getAnnotation1(), 0);
    }

    protected byte getAnnotation1() {
        if (this.annotation1 == -1) {
            this.annotation1 = this.getByte(this.record + 64L);
        }
        return this.annotation1;
    }

    @Override
    public boolean isPureVirtual() {
        return PDOMCPPMethod.getBit(this.getAnnotation1(), 4);
    }

    @Override
    public boolean isDestructor() {
        return PDOMCPPMethod.getBit(this.getAnnotation1(), 1);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return PDOMCPPMethod.getBit(this.getAnnotation1(), 2);
    }

    @Override
    public boolean isExplicit() {
        return PDOMCPPMethod.getBit(this.getAnnotation1(), 3);
    }

    @Override
    public IScope getFunctionScope() {
        return null;
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public int getVisibility() {
        return PDOMCPPAnnotation.getVisibility(this.getAnnotation());
    }

    @Override
    public ICPPClassType getClassOwner() {
        return (ICPPClassType)((Object)this.getOwner());
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public boolean isConst() {
        return PDOMCPPMethod.getBit(this.getAnnotation1(), 7);
    }

    public boolean isVolatile() {
        return PDOMCPPMethod.getBit(this.getAnnotation1(), 8);
    }

    @Override
    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTQualifiedName) {
                if ((parent = parent.getParent()) instanceof IASTIdExpression && (parent = parent.getParent()) instanceof IASTUnaryExpression && ((IASTUnaryExpression)parent).getOperator() == 5) {
                    return 16;
                }
            } else if (parent instanceof ICPPASTFieldReference) {
                ICPPASTFieldReference fr = (ICPPASTFieldReference)parent;
                if ((parent = parent.getParent()) instanceof IASTFunctionCallExpression) {
                    if (fr.isPointerDereference()) {
                        return 16;
                    }
                    IASTExpression fieldOwner = fr.getFieldOwner();
                    if (fieldOwner.getValueCategory().isGLValue()) {
                        IType t;
                        IBinding b;
                        while (fieldOwner instanceof IASTUnaryExpression && ((IASTUnaryExpression)fieldOwner).getOperator() == 11) {
                            fieldOwner = ((IASTUnaryExpression)fieldOwner).getOperand();
                        }
                        if (fieldOwner instanceof IASTIdExpression && (b = ((IASTIdExpression)fieldOwner).getName().resolveBinding()) instanceof IVariable && !((t = ((IVariable)b).getType()) instanceof ICPPReferenceType)) {
                            return 0;
                        }
                        return 16;
                    }
                }
            } else if (parent instanceof IASTIdExpression && parent.getParent() instanceof IASTFunctionCallExpression) {
                return 16;
            }
        }
        return 0;
    }

    @Override
    public IType[] getExceptionSpecification() {
        if (this.isImplicit()) {
            return ClassTypeHelper.getInheritedExceptionSpecification(this, null);
        }
        return super.getExceptionSpecification();
    }

    @Override
    public boolean isOverride() {
        return PDOMCPPMethod.getBit(this.getAnnotation1(), 5);
    }

    @Override
    public boolean isFinal() {
        return PDOMCPPMethod.getBit(this.getAnnotation1(), 6);
    }
}

