/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultLabelProvider;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.SearchResultViewer;
import org.eclipse.search.internal.ui.SelectAllAction;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IContextMenuContributor;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.ViewPart;

@Deprecated
public class SearchResultView
extends ViewPart
implements ISearchResultView {
    private static Map<String, ILabelProvider> fgLabelProviders = new HashMap<String, ILabelProvider>(5);
    private SearchResultViewer fViewer;
    private Map<Object, SearchResultViewEntry> fResponse;
    private IMemento fMemento;
    private IPropertyChangeListener fPropertyChangeListener;
    private CellEditorActionHandler fCellEditorActionHandler;
    private SelectAllAction fSelectAllAction;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        this.fViewer.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        Assert.isTrue((this.fViewer == null ? 1 : 0) != 0);
        this.fViewer = new SearchResultViewer(this, parent);
        if (this.fMemento != null) {
            this.fViewer.restoreState(this.fMemento);
        }
        this.fMemento = null;
        SearchManager.getDefault().addSearchChangeListener(this.fViewer);
        this.fViewer.init();
        this.fCellEditorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.fSelectAllAction = new SelectAllAction();
        this.fSelectAllAction.setViewer((StructuredViewer)this.fViewer);
        this.fCellEditorActionHandler.setSelectAllAction((IAction)this.fSelectAllAction);
        this.fillActionBars(this.getViewSite().getActionBars());
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (("org.eclipse.search.potentialMatch.fgColor".equals(event.getProperty()) || "org.eclipse.search.potentialMatch.emphasize".equals(event.getProperty())) && SearchResultView.this.fViewer != null) {
                    SearchResultView.this.fViewer.updatedPotentialMatchFgColor();
                }
            }
        };
        SearchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fViewer.getControl(), SearchPlugin.getDefault().getSearchViewHelpContextId());
    }

    public SearchResultViewer getViewer() {
        return this.fViewer;
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.fViewer != null) {
            SearchManager.getDefault().removeSearchChangeListener(this.fViewer);
            this.fViewer = null;
        }
        if (this.fPropertyChangeListener != null) {
            SearchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        }
        if (this.fCellEditorActionHandler != null) {
            this.fCellEditorActionHandler.dispose();
            this.fCellEditorActionHandler = null;
        }
        super.dispose();
    }

    protected void setContentDescription(String title) {
        super.setContentDescription(title);
    }

    protected void setTitleToolTip(String text) {
        super.setTitleToolTip(text);
    }

    private void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        actionBars.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
    }

    private void fillToolBar(IToolBarManager tbm) {
        this.fViewer.fillToolBar(tbm);
    }

    ILabelProvider getLabelProvider(String pageId) {
        if (pageId != null) {
            return fgLabelProviders.get(pageId);
        }
        return null;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        if (this.fViewer == null) {
            return null;
        }
        IBaseLabelProvider labelProvider = this.fViewer.getLabelProvider();
        if (labelProvider == null) {
            return null;
        }
        return ((SearchResultLabelProvider)labelProvider).getLabelProvider();
    }

    private void setGotoMarkerAction(final IAction gotoMarkerAction) {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SearchResultView.this.getViewer().setGotoMarkerAction(gotoMarkerAction);
            }
        });
    }

    Display getDisplay() {
        return this.fViewer.getControl().getDisplay();
    }

    @Override
    public ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    @Override
    public void searchStarted(IActionGroupFactory groupFactory, String singularLabel, String pluralLabelPattern, ImageDescriptor imageDescriptor, String pageId, ILabelProvider labelProvider, IAction gotoAction, IGroupByKeyComputer groupByKeyComputer, IRunnableWithProgress operation) {
        Assert.isNotNull((Object)pageId);
        Assert.isNotNull((Object)pluralLabelPattern);
        Assert.isNotNull((Object)gotoAction);
        this.fResponse = new HashMap<Object, SearchResultViewEntry>(500);
        this.setGotoMarkerAction(gotoAction);
        ILabelProvider oldLabelProvider = fgLabelProviders.get(pageId);
        if (oldLabelProvider != null) {
            oldLabelProvider.dispose();
        }
        fgLabelProviders.put(pageId, labelProvider);
        SearchManager.getDefault().addNewSearch(new Search(pageId, singularLabel, pluralLabelPattern, null, imageDescriptor, this.fViewer.getGotoMarkerAction(), groupFactory, groupByKeyComputer, operation));
    }

    @Override
    public void searchStarted(String pageId, String label, ImageDescriptor imageDescriptor, IContextMenuContributor contributor, ILabelProvider labelProvider, IAction gotoAction, IGroupByKeyComputer groupByKeyComputer, IRunnableWithProgress operation) {
        this.searchStarted(pageId, null, label, imageDescriptor, contributor, labelProvider, gotoAction, groupByKeyComputer, operation);
    }

    @Override
    public void searchStarted(String pageId, String singularLabel, String pluralLabelPattern, ImageDescriptor imageDescriptor, IContextMenuContributor contributor, ILabelProvider labelProvider, IAction gotoAction, IGroupByKeyComputer groupByKeyComputer, IRunnableWithProgress operation) {
        Assert.isNotNull((Object)pageId);
        Assert.isNotNull((Object)pluralLabelPattern);
        Assert.isNotNull((Object)gotoAction);
        this.fResponse = new HashMap<Object, SearchResultViewEntry>(500);
        this.setGotoMarkerAction(gotoAction);
        ILabelProvider oldLabelProvider = fgLabelProviders.get(pageId);
        if (oldLabelProvider != null) {
            oldLabelProvider.dispose();
        }
        fgLabelProviders.put(pageId, labelProvider);
        SearchManager.getDefault().addNewSearch(new Search(pageId, singularLabel, pluralLabelPattern, null, imageDescriptor, this.fViewer.getGotoMarkerAction(), contributor, groupByKeyComputer, operation));
    }

    @Override
    public void addMatch(String description, Object groupByKey, IResource resource, IMarker marker) {
        SearchResultViewEntry entry = this.fResponse.get(groupByKey);
        if (entry == null) {
            entry = new SearchResultViewEntry(groupByKey, resource);
            this.fResponse.put(groupByKey, entry);
        }
        entry.add(marker);
    }

    @Override
    public void searchFinished() {
        SearchManager.getDefault().searchFinished(new ArrayList<SearchResultViewEntry>(this.fResponse.values()));
        this.fResponse = null;
    }
}

