/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui;

import org.eclipse.cdt.dsf.gdb.internal.ui.GdbAdapterFactory;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbCliConsoleManager;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.TracingConsoleManager;
import org.eclipse.cdt.dsf.gdb.internal.ui.sync.GdbDebugContextSyncManager;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class GdbUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.dsf.gdb.ui";
    private static GdbUIPlugin plugin;
    private static BundleContext fgBundleContext;
    private static TracingConsoleManager fTracingConsoleManager;
    private static GdbCliConsoleManager fGdbConsoleManager;
    private static GdbDebugContextSyncManager fGdbSelectionSyncManager;
    private static IPreferenceStore fCorePreferenceStore;
    private static Shell debugDialogShell;

    public void start(BundleContext context) throws Exception {
        fgBundleContext = context;
        super.start(context);
        plugin = this;
        fTracingConsoleManager = new TracingConsoleManager();
        fTracingConsoleManager.startup();
        fGdbConsoleManager = new GdbCliConsoleManager();
        fGdbConsoleManager.startup();
        fGdbSelectionSyncManager = new GdbDebugContextSyncManager();
        fGdbSelectionSyncManager.startup();
    }

    public void stop(BundleContext context) throws Exception {
        fTracingConsoleManager.shutdown();
        fGdbConsoleManager.shutdown();
        fGdbSelectionSyncManager.shutdown();
        this.disposeAdapterSets();
        plugin = null;
        super.stop(context);
        fgBundleContext = null;
    }

    public static GdbCliConsoleManager getCliConsoleManager() {
        return fGdbConsoleManager;
    }

    public static GdbDebugContextSyncManager getGdbSelectionSyncManager() {
        return fGdbSelectionSyncManager;
    }

    private void disposeAdapterSets() {
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof GdbLaunch) {
                GdbAdapterFactory.disposeAdapterSet(launch);
            }
            ++n2;
        }
    }

    public static GdbUIPlugin getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return fgBundleContext;
    }

    public IPreferenceStore getPreferenceStore() {
        if (fCorePreferenceStore == null) {
            fCorePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.cdt.dsf.gdb");
        }
        return fCorePreferenceStore;
    }

    public static Shell getShell() {
        if (GdbUIPlugin.getActiveWorkbenchShell() != null) {
            return GdbUIPlugin.getActiveWorkbenchShell();
        }
        if (debugDialogShell != null) {
            if (!debugDialogShell.isDisposed()) {
                return debugDialogShell;
            }
            debugDialogShell = null;
        }
        IWorkbenchWindow[] windows = GdbUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return windows[0].getShell();
    }

    public static void setDialogShell(Shell shell) {
        debugDialogShell = shell;
    }

    public static String getUniqueIdentifier() {
        if (GdbUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return GdbUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        GdbUIPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        GdbUIPlugin.log((IStatus)new Status(4, GdbUIPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        GdbUIPlugin.log((IStatus)new Status(4, GdbUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return GdbUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = GdbUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = GdbUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void errorDialog(String message, IStatus status) {
        GdbUIPlugin.log(status);
        Shell shell = GdbUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)LaunchMessages.getString((String)"LaunchUIPlugin.Error"), (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        GdbUIPlugin.log(t);
        Shell shell = GdbUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, GdbUIPlugin.getUniqueIdentifier(), 1, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)LaunchMessages.getString((String)"LaunchUIPlugin.Error"), (String)message, (IStatus)status);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        this.declareImages(reg);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)path).get();
    }

    public static Image getImage(String key) {
        return GdbUIPlugin.getDefault().getImageRegistry().get(key);
    }

    private void declareImages(ImageRegistry reg) {
        reg.put("org.eclipse.cdt.dsf.gdb.ui.imageAdvancedTimeoutSettings", GdbUIPlugin.getImageDescriptor("icons/full/wizban/advtosettings_wiz.png"));
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = plugin.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

