/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.ui.internal;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.build.gcc.ui.internal.Messages;
import org.eclipse.cdt.build.gcc.ui.internal.NewEnvVarDialog;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ToolChainEnvironmentPage
extends WizardPage {
    private TableViewer tableViewer;
    private Button editButton;
    private Button removeButton;
    private List<IEnvironmentVariable> envvars;

    public ToolChainEnvironmentPage(IToolChain toolChain) {
        super(ToolChainEnvironmentPage.class.getName());
        this.setTitle(Messages.ToolChainEnvironmentPage_Title);
        this.setDescription(Messages.ToolChainEnvironmentPage_Description);
        this.envvars = toolChain != null && toolChain.getVariables() != null ? new LinkedList<IEnvironmentVariable>(Arrays.asList(toolChain.getVariables())) : new LinkedList<IEnvironmentVariable>();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        final Table table = new Table(comp, 67842);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.ToolChainEnvironmentPage_Name);
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        column.setText(Messages.ToolChainEnvironmentPage_Value);
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        column.setText(Messages.ToolChainEnvironmentPage_Operation);
        column.setWidth(75);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ToolChainEnvironmentPage.this.envvars.toArray();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                IEnvironmentVariable var = (IEnvironmentVariable)element;
                switch (columnIndex) {
                    case 0: {
                        return var.getName();
                    }
                    case 1: {
                        return var.getValue();
                    }
                    case 2: {
                        switch (var.getOperation()) {
                            case 1: {
                                return Messages.ToolChainEnvironmentPage_Replace;
                            }
                            case 3: {
                                return Messages.ToolChainEnvironmentPage_Prepend;
                            }
                            case 4: {
                                return Messages.ToolChainEnvironmentPage_Append;
                            }
                            case 2: {
                                return Messages.ToolChainEnvironmentPage_Unset;
                            }
                        }
                    }
                }
                return null;
            }
        });
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setLayoutData((Object)new GridData(4, 4, false, true));
        buttonComp.setLayout((Layout)new GridLayout());
        Button addButton = new Button(buttonComp, 8);
        addButton.setText(Messages.ToolChainEnvironmentPage_Add);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewEnvVarDialog dialog = new NewEnvVarDialog(ToolChainEnvironmentPage.this.getShell());
                if (dialog.open() == 0) {
                    ToolChainEnvironmentPage.this.envvars.add(dialog.getEnvVar());
                    ToolChainEnvironmentPage.this.tableViewer.refresh();
                }
            }
        });
        this.editButton = new Button(buttonComp, 8);
        this.editButton.setText(Messages.ToolChainEnvironmentPage_Edit);
        this.editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolChainEnvironmentPage.this.handleEdit();
            }
        });
        this.removeButton = new Button(buttonComp, 8);
        this.removeButton.setText(Messages.ToolChainEnvironmentPage_Remove);
        this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm((Shell)ToolChainEnvironmentPage.this.getShell(), (String)Messages.ToolChainEnvironmentPage_RemoveTitle, (String)Messages.ToolChainEnvironmentPage_RemoveMessage)) {
                    for (IEnvironmentVariable var : ToolChainEnvironmentPage.this.tableViewer.getStructuredSelection()) {
                        ToolChainEnvironmentPage.this.envvars.remove(var);
                    }
                    ToolChainEnvironmentPage.this.tableViewer.refresh();
                }
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ToolChainEnvironmentPage.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ToolChainEnvironmentPage.this.updateButtons();
                if (table.getSelectionCount() == 1) {
                    ToolChainEnvironmentPage.this.handleEdit();
                }
            }
        });
        this.tableViewer.setInput(this.envvars);
        this.setControl((Control)comp);
    }

    private void updateButtons() {
        int n = this.tableViewer.getTable().getSelectionCount();
        this.editButton.setEnabled(n == 1);
        this.removeButton.setEnabled(n > 0);
    }

    private void handleEdit() {
        IEnvironmentVariable var = (IEnvironmentVariable)this.tableViewer.getStructuredSelection().getFirstElement();
        NewEnvVarDialog dialog = new NewEnvVarDialog(this.getShell(), var);
        if (dialog.open() == 0) {
            this.envvars.remove(var);
            this.envvars.add(dialog.getEnvVar());
            this.tableViewer.refresh();
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getEnvVar()));
        }
    }

    public IEnvironmentVariable[] getEnvVars() {
        return !this.envvars.isEmpty() ? this.envvars.toArray(new IEnvironmentVariable[0]) : null;
    }

    private static abstract class TableLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

