/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.ResourcesUtil;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleDocument;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitionerEditData;
import org.eclipse.cdt.internal.ui.buildconsole.BuildOutputStream;
import org.eclipse.cdt.internal.ui.buildconsole.DocumentMarkerManager;
import org.eclipse.cdt.internal.ui.buildconsole.IBuildConsoleStreamDecorator;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;

public class BuildConsolePartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IConsole,
IPropertyChangeListener {
    private IProject fProject;
    List<BuildConsolePartition> fPartitions = new ArrayList<BuildConsolePartition>();
    BuildConsoleDocument fDocument;
    BuildConsolePartitionerEditData fEditData;
    private AtomicBoolean fEditUiPending = new AtomicBoolean(false);
    DocumentMarkerManager fDocumentMarkerManager;
    BuildConsoleManager fManager;
    private LogFile fLogFile = new LogFile();
    private int fUpdateDelay = 75;
    private long fOffset;

    public BuildConsolePartitioner(BuildConsoleManager manager) {
        this(null, manager);
    }

    public BuildConsolePartitioner(IProject project, BuildConsoleManager manager) {
        this.fProject = project;
        this.fManager = manager;
        this.fEditData = new BuildConsolePartitionerEditData(BuildConsolePreferencePage.buildConsoleLines());
        this.fDocument = new BuildConsoleDocument();
        this.fDocument.setDocumentPartitioner(this);
        this.fDocumentMarkerManager = new DocumentMarkerManager(this.fDocument, this);
        this.fUpdateDelay = BuildConsolePreferencePage.buildConsoleUpdateDelayMs();
        this.connect((IDocument)this.fDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamOpened() {
        LogFile logFile = this.fLogFile;
        synchronized (logFile) {
            LogFile logFile2 = this.fLogFile;
            logFile2.openStreamCount = logFile2.openStreamCount + 1;
            this.logOpen(false);
        }
    }

    public void setStreamAppend() {
        this.logOpen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamClosed() {
        LogFile logFile = this.fLogFile;
        synchronized (logFile) {
            LogFile logFile2 = this.fLogFile;
            logFile2.openStreamCount = logFile2.openStreamCount - 1;
            if (this.fLogFile.openStreamCount <= 0) {
                this.fLogFile.openStreamCount = 0;
                if (this.fLogFile.fLogStream != null) {
                    block10: {
                        try {
                            try {
                                this.fLogFile.fLogStream.close();
                            }
                            catch (IOException e) {
                                CUIPlugin.log(e);
                                ResourcesUtil.refreshWorkspaceFiles((URI)this.fLogFile.fLogURI);
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            ResourcesUtil.refreshWorkspaceFiles((URI)this.fLogFile.fLogURI);
                            throw throwable;
                        }
                        ResourcesUtil.refreshWorkspaceFiles((URI)this.fLogFile.fLogURI);
                    }
                    this.fLogFile.fLogStream = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOpen(boolean append) {
        LogFile logFile = this.fLogFile;
        synchronized (logFile) {
            block10: {
                this.fLogFile.fLogURI = this.fManager.getLogURI(this.fProject);
                if (this.fLogFile.fLogURI != null) {
                    try {
                        try {
                            IFileStore logStore = EFS.getStore((URI)this.fLogFile.fLogURI);
                            IFileStore dir = logStore.getParent();
                            if (dir != null) {
                                dir.mkdir(0, null);
                            }
                            int opts = append ? 1 : 0;
                            this.fLogFile.fLogStream = logStore.openOutputStream(opts, null);
                        }
                        catch (CoreException e) {
                            CUIPlugin.log(e);
                            ResourcesUtil.refreshWorkspaceFiles((URI)this.fLogFile.fLogURI);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        ResourcesUtil.refreshWorkspaceFiles((URI)this.fLogFile.fLogURI);
                        throw throwable;
                    }
                    ResourcesUtil.refreshWorkspaceFiles((URI)this.fLogFile.fLogURI);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String text) {
        LogFile logFile = this.fLogFile;
        synchronized (logFile) {
            if (this.fLogFile.fLogStream != null) {
                try {
                    this.fLogFile.fLogStream.write(text.getBytes());
                    this.fLogFile.fLogStream.flush();
                }
                catch (IOException e) {
                    CUIPlugin.log(e);
                }
            }
        }
    }

    private void scheduleUpdate() {
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null) {
            display.timerExec(this.fUpdateDelay, this::updateUI);
        }
    }

    private void updateUI() {
        this.fEditUiPending.set(false);
        BuildConsolePartitionerEditData.UpdateUIData update = this.fEditData.getUpdate();
        ResourcesUtil.refreshWorkspaceFiles((URI)this.fLogFile.fLogURI);
        update.getStreamsNeedingNotifcation().forEach(this::warnOfContentChange);
        this.fManager.showConsole(update.hasProblemsAdded());
        this.fPartitions = update.getNewPartitions();
        if (update.needsClearDocumentMarkerManager()) {
            this.fDocumentMarkerManager.clear();
        }
        try {
            long offsetChangeSinceLastUpdate = update.getOffset() - this.fOffset;
            int toTrim = (int)Math.min(offsetChangeSinceLastUpdate, (long)this.fDocument.getLength());
            int length = this.fDocument.getLength();
            String newContents = update.getNewContents();
            String appendContents = newContents.substring(length - toTrim);
            this.fDocument.replace(length + toTrim, 0, appendContents);
            if (toTrim > 0) {
                this.fDocument.replace(0, toTrim, "");
            }
        }
        catch (BadLocationException e) {
            this.fDocument.set(update.getNewContents());
        }
        this.fOffset = update.getOffset();
    }

    public void appendToDocument(String text, IBuildConsoleStreamDecorator stream, ProblemMarkerInfo marker) {
        this.log(text);
        if (stream == null) {
            this.fEditData.clear();
        } else {
            this.fEditData.append(text, stream, marker);
        }
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null && !this.fEditUiPending.getAndSet(true)) {
            display.asyncExec(this::scheduleUpdate);
        }
    }

    void warnOfContentChange(IBuildConsoleStreamDecorator stream) {
        if (stream != null) {
            ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange(stream.getConsole());
        }
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocumentSize(int nLines) {
        this.fEditData.setMaxLines(nLines);
    }

    public void connect(IDocument document) {
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void disconnect() {
        this.fDocument.setDocumentPartitioner(null);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{BuildConsolePartition.CONSOLE_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        BuildConsolePartition partition = this.getPartition(offset);
        if (partition != null) {
            return partition.getType();
        }
        return null;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        List<BuildConsolePartition> list = this.computePartitioningAsList(offset, length);
        return list.toArray(new ITypedRegion[list.size()]);
    }

    public List<BuildConsolePartition> computePartitioningAsList(int offset, int length) {
        List<BuildConsolePartition> list;
        if (offset == 0 && length == this.fDocument.getLength()) {
            list = this.fPartitions;
        } else {
            int fromIndex = this.getPartitionIndex(offset);
            int toIndex = this.getPartitionIndex(offset + length - 1);
            if (fromIndex < 0 && toIndex < 0) {
                return Collections.emptyList();
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            } else if (toIndex < 0) {
                toIndex = this.fPartitions.size() - 1;
            }
            list = this.fPartitions.subList(fromIndex, toIndex + 1);
        }
        return list;
    }

    public BuildConsolePartition getPartition(int offset) {
        int partitionIndex = this.getPartitionIndex(offset);
        if (partitionIndex >= 0) {
            return this.fPartitions.get(partitionIndex);
        }
        return null;
    }

    private int getPartitionIndex(int offset) {
        BuildConsolePartition searchTerm = new BuildConsolePartition(null, offset, 0, null, null, 0);
        int index = Collections.binarySearch(this.fPartitions, searchTerm, (a, b) -> Integer.compare(a.getOffset(), b.getOffset()));
        if (index >= 0) {
            return index;
        }
        if (index == -1) {
            return -1;
        }
        if (index == -(this.fPartitions.size() + 1)) {
            BuildConsolePartition lastPartition = this.fPartitions.get(this.fPartitions.size() - 1);
            int lastPartitionEnd = lastPartition.getOffset() + lastPartition.getLength();
            assert (offset >= lastPartition.getOffset());
            if (offset < lastPartitionEnd) {
                return this.fPartitions.size() - 1;
            }
            return -1;
        }
        return -(index + 1) - 1;
    }

    public IRegion documentChanged2(DocumentEvent event) {
        String text = event.getText();
        if (this.getDocument().getLength() == 0) {
            this.fPartitions.clear();
            this.fDocumentMarkerManager.clear();
            this.fEditData.clear();
            return new Region(0, 0);
        }
        List<BuildConsolePartition> affectedRegions = this.computePartitioningAsList(event.getOffset(), text.length());
        if (affectedRegions.size() == 0) {
            return null;
        }
        if (affectedRegions.size() == 1) {
            return (IRegion)affectedRegions.get(0);
        }
        int affectedLength = 0;
        for (BuildConsolePartition region : affectedRegions) {
            affectedLength += region.getLength();
        }
        return new Region(affectedRegions.get(0).getOffset(), affectedLength);
    }

    public IConsole getConsole() {
        return this;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "buildConsoleLines") {
            this.setDocumentSize(BuildConsolePreferencePage.buildConsoleLines());
        }
        if (event.getProperty() == "buildConsoleUpdateDelayMs") {
            this.fUpdateDelay = BuildConsolePreferencePage.buildConsoleUpdateDelayMs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(IProject project) {
        LogFile logFile = this.fLogFile;
        synchronized (logFile) {
            this.fLogFile.fLogStream = null;
            this.fLogFile.fLogURI = null;
        }
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(() -> this.fManager.startConsoleActivity(project));
        }
        if (BuildConsolePreferencePage.isClearBuildConsole()) {
            this.appendToDocument("", null, null);
        }
    }

    public ConsoleOutputStream getOutputStream() throws CoreException {
        return new BuildOutputStream(this, this.fManager.getStreamDecorator(1));
    }

    public ConsoleOutputStream getInfoStream() throws CoreException {
        return new BuildOutputStream(this, this.fManager.getStreamDecorator(0));
    }

    public ConsoleOutputStream getErrorStream() throws CoreException {
        return new BuildOutputStream(this, this.fManager.getStreamDecorator(2));
    }

    public URI getLogURI() {
        return this.fLogFile.fLogURI;
    }

    IProject getProject() {
        return this.fProject;
    }

    private static class LogFile {
        private OutputStream fLogStream;
        private int openStreamCount = 0;
        private URI fLogURI;

        private LogFile() {
        }
    }
}

