/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.eclipse.e4.ui.css.swt.dom.StyledTextElement;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyStyledTextScrollbarSWTHandler
implements ICSSPropertyHandler {
    public static final String SWT_SCROLLBAR_THEMED = "swt-scrollbar-themed";
    public static final String SWT_SCROLLBAR_BACKGROUND_COLOR = "swt-scrollbar-background-color";
    public static final String SWT_SCROLLBAR_FOREGROUND_COLOR = "swt-scrollbar-foreground-color";
    public static final String SWT_SCROLLBAR_WIDTH = "swt-scrollbar-width";
    public static final String SWT_SCROLLBAR_MOUSE_NEAR_SCROLL_WIDTH = "swt-scrollbar-mouse-near-scroll-width";
    public static final String SWT_SCROLLBAR_VERTICAL_VISIBLE = "swt-scrollbar-vertical-visible";
    public static final String SWT_SCROLLBAR_HORIZONTAL_VISIBLE = "swt-scrollbar-horizontal-visible";
    public static final String SWT_SCROLLBAR_BORDER_RADIUS = "swt-scrollbar-border-radius";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(element instanceof StyledTextElement)) {
            return false;
        }
        if (value.getCssValueType() != 1) {
            return false;
        }
        StyledTextElement styledTextElement = (StyledTextElement)element;
        StyledText styledText = styledTextElement.getStyledText();
        switch (property) {
            case "swt-scrollbar-background-color": {
                Color bgColor = (Color)engine.convert(value, Color.class, (Object)styledText.getDisplay());
                styledTextElement.setScrollBarBackgroundColor(bgColor);
                break;
            }
            case "swt-scrollbar-foreground-color": {
                Color fgColor = (Color)engine.convert(value, Color.class, (Object)styledText.getDisplay());
                styledTextElement.setScrollBarForegroundColor(fgColor);
                break;
            }
            case "swt-scrollbar-width": {
                if (!(value instanceof Measure)) break;
                Measure measure = (Measure)value;
                int width = (int)measure.getFloatValue((short)17);
                styledTextElement.setScrollBarWidth(width);
                break;
            }
            case "swt-scrollbar-mouse-near-scroll-width": {
                if (!(value instanceof Measure)) break;
                Measure measure = (Measure)value;
                int width = (int)measure.getFloatValue((short)17);
                styledTextElement.setMouseNearScrollScrollBarWidth(width);
                break;
            }
            case "swt-scrollbar-border-radius": {
                if (!(value instanceof Measure)) break;
                Measure measure = (Measure)value;
                int radius = (int)measure.getFloatValue((short)17);
                styledTextElement.setScrollBarBorderRadius(radius);
                break;
            }
            case "swt-scrollbar-vertical-visible": {
                Boolean verticalVisible = (Boolean)engine.convert(value, Boolean.class, (Object)styledText.getDisplay());
                styledTextElement.setVerticalScrollBarVisible(verticalVisible);
                break;
            }
            case "swt-scrollbar-horizontal-visible": {
                Boolean horizontalVisible = (Boolean)engine.convert(value, Boolean.class, (Object)styledText.getDisplay());
                styledTextElement.setHorizontalScrollBarVisible(horizontalVisible);
                break;
            }
            case "swt-scrollbar-themed": {
                String cssText = value.getCssText();
                styledTextElement.setScrollBarThemed(cssText);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

