/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;

public class CASTFieldDeclarator
extends CASTDeclarator
implements IASTFieldDeclarator {
    private IASTExpression bitFieldSize;

    public CASTFieldDeclarator() {
    }

    public CASTFieldDeclarator(IASTName name, IASTExpression bitFieldSize) {
        super(name);
        this.setBitFieldSize(bitFieldSize);
    }

    @Override
    public CASTFieldDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTFieldDeclarator copy(IASTNode.CopyStyle style) {
        CASTFieldDeclarator copy = new CASTFieldDeclarator();
        copy.setBitFieldSize(this.bitFieldSize == null ? null : this.bitFieldSize.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getBitFieldSize() {
        return this.bitFieldSize;
    }

    @Override
    public void setBitFieldSize(IASTExpression size) {
        this.assertNotFrozen();
        this.bitFieldSize = size;
        if (size != null) {
            size.setParent(this);
            size.setPropertyInParent(FIELD_SIZE);
        }
    }

    @Override
    protected boolean postAccept(ASTVisitor action) {
        if (this.bitFieldSize != null && !this.bitFieldSize.accept(action)) {
            return false;
        }
        return super.postAccept(action);
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.bitFieldSize) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.bitFieldSize = (IASTExpression)other;
        } else {
            super.replace(child, other);
        }
    }
}

