/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.Objects;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExtensionNode;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class PreferenceElement
extends QuickAccessElement {
    private static final String separator = " - ";
    private IPreferenceNode preferenceNode;
    private String prefix;
    private String matchLabelCache;

    PreferenceElement(IPreferenceNode preferenceNode, String prefix) {
        this.preferenceNode = preferenceNode;
        this.prefix = prefix;
    }

    @Override
    public void execute() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            WorkbenchPreferenceDialog dialog = WorkbenchPreferenceDialog.createDialogOn(window.getShell(), this.preferenceNode.getId());
            dialog.open();
        }
    }

    @Override
    public String getId() {
        return this.preferenceNode.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Image image = this.preferenceNode.getLabelImage();
        if (image != null) {
            return ImageDescriptor.createFromImage((Image)image);
        }
        return null;
    }

    @Override
    public String getLabel() {
        if (this.prefix != null && this.prefix.length() > 0) {
            return String.valueOf(this.preferenceNode.getLabelText()) + separator + this.prefix;
        }
        return this.preferenceNode.getLabelText();
    }

    @Override
    public String getMatchLabel() {
        if (this.matchLabelCache == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(super.getSortLabel());
            if (this.preferenceNode instanceof WorkbenchPreferenceExtensionNode) {
                ((WorkbenchPreferenceExtensionNode)this.preferenceNode).getKeywordLabels().forEach(label -> {
                    builder.append(separator);
                    builder.append((String)label);
                });
            }
            this.matchLabelCache = builder.toString();
        }
        return this.matchLabelCache;
    }

    public int hashCode() {
        return Objects.hashCode(this.preferenceNode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreferenceElement other = (PreferenceElement)obj;
        return Objects.equals(this.preferenceNode, other.preferenceNode);
    }
}

