/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.CMakeBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class CMakeBuildConfigurationProvider
implements ICBuildConfigurationProvider {
    public static final String ID = "org.eclipse.cdt.cmake.core.provider";
    private ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
    private ICBuildConfigurationManager configManager = Activator.getService(ICBuildConfigurationManager.class);

    public String getId() {
        return ID;
    }

    public ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        if (config.getName().equals("")) {
            IToolChain tc;
            IToolChain toolChain = null;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("os", Platform.getOS());
            properties.put("arch", Platform.getOSArch());
            IToolChainManager toolChainManager = Activator.getService(IToolChainManager.class);
            Iterator iterator = toolChainManager.getToolChainsMatching(properties).iterator();
            if (iterator.hasNext()) {
                toolChain = tc = (IToolChain)iterator.next();
            }
            if (toolChain == null && (iterator = toolChainManager.getToolChainsMatching(new HashMap()).iterator()).hasNext()) {
                toolChain = tc = (IToolChain)iterator.next();
            }
            if (toolChain != null) {
                return new CMakeBuildConfiguration(config, name, toolChain);
            }
            return null;
        }
        return new CMakeBuildConfiguration(config, name);
    }

    public ICBuildConfiguration createBuildConfiguration(IProject project, IToolChain toolChain, String launchMode, IProgressMonitor monitor) throws CoreException {
        String arch;
        IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMakeBuildConfiguration cmakeConfig;
            IBuildConfiguration config = iBuildConfigurationArray[n2];
            ICBuildConfiguration cconfig = (ICBuildConfiguration)config.getAdapter(ICBuildConfiguration.class);
            if (cconfig != null && (cmakeConfig = (CMakeBuildConfiguration)((Object)cconfig.getAdapter(CMakeBuildConfiguration.class))) != null && cmakeConfig.getToolChain().equals(toolChain) && launchMode.equals(cmakeConfig.getLaunchMode())) {
                return cconfig;
            }
            ++n2;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        String os = toolChain.getProperty("os");
        if (os != null && !os.isEmpty()) {
            properties.put("os", os);
        }
        if (!(arch = toolChain.getProperty("arch")).isEmpty()) {
            properties.put("arch", arch);
        }
        ICMakeToolChainFile file = null;
        Collection<ICMakeToolChainFile> files = this.manager.getToolChainFilesMatching(properties);
        if (!files.isEmpty()) {
            file = files.iterator().next();
        }
        String configName = "cmake." + launchMode + '.' + toolChain.getId();
        IBuildConfiguration config = this.configManager.createBuildConfiguration((ICBuildConfigurationProvider)this, project, configName, monitor);
        CMakeBuildConfiguration cmakeConfig = new CMakeBuildConfiguration(config, configName, toolChain, file, launchMode);
        this.configManager.addBuildConfiguration(config, (ICBuildConfiguration)cmakeConfig);
        return cmakeConfig;
    }
}

