/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.internal.core.dom.parser.ISerializableExecution;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecBreak;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecContinue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;
import org.eclipse.core.runtime.CoreException;

public class ExecWhile
implements ICPPExecution {
    private final ICPPEvaluation conditionExprEval;
    private final ExecSimpleDeclaration conditionDeclExec;
    private final ICPPExecution bodyExec;

    public ExecWhile(ICPPEvaluation conditionExprEval, ExecSimpleDeclaration conditionDeclExec, ICPPExecution bodyExec) {
        this.conditionExprEval = conditionExprEval;
        this.conditionDeclExec = conditionDeclExec;
        this.bodyExec = bodyExec;
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        while (this.conditionSatisfied(record, context)) {
            if (context.getStepsPerformed() >= 1024) {
                return ExecIncomplete.INSTANCE;
            }
            ICPPExecution result = EvalUtil.executeStatement(this.bodyExec, record, context);
            if (result instanceof ExecReturn) {
                return result;
            }
            if (result instanceof ExecBreak) break;
            if (!(result instanceof ExecContinue)) continue;
        }
        return null;
    }

    private boolean conditionSatisfied(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.conditionExprEval != null) {
            return EvalUtil.conditionExprSatisfied(this.conditionExprEval, record, context);
        }
        if (this.conditionDeclExec != null) {
            return EvalUtil.conditionDeclSatisfied(this.conditionDeclExec, record, context);
        }
        return false;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation newConditionExprEval = this.conditionExprEval != null ? this.conditionExprEval.instantiate(context, maxDepth) : null;
        ExecSimpleDeclaration newConditionDeclExec = this.conditionDeclExec != null ? (ExecSimpleDeclaration)this.conditionDeclExec.instantiate(context, maxDepth) : null;
        ICPPExecution newBodyExec = this.bodyExec.instantiate(context, maxDepth);
        if (newConditionExprEval == this.conditionExprEval && newConditionDeclExec == this.conditionDeclExec && newBodyExec == this.bodyExec) {
            return this;
        }
        return new ExecWhile(newConditionExprEval, newConditionDeclExec, newBodyExec);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)12);
        buffer.marshalEvaluation(this.conditionExprEval, includeValue);
        buffer.marshalExecution(this.conditionDeclExec, includeValue);
        buffer.marshalExecution(this.bodyExec, includeValue);
    }

    public static ISerializableExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPEvaluation conditionExprEval = (ICPPEvaluation)buffer.unmarshalEvaluation();
        ExecSimpleDeclaration conditionDeclExec = (ExecSimpleDeclaration)buffer.unmarshalExecution();
        ICPPExecution bodyExec = (ICPPExecution)buffer.unmarshalExecution();
        return new ExecWhile(conditionExprEval, conditionDeclExec, bodyExec);
    }
}

