/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core.jtagdevice;

import java.util.Collection;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;

public class DefaultGDBJtagDeviceImpl
implements IGDBJtagDevice {
    protected static final String LINESEP = System.getProperty("line.separator");

    @Override
    public void doDelay(int delay, Collection<String> commands) {
        String cmd = "monitor delay " + String.valueOf(delay * 1000);
        this.addCmd(commands, cmd);
    }

    @Override
    public void doReset(Collection<String> commands) {
        String cmd = "monitor reset run";
        this.addCmd(commands, cmd);
    }

    @Override
    public int getDefaultDelay() {
        return 0;
    }

    @Override
    public void doRemote(String ip, int port, Collection<String> commands) {
        String cmd = "-target-select remote " + ip + ":" + String.valueOf(port);
        this.addCmd(commands, cmd);
    }

    @Override
    public void doHalt(Collection<String> commands) {
        String cmd = "monitor halt";
        this.addCmd(commands, cmd);
    }

    @Override
    public void doContinue(Collection<String> commands) {
        String cmd = "-exec-continue";
        this.addCmd(commands, cmd);
    }

    @Override
    public void doLoadImage(String imageFileName, String imageOffset, Collection<String> commands) {
        this.addCmd(commands, "load " + this.escapeScpaces(imageFileName) + ' ' + imageOffset);
    }

    @Override
    public void doLoadSymbol(String symbolFileName, String symbolOffset, Collection<String> commands) {
        String file = this.escapeScpaces(symbolFileName);
        if (symbolOffset == null || symbolOffset.length() == 0) {
            this.addCmd(commands, "symbol-file " + file);
        } else {
            this.addCmd(commands, "add-symbol-file " + file + " " + symbolOffset);
        }
    }

    protected String escapeScpaces(String file) {
        if (file.indexOf(32) >= 0) {
            return String.valueOf('\"') + file + '\"';
        }
        return file;
    }

    @Override
    public void doSetPC(String pc, Collection<String> commands) {
        String cmd = "set $pc=0x" + pc;
        this.addCmd(commands, cmd);
    }

    @Override
    public void doStopAt(String stopAt, Collection<String> commands) {
        String cmd = "tbreak " + stopAt;
        this.addCmd(commands, cmd);
    }

    protected void addCmd(Collection<String> commands, String cmd) {
        commands.add(String.valueOf(cmd) + LINESEP);
    }

    @Override
    public String getDefaultIpAddress() {
        return "localhost";
    }

    @Override
    public String getDefaultPortNumber() {
        return "10000";
    }
}

