/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.launch;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.debug.core.launch.CoreBuildLaunchConfigDelegate;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.internal.qt.ui.Messages;
import org.eclipse.cdt.launch.ui.corebuild.CommonBuildTab;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.cdt.qt.core.IQtInstallManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class QtBuildTab
extends CommonBuildTab {
    Combo qmakeCombo;
    Text qmakeArgsText;
    Text buildCmdText;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)comp);
        Label label = new Label(comp, 0);
        label.setText(Messages.QtBuildTab_qmakeCommand);
        this.qmakeCombo = new Combo(comp, 12);
        this.qmakeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(comp, 0);
        label.setText(Messages.QtBuildTab_qmakeArgs);
        this.qmakeArgsText = new Text(comp, 2048);
        this.qmakeArgsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(comp, 0);
        label.setText(Messages.QtBuildTab_buildCommand);
        this.buildCmdText = new Text(comp, 2048);
        this.buildCmdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String mode = this.getLaunchConfigurationDialog().getMode();
            configuration.setAttribute(CoreBuildLaunchConfigDelegate.getBuildAttributeName((String)mode), this.getBuildConfiguration((ILaunchConfiguration)configuration).getDefaultProperties());
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private Map<String, String> getProperties(ILaunchConfiguration configuration) throws CoreException {
        String mode = this.getLaunchConfigurationDialog().getMode();
        Map properties = configuration.getAttribute(CoreBuildLaunchConfigDelegate.getBuildAttributeName((String)mode), new HashMap());
        if (properties.isEmpty()) {
            properties = this.getBuildConfiguration(configuration).getProperties();
        }
        return properties;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String buildCommand;
            String qmakeArgs;
            Map<String, String> properties = this.getProperties(configuration);
            IToolChainManager tcManager = Activator.getService(IToolChainManager.class);
            IQtInstallManager qtManager = Activator.getService(IQtInstallManager.class);
            ILaunchTarget target = this.getLaunchTarget();
            String qmakeCmd = properties.get("cdt.qt.qmake.command");
            this.qmakeCombo.removeAll();
            Collection toolChains = tcManager.getToolChainsMatching(target.getAttributes());
            int select = -1;
            block2: for (IQtInstall qtInstall : qtManager.getInstalls()) {
                for (IToolChain toolChain : toolChains) {
                    if (!qtManager.supports(qtInstall, toolChain)) continue;
                    this.qmakeCombo.add(qtInstall.getQmakePath().toString());
                    if (qmakeCmd == null || !qmakeCmd.equals(qtInstall.getQmakePath().toString())) continue block2;
                    select = this.qmakeCombo.getItemCount() - 1;
                    continue block2;
                }
            }
            if (select != -1) {
                this.qmakeCombo.select(select);
            }
            if ((qmakeArgs = properties.get("cdt.qt.qmake.args")) != null) {
                this.qmakeArgsText.setText(qmakeArgs);
            }
            if ((buildCommand = properties.get("cdt.qt.buildCommand")) != null) {
                this.buildCmdText.setText(buildCommand);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>(this.getProperties((ILaunchConfiguration)configuration));
            properties.put("cdt.qt.qmake.command", this.qmakeCombo.getItem(this.qmakeCombo.getSelectionIndex()));
            properties.put("cdt.qt.qmake.args", this.qmakeArgsText.getText().trim());
            properties.put("cdt.qt.buildCommand", this.buildCmdText.getText().trim());
            String mode = this.getLaunchBarLaunchConfigDialog().getMode();
            configuration.setAttribute(CoreBuildLaunchConfigDelegate.getBuildAttributeName((String)mode), properties);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public String getName() {
        return Messages.QtBuildTab_Name;
    }
}

