/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsole;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsoleView;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbAbstractConsolePreferenceListener;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbFullCliConsole;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbTerminalPageConnector;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.IGdbTerminalControlConnector;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbAutoTerminateAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbConsoleClearAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbConsoleCopyAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbConsolePasteAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbConsoleScrollLockAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbConsoleSelectAllAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbConsoleShowPreferencesAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbConsoleTerminateLaunchAction;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.part.Page;

public class GdbFullCliConsolePage
extends Page
implements IDebugContextListener {
    private final ILaunch fLaunch;
    private final PTY fGdbPty;
    private Composite fMainComposite;
    private final IDebuggerConsoleView fView;
    private final IDebuggerConsole fConsole;
    private final IGdbTerminalControlConnector fGdbTerminalControlConnector;
    private MenuManager fMenuManager;
    private GdbConsoleTerminateLaunchAction fTerminateLaunchAction;
    private ITerminalViewControl fTerminalControl;
    private GdbConsoleClearAction fClearAction;
    private GdbConsoleCopyAction fCopyAction;
    private GdbConsolePasteAction fPasteAction;
    private GdbConsoleScrollLockAction fScrollLockAction;
    private GdbConsoleSelectAllAction fSelectAllAction;
    private GdbAutoTerminateAction fAutoTerminateAction;
    private GdbConsoleShowPreferencesAction fShowPreferencePageAction;
    private GdbAbstractConsolePreferenceListener fPreferenceListener = new GdbAbstractConsolePreferenceListener(){

        @Override
        protected void handleAutoTerminatePref(boolean enabled) {
            if (GdbFullCliConsolePage.this.fAutoTerminateAction != null) {
                GdbFullCliConsolePage.this.fAutoTerminateAction.setChecked(enabled);
            }
        }

        @Override
        protected void handleInvertColorsPref(boolean enabled) {
            GdbFullCliConsolePage.this.setInvertedColors(enabled);
        }

        @Override
        protected void handleBufferLinesPref(int bufferLines) {
            GdbFullCliConsolePage.this.setBufferLineLimit(bufferLines);
        }
    };

    public GdbFullCliConsolePage(GdbFullCliConsole gdbConsole, IDebuggerConsoleView view, PTY pty) {
        this.fConsole = gdbConsole;
        this.fGdbTerminalControlConnector = gdbConsole.getTerminalControlConnector();
        this.fView = view;
        this.fLaunch = gdbConsole.getLaunch();
        this.fGdbPty = pty;
        GdbUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public void dispose() {
        super.dispose();
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        this.fTerminalControl.disposeTerminal();
        this.fMenuManager.dispose();
        GdbUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public void createControl(Composite parent) {
        this.fMainComposite = new Composite(parent, 0);
        this.fMainComposite.setLayoutData((Object)new GridData(1808));
        this.fMainComposite.setLayout((Layout)new FillLayout());
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        this.createTerminalControl();
        this.createContextMenu();
        this.configureToolBar(this.getSite().getActionBars().getToolBarManager());
    }

    private void setDefaults() {
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        this.setInvertedColors(store.getBoolean("org.eclipse.cdt.dsf.gdb.consoleInvertedColors"));
        this.setBufferLineLimit(store.getInt("org.eclipse.cdt.dsf.gdb.consoleBufferLines"));
    }

    private void createTerminalControl() {
        boolean useCommonPrefs = false;
        this.fTerminalControl = TerminalViewControlFactory.makeControl((ITerminalListener)new ITerminalListener(){

            public void setState(TerminalState state) {
            }

            public void setTerminalTitle(String title) {
            }
        }, (Composite)this.fMainComposite, (ITerminalConnector[])new ITerminalConnector[0], (boolean)useCommonPrefs);
        this.fTerminalControl.setConnector((ITerminalConnector)new GdbTerminalPageConnector(this.fGdbTerminalControlConnector, this.fGdbPty));
        try {
            this.fTerminalControl.setEncoding(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.fTerminalControl instanceof ITerminalControl) {
            ((ITerminalControl)this.fTerminalControl).setConnectOnEnterIfClosed(false);
            ((ITerminalControl)this.fTerminalControl).setVT100LineWrapping(true);
        }
        this.fMainComposite.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (GdbFullCliConsolePage.this.fTerminalControl != null && !GdbFullCliConsolePage.this.fTerminalControl.isDisposed()) {
                    GdbFullCliConsolePage.this.fTerminalControl.clearTerminal();
                    GdbFullCliConsolePage.this.fTerminalControl.connectTerminal();
                    GdbFullCliConsolePage.this.setDefaults();
                }
            }
        });
    }

    protected void createContextMenu() {
        String id = "GdbFullCliConsole.#ContextMenu";
        this.fMenuManager = new MenuManager(id, id);
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener(menuManager -> this.contextMenuAboutToShow(menuManager));
        Menu menu = this.fMenuManager.createContextMenu(this.fTerminalControl.getControl());
        this.fTerminalControl.getControl().setMenu(menu);
        this.createActions();
        this.getSite().registerContextMenu(id, this.fMenuManager, this.getSite().getSelectionProvider());
    }

    protected void createActions() {
        this.fTerminateLaunchAction = new GdbConsoleTerminateLaunchAction(this.fLaunch);
        this.fClearAction = new GdbConsoleClearAction(this.fTerminalControl);
        this.fCopyAction = new GdbConsoleCopyAction(this.fTerminalControl);
        this.fPasteAction = new GdbConsolePasteAction(this.fTerminalControl);
        this.fScrollLockAction = new GdbConsoleScrollLockAction(this.fTerminalControl);
        this.fSelectAllAction = new GdbConsoleSelectAllAction(this.fTerminalControl);
        this.fAutoTerminateAction = new GdbAutoTerminateAction();
        this.fShowPreferencePageAction = new GdbConsoleShowPreferencesAction(this.getSite().getShell());
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.insertBefore("org.eclipse.cdt.debug.ui.debuggerConsoleView.DebuggerConsoleDropDownAction", (IAction)this.fTerminateLaunchAction);
        mgr.insertBefore("org.eclipse.cdt.debug.ui.debuggerConsoleView.DebuggerConsoleDropDownAction", (IAction)this.fClearAction);
        mgr.insertBefore("org.eclipse.cdt.debug.ui.debuggerConsoleView.DebuggerConsoleDropDownAction", (IAction)this.fScrollLockAction);
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.fCopyAction);
        menuManager.add((IAction)this.fPasteAction);
        menuManager.add((IAction)this.fSelectAllAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.fClearAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.fScrollLockAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.fTerminateLaunchAction);
        menuManager.add((IAction)this.fAutoTerminateAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IAction)this.fShowPreferencePageAction);
    }

    public Control getControl() {
        return this.fMainComposite;
    }

    public void setFocus() {
        this.fTerminalControl.setFocus();
    }

    protected ILaunch getCurrentLaunch() {
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null) {
            return (ILaunch)context.getAdapter(ILaunch.class);
        }
        return null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0 && this.fLaunch.equals(this.getCurrentLaunch())) {
            this.fView.display(this.fConsole);
        }
    }

    private void setInvertedColors(boolean enable) {
        if (this.fTerminalControl != null) {
            this.fTerminalControl.setInvertedColors(enable);
        }
    }

    private void setBufferLineLimit(int bufferLines) {
        if (this.fTerminalControl != null) {
            this.fTerminalControl.setBufferLineLimit(bufferLines);
        }
    }
}

