/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariableTemplate;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.VariableHelpers;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPVariableTemplate
extends CPPTemplateDefinition
implements ICPPVariableTemplate,
ICPPInternalVariable {
    private IType fType;
    private boolean fAllResolved;
    private ICPPPartialSpecialization[] partialSpecializations = ICPPPartialSpecialization.EMPTY_ARRAY;

    public CPPVariableTemplate(IASTName name) {
        super(name);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return VariableHelpers.isConstexpr((IASTName)this.getDefinition());
    }

    @Override
    public boolean isExternC() {
        return CPPVisitor.isExternC(this.getDefinition(), this.getDeclarations());
    }

    @Override
    public IType getType() {
        if (this.fType != null) {
            return this.fType;
        }
        boolean allResolved = this.fAllResolved;
        this.fAllResolved = true;
        this.fType = VariableHelpers.createType(this, this.definition, this.declarations, allResolved);
        return this.fType;
    }

    @Override
    public IValue getInitialValue() {
        return VariableHelpers.getInitialValue((IASTName)this.getDefinition(), (IASTName[])this.getDeclarations(), this.getType());
    }

    @Override
    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    @Override
    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    @Override
    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    @Override
    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        return VariableHelpers.hasStorageClass(name, ns, storage);
    }

    @Override
    public ICPPPartialSpecialization[] getPartialSpecializations() {
        this.partialSpecializations = ArrayUtil.trim(this.partialSpecializations);
        return this.partialSpecializations;
    }

    public void addPartialSpecialization(ICPPPartialSpecialization partSpec) {
        this.partialSpecializations = ArrayUtil.append(this.partialSpecializations, partSpec);
    }
}

