/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableExecution;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompositeAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUnary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecBreak;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecContinue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public class ExecRangeBasedFor
implements ICPPExecution {
    private final ExecSimpleDeclaration declarationExec;
    private final ICPPEvaluation initClauseEval;
    private final ICPPFunction begin;
    private final ICPPFunction end;
    private final ICPPExecution bodyExec;

    public ExecRangeBasedFor(ExecSimpleDeclaration declarationExec, ICPPEvaluation initClauseEval, ICPPFunction begin, ICPPFunction end, ICPPExecution bodyExec) {
        this.declarationExec = declarationExec;
        this.initClauseEval = initClauseEval;
        this.begin = begin;
        this.end = end;
        this.bodyExec = bodyExec;
    }

    private ICPPExecution loopOverArray(IVariable rangeVar, ICPPEvaluation valueRange, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation[] range = valueRange.getValue(context.getPoint()).getAllSubValues();
        int i = 0;
        while (i < range.length) {
            CPPEvaluation value = new EvalFixed(range[i].getType(context.getPoint()), range[i].getValueCategory(context.getPoint()), range[i].getValue(context.getPoint()));
            if (rangeVar.getType() instanceof ICPPReferenceType) {
                value = new EvalReference(record, new EvalCompositeAccess(valueRange, i), value.getTemplateDefinition());
            }
            record.update(rangeVar, value);
            ICPPExecution result = EvalUtil.executeStatement(this.bodyExec, record, context);
            if (result instanceof ExecReturn) {
                return result;
            }
            if (result instanceof ExecBreak) break;
            if (result instanceof ExecContinue) {
                // empty if block
            }
            ++i;
        }
        return null;
    }

    private ICPPExecution loopOverObject(IVariable rangeVar, ICPPEvaluation rangeEval, boolean rangeIsConst, ICPPClassType classType, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.begin != null && this.end != null) {
            ICPPEvaluation beginEval = ExecRangeBasedFor.callFunction(classType, this.begin, rangeEval, record, context);
            ICPPEvaluation endEval = ExecRangeBasedFor.callFunction(classType, this.end, rangeEval, record, context);
            boolean isRef = rangeVar.getType() instanceof ICPPReferenceType;
            while (!ExecRangeBasedFor.isEqual(beginEval, endEval, context.getPoint())) {
                record.update(rangeVar, ExecRangeBasedFor.deref(beginEval, isRef, record, context));
                ICPPExecution result = EvalUtil.executeStatement(this.bodyExec, record, context);
                if (result instanceof ExecReturn) {
                    return result;
                }
                if (result instanceof ExecBreak) break;
                if (result instanceof ExecContinue) {
                    // empty if block
                }
                beginEval = ExecRangeBasedFor.inc(record, beginEval, context);
            }
            return null;
        }
        return ExecIncomplete.INSTANCE;
    }

    private static boolean isEqual(ICPPEvaluation a, ICPPEvaluation b, IASTNode point) {
        Number result = new EvalBinary(28, a, b, point).getValue(point).numberValue();
        return result != null && result.longValue() != 0L;
    }

    private static ICPPEvaluation deref(ICPPEvaluation ptr, boolean isRef, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation derefEval = new EvalUnary(4, ptr, null, context.getPoint()).computeForFunctionCall(record, context);
        if (isRef) {
            return derefEval;
        }
        return new EvalFixed(derefEval.getType(context.getPoint()), derefEval.getValueCategory(context.getPoint()), derefEval.getValue(context.getPoint()));
    }

    private static ICPPEvaluation inc(ActivationRecord record, ICPPEvaluation ptr, ICPPEvaluation.ConstexprEvaluationContext context) {
        return new EvalUnary(0, ptr, null, context.getPoint()).computeForFunctionCall(record, context);
    }

    private static ICPPEvaluation callFunction(ICPPClassType classType, ICPPFunction func, ICPPEvaluation rangeEval, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        EvalFunctionCall call = null;
        if (func instanceof ICPPMethod) {
            EvalMemberAccess memberAccess = new EvalMemberAccess((IType)classType, IASTExpression.ValueCategory.LVALUE, (IBinding)func, rangeEval, false, context.getPoint());
            ICPPEvaluation[] args = new ICPPEvaluation[]{memberAccess};
            call = new EvalFunctionCall(args, rangeEval, context.getPoint());
        } else {
            EvalBinding op = new EvalBinding((IBinding)func, (IType)func.getType(), context.getPoint());
            ICPPEvaluation[] args = new ICPPEvaluation[]{op, rangeEval};
            call = new EvalFunctionCall(args, null, context.getPoint());
        }
        return call.computeForFunctionCall(record, context);
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (context.getStepsPerformed() >= 1024) {
            return ExecIncomplete.INSTANCE;
        }
        ICPPEvaluation valueRange = this.initClauseEval.computeForFunctionCall(record, context.recordStep());
        ExecDeclarator declaratorExec = (ExecDeclarator)this.declarationExec.getDeclaratorExecutions()[0];
        IVariable rangeVar = (IVariable)((Object)declaratorExec.getDeclaredBinding());
        boolean rangeIsConst = SemanticUtil.isConst(this.initClauseEval.getType(context.getPoint()));
        IType type = SemanticUtil.getNestedType(valueRange.getType(context.getPoint()), 21);
        if (type instanceof IArrayType || type instanceof InitializerListType) {
            return this.loopOverArray(rangeVar, valueRange, record, context);
        }
        if (type instanceof ICPPClassType) {
            ICPPClassType classType = (ICPPClassType)type;
            return this.loopOverObject(rangeVar, this.initClauseEval, rangeIsConst, classType, record, context);
        }
        return ExecIncomplete.INSTANCE;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ExecSimpleDeclaration newDeclarationExec = (ExecSimpleDeclaration)this.declarationExec.instantiate(context, maxDepth);
        ICPPEvaluation newInitClauseEval = this.initClauseEval.instantiate(context, maxDepth);
        ICPPFunction newBegin = this.begin != null ? (ICPPFunction)CPPTemplates.createSpecialization(context.getContextSpecialization(), this.begin, context.getPoint()) : null;
        ICPPFunction newEnd = this.end != null ? (ICPPFunction)CPPTemplates.createSpecialization(context.getContextSpecialization(), this.end, context.getPoint()) : null;
        ICPPExecution newBodyExec = this.bodyExec.instantiate(context, maxDepth);
        if (newDeclarationExec == this.declarationExec && newInitClauseEval == this.initClauseEval && newBegin == this.begin && newEnd == this.end && newBodyExec == this.bodyExec) {
            return this;
        }
        return new ExecRangeBasedFor(newDeclarationExec, newInitClauseEval, newBegin, newEnd, newBodyExec);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)15);
        buffer.marshalExecution(this.declarationExec, includeValue);
        buffer.marshalEvaluation(this.initClauseEval, includeValue);
        buffer.marshalBinding(this.begin);
        buffer.marshalBinding(this.end);
        buffer.marshalExecution(this.bodyExec, includeValue);
    }

    public static ISerializableExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ExecSimpleDeclaration declarationExec = (ExecSimpleDeclaration)buffer.unmarshalExecution();
        ICPPEvaluation initClauseEval = (ICPPEvaluation)buffer.unmarshalEvaluation();
        ICPPFunction begin = (ICPPFunction)buffer.unmarshalBinding();
        ICPPFunction end = (ICPPFunction)buffer.unmarshalBinding();
        ICPPExecution bodyExec = (ICPPExecution)buffer.unmarshalExecution();
        return new ExecRangeBasedFor(declarationExec, initClauseEval, begin, end, bodyExec);
    }
}

