/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.InferiorRuntimeProcess;
import org.eclipse.cdt.dsf.gdb.service.DebugNewProcessSequence;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.StartOrRestartProcessSequence_7_0;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.MIInferiorProcess;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadGroupCreatedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadGroupExitedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIListThreadGroupsInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThread;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThreadInfoInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.pty.PersistentPTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.osgi.framework.BundleContext;

public class GDBProcesses_7_0
extends AbstractDsfService
implements IGDBProcesses,
ICachingService,
IEventListener {
    private static final int MAX_NUMBER_EXITED_PROCESS = 5;
    private Map<String, String> fThreadToGroupMap = new HashMap<String, String>();
    private Map<String, String> fGroupToPidMap = new HashMap<String, String>();
    private IGDBControl fCommandControl;
    private IGDBBackend fBackend;
    private CommandFactory fCommandFactory;
    private CommandCache fContainerCommandCache;
    private CommandCache fThreadCommandCache;
    private CommandCache fListThreadGroupsAvailableCache;
    private Map<String, String> fDebuggedProcessesAndNames = new HashMap<String, String>();
    private Map<String, PTY> fGroupIdToPTYMap = new HashMap<String, PTY>();
    private List<String> fExitedGroupId = new ArrayList<String>();
    private Map<String, ExitedProcInfo> fProcExitedMap = new LRUExitedProcessMap();
    private Set<String> fProcDetachedSet = new HashSet<String>();
    private static final String FAKE_THREAD_ID = "0";
    private int fNumConnected;
    private boolean fInitialProcess = true;

    public GDBProcesses_7_0(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBProcesses_7_0.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)this.fCommandControl, this.getExecutor(), 2);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fContainerCommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.fThreadCommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fThreadCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.fListThreadGroupsAvailableCache = new CommandCache(this.getSession(), (ICommandControl)this.fCommandControl);
        this.fListThreadGroupsAvailableCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.getSession().addServiceEventListener((Object)this, null);
        this.fCommandControl.addEventListener(this);
        this.register(new String[]{IProcesses.class.getName(), IMIProcesses.class.getName(), IGDBProcesses.class.getName(), GDBProcesses_7_0.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fCommandControl.removeEventListener(this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    protected Map<String, String> getThreadToGroupMap() {
        return this.fThreadToGroupMap;
    }

    protected Map<String, String> getGroupToPidMap() {
        return this.fGroupToPidMap;
    }

    protected int getNumConnected() {
        return this.fNumConnected;
    }

    protected void setNumConnected(int num) {
        this.fNumConnected = num;
    }

    protected boolean isInitialProcess() {
        return this.fInitialProcess;
    }

    protected void setIsInitialProcess(boolean isInitial) {
        this.fInitialProcess = isInitial;
    }

    protected Map<String, ExitedProcInfo> getExitedProcesses() {
        return this.fProcExitedMap;
    }

    protected Set<String> getDetachedProcesses() {
        return this.fProcDetachedSet;
    }

    protected String getGroupFromPid(String pid) {
        if (pid == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.getGroupToPidMap().entrySet()) {
            if (!pid.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public IProcesses.IThreadDMContext createThreadContext(IProcesses.IProcessDMContext processDmc, String threadId) {
        return new MIThreadDMC(this.getSession().getId(), processDmc, threadId);
    }

    @Override
    public IProcesses.IProcessDMContext createProcessContext(ICommandControlService.ICommandControlDMContext controlDmc, String pid) {
        return new MIProcessDMC(this.getSession().getId(), controlDmc, pid);
    }

    private IProcesses.IProcessDMContext createExitedProcessContext(ICommandControlService.ICommandControlDMContext controlDmc, String pid, String groupId) {
        return new MIExitedProcessDMC(this.getSession().getId(), controlDmc, pid, groupId);
    }

    @Override
    public IMIExecutionDMContext createExecutionContext(IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
        return new MIExecutionDMC(this.getSession().getId(), containerDmc, threadDmc, threadId);
    }

    @Override
    public IMIContainerDMContext createContainerContext(IProcesses.IProcessDMContext processDmc, String groupId) {
        return new GDBContainerDMC(this.getSession().getId(), processDmc, groupId);
    }

    @Override
    public IMIContainerDMContext createContainerContextFromThreadId(ICommandControlService.ICommandControlDMContext controlDmc, String threadId) {
        String groupId = this.getThreadToGroupMap().get(threadId);
        if (groupId == null) {
            if (this.getThreadToGroupMap().isEmpty()) {
                groupId = "";
            } else {
                Collection<String> values = this.getThreadToGroupMap().values();
                Iterator<String> iterator = values.iterator();
                if (iterator.hasNext()) {
                    String value;
                    groupId = value = iterator.next();
                }
            }
        }
        return this.createContainerContextFromGroupId(controlDmc, groupId);
    }

    @Override
    public IMIContainerDMContext createContainerContextFromGroupId(ICommandControlService.ICommandControlDMContext controlDmc, String groupId) {
        String pid;
        if (groupId == null || groupId.length() == 0) {
            Iterator<String> iterator;
            assert (this.getGroupToPidMap().size() <= 1) : "More than one process in our map";
            if (this.getGroupToPidMap().size() == 1 && (iterator = this.getGroupToPidMap().keySet().iterator()).hasNext()) {
                String key;
                groupId = key = iterator.next();
            }
        }
        if ((pid = this.getGroupToPidMap().get(groupId)) == null) {
            pid = groupId;
        }
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(controlDmc, pid);
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    public IMIExecutionDMContext[] getExecutionContexts(IMIContainerDMContext containerDmc) {
        if (this.isExitedProcess((IDMContext)containerDmc)) {
            return new IMIExecutionDMContext[0];
        }
        String groupId = containerDmc.getGroupId();
        ArrayList<IMIExecutionDMContext> execDmcList = new ArrayList<IMIExecutionDMContext>();
        for (Map.Entry<String, String> entry : this.getThreadToGroupMap().entrySet()) {
            if (!entry.getValue().equals(groupId)) continue;
            String threadId = entry.getKey();
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
            IMIExecutionDMContext execDmc = this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, threadId), threadId);
            execDmcList.add(execDmc);
        }
        return execDmcList.toArray(new IMIExecutionDMContext[0]);
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, final DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof MIExitedProcessDMC) {
            ExitedProcInfo info = this.getExitedProcesses().get(((MIExitedProcessDMC)dmc).getGroupId());
            if (info != null) {
                rm.done((Object)new MIExitedProcessDMData(info.getName(), info.getPid(), info.getExitCode()));
            } else {
                rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Unavailable info about exited process", null));
            }
            return;
        }
        if (dmc instanceof IMIProcessDMContext) {
            String id = ((IMIProcessDMContext)dmc).getProcId();
            String name = null;
            if (this.fBackend.getSessionType() == SessionType.CORE || "42000".equals(id)) {
                name = this.fBackend.getProgramPath().lastSegment();
                id = null;
            } else if (this.fDebuggedProcessesAndNames.containsKey(id)) {
                name = this.fDebuggedProcessesAndNames.get(id);
                assert (name != null);
                if (name == null) {
                    name = this.fBackend.getProgramPath().toOSString();
                    this.fDebuggedProcessesAndNames.put(id, name);
                } else if (name.isEmpty()) {
                    final String finalPId = id;
                    this.fListThreadGroupsAvailableCache.execute(this.fCommandFactory.createMIListThreadGroups(this.fCommandControl.getContext(), true), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), null){

                        /*
                         * Unable to fully structure code
                         */
                        protected void handleCompleted() {
                            GDBProcesses_7_0.access$1(GDBProcesses_7_0.this).reset();
                            name = null;
                            if (this.isSuccess()) {
                                var5_2 = ((MIListThreadGroupsInfo)this.getData()).getGroupList();
                                var4_4 = var5_2.length;
                                var3_6 = 0;
                                while (var3_6 < var4_4) {
                                    groupInfo = var5_2[var3_6];
                                    if (groupInfo.getPid().equals(finalPId)) {
                                        name = groupInfo.getName();
                                        GDBProcesses_7_0.access$2(GDBProcesses_7_0.this).put(finalPId, name);
                                        break;
                                    }
                                    ++var3_6;
                                }
                            } else if (GDBProcesses_7_0.access$3(GDBProcesses_7_0.this).getSessionType() == SessionType.LOCAL) {
                                try {
                                    list = CCorePlugin.getDefault().getProcessList();
                                    if (list == null) ** GOTO lbl37
                                    pId_int = Integer.parseInt(finalPId);
                                    var7_11 = list.getProcessList();
                                    var6_12 = var7_11.length;
                                    var5_3 = 0;
                                    while (var5_3 < var6_12) {
                                        procInfo = var7_11[var5_3];
                                        if (procInfo.getPid() == pId_int) {
                                            name = procInfo.getName();
                                            GDBProcesses_7_0.access$2(GDBProcesses_7_0.this).put(finalPId, name);
                                        }
                                        ++var5_3;
                                    }
                                }
                                catch (Exception e) {
                                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Could not get process name", (Throwable)e));
                                }
                            }
                            if (name == null) {
                                name = GDBProcesses_7_0.access$3(GDBProcesses_7_0.this).getProgramPath().toOSString();
                                GDBProcesses_7_0.access$2(GDBProcesses_7_0.this).put(finalPId, name);
                            }
                            rm.done((Object)new MIThreadDMData(name, finalPId));
                        }
                    });
                    return;
                }
            } else {
                name = "Unknown name";
            }
            rm.setData((Object)new MIThreadDMData(name, id));
            rm.done();
        } else if (dmc instanceof MIThreadDMC) {
            final MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
            this.fThreadCommandCache.execute(this.fCommandFactory.createMIThreadInfo(controlDmc, threadDmc.getId()), (DataRequestMonitor)new DataRequestMonitor<MIThreadInfoInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIThread thread;
                    MIThreadDMData threadData = null;
                    if (((MIThreadInfoInfo)this.getData()).getThreadList().length != 0 && (thread = ((MIThreadInfoInfo)this.getData()).getThreadList()[0]).getThreadId().equals(threadDmc.getId())) {
                        String details;
                        String id = "";
                        if (thread.getOsId() != null) {
                            id = thread.getOsId();
                        }
                        if ((details = thread.getDetails()) != null && !details.isEmpty()) {
                            if (!id.isEmpty()) {
                                id = String.valueOf(id) + " ";
                            }
                            id = String.valueOf(id) + "(" + details + ")";
                        }
                        if (id.isEmpty()) {
                            id = null;
                        }
                        threadData = new MIThreadDMData("", id);
                    }
                    if (threadData != null) {
                        rm.setData(threadData);
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Could not get thread info", null));
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid DMC type", null));
            rm.done();
        }
    }

    public void getDebuggingContext(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IDMContext> rm) {
        if (dmc instanceof MIExitedProcessDMC) {
            MIExitedProcessDMC exitedProc = (MIExitedProcessDMC)dmc;
            IMIContainerDMContext containerDmc = this.createContainerContext(exitedProc, exitedProc.getGroupId());
            rm.setData((Object)containerDmc);
        } else if (dmc instanceof MIProcessDMC) {
            MIProcessDMC procDmc = (MIProcessDMC)dmc;
            IMIContainerDMContext containerDmc = this.createContainerContext(procDmc, this.getGroupFromPid(procDmc.getProcId()));
            rm.setData((Object)containerDmc);
        } else if (dmc instanceof MIThreadDMC) {
            MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
            IMIContainerDMContext containerDmc = this.createContainerContext(procDmc, this.getGroupFromPid(procDmc.getProcId()));
            rm.setData((Object)this.createExecutionContext(containerDmc, threadDmc, threadDmc.getId()));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid thread context.", null));
        }
        rm.done();
    }

    protected boolean doIsDebuggerAttachSupported() {
        return this.fBackend.getIsAttachSession() && this.fNumConnected == 0;
    }

    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doIsDebuggerAttachSupported());
        rm.done();
    }

    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, DataRequestMonitor<IDMContext> rm) {
        this.attachDebuggerToProcess(procCtx, null, rm);
    }

    @Override
    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, String binaryPath, DataRequestMonitor<IDMContext> dataRm) {
        if (procCtx instanceof IMIProcessDMContext) {
            if (!this.doIsDebuggerAttachSupported()) {
                dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Attach not supported.", null));
                dataRm.done();
                return;
            }
            ImmediateExecutor.getInstance().execute((Runnable)new Sequence(this.getExecutor(), (RequestMonitor)dataRm, procCtx, binaryPath, (DataRequestMonitor)dataRm){
                private IMIContainerDMContext fContainerDmc;
                private Sequence.Step[] steps;
                {
                    this.steps = new Sequence.Step[]{new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            if (GDBProcesses_7_0.this.isInitialProcess()) {
                                GDBProcesses_7_0.this.setIsInitialProcess(false);
                            }
                            fContainerDmc = GDBProcesses_7_0.this.createContainerContext(iProcessDMContext, "");
                            if (string != null) {
                                GDBProcesses_7_0.this.fCommandControl.queueCommand(GDBProcesses_7_0.this.fCommandFactory.createMIFileExecAndSymbols(fContainerDmc, string), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
                                return;
                            }
                            rm.done();
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            boolean shouldInterrupt = true;
                            IMIRunControl runControl = (IMIRunControl)GDBProcesses_7_0.this.getServicesTracker().getService(IMIRunControl.class);
                            if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.NON_STOP) {
                                shouldInterrupt = false;
                            }
                            GDBProcesses_7_0.this.fCommandControl.queueCommand(GDBProcesses_7_0.this.fCommandFactory.createMITargetAttach(fContainerDmc, ((IMIProcessDMContext)iProcessDMContext).getProcId(), shouldInterrupt), new DataRequestMonitor((Executor)this.getExecutor(), rm));
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            fContainerDmc = GDBProcesses_7_0.this.createContainerContext(iProcessDMContext, GDBProcesses_7_0.this.getGroupFromPid(((IMIProcessDMContext)iProcessDMContext).getProcId()));
                            dataRequestMonitor.setData((Object)fContainerDmc);
                            IGDBMemory memory = (IGDBMemory)GDBProcesses_7_0.this.getServicesTracker().getService(IGDBMemory.class);
                            IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)fContainerDmc, IMemory.IMemoryDMContext.class);
                            if (memory == null || memContext == null) {
                                rm.done();
                                return;
                            }
                            memory.initializeMemoryData(memContext, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)GDBProcesses_7_0.this.getServicesTracker().getService(MIBreakpointsManager.class));
                            bpmService.startTrackingBpForProcess(fContainerDmc, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            GDBProcesses_7_0.this.doReverseDebugStep(iProcessDMContext, rm);
                        }
                    }};
                }

                public Sequence.Step[] getSteps() {
                    return this.steps;
                }
            });
        } else {
            dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            dataRm.done();
        }
    }

    protected void doReverseDebugStep(IProcesses.IProcessDMContext procCtx, RequestMonitor rm) {
        ILaunch launch;
        IReverseRunControl reverseService = (IReverseRunControl)this.getServicesTracker().getService(IReverseRunControl.class);
        if (reverseService != null && (launch = (ILaunch)procCtx.getAdapter(ILaunch.class)) != null) {
            try {
                boolean reverseEnabled = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
                if (reverseEnabled) {
                    reverseService.enableReverseMode(this.fCommandControl.getContext(), true, rm);
                    return;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        rm.done();
    }

    protected boolean doCanDetachDebuggerFromProcess() {
        return this.fNumConnected > 0;
    }

    private boolean isExitedProcess(IDMContext dmc) {
        return DMContexts.getAncestorOfType((IDMContext)dmc, MIExitedProcessDMC.class) != null;
    }

    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        MIExitedProcessDMC exitedProc = (MIExitedProcessDMC)DMContexts.getAncestorOfType((IDMContext)dmc, MIExitedProcessDMC.class);
        if (exitedProc != null) {
            rm.done((Object)true);
            return;
        }
        rm.done((Object)this.doCanDetachDebuggerFromProcess());
    }

    public void detachDebuggerFromProcess(IDMContext dmc, RequestMonitor rm) {
        MIExitedProcessDMC exitedProc = (MIExitedProcessDMC)DMContexts.getAncestorOfType((IDMContext)dmc, MIExitedProcessDMC.class);
        if (exitedProc != null) {
            String groupId = exitedProc.getGroupId();
            this.getExitedProcesses().remove(groupId);
            this.removeProcessFromLaunch(groupId);
            this.getSession().dispatchEvent((Object)new ProcessRemovedDMEvent(exitedProc), null);
            return;
        }
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
        if (controlDmc != null && procDmc != null) {
            IMIContainerDMContext containerDmc;
            if (!this.doCanDetachDebuggerFromProcess()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Detach not supported.", null));
                rm.done();
                return;
            }
            IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
            if (runControl != null && !runControl.isTargetAcceptingCommands()) {
                this.fBackend.interrupt();
            }
            if ((containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class)) != null) {
                this.getDetachedProcesses().add(containerDmc.getGroupId());
            }
            this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetDetach(controlDmc, procDmc.getProcId()), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleFailure() {
                    if (containerDmc != null) {
                        GDBProcesses_7_0.this.getDetachedProcesses().remove(containerDmc.getGroupId());
                    }
                    super.handleFailure();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    public void canTerminate(IProcesses.IThreadDMContext thread, DataRequestMonitor<Boolean> rm) {
        if (thread instanceof MIExitedProcessDMC) {
            rm.setData((Object)true);
        } else {
            rm.setData((Object)true);
        }
        rm.done();
    }

    public void isDebugNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doIsDebugNewProcessSupported());
        rm.done();
    }

    protected boolean doIsDebugNewProcessSupported() {
        return false;
    }

    public void debugNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        boolean isInitial = this.isInitialProcess();
        if (this.isInitialProcess()) {
            this.setIsInitialProcess(false);
        } else if (!this.doIsDebugNewProcessSupported()) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Not allowed to create a new process", null));
            rm.done();
            return;
        }
        ImmediateExecutor.getInstance().execute((Runnable)this.getDebugNewProcessSequence(this.getExecutor(), isInitial, dmc, file, attributes, rm));
    }

    protected Sequence getDebugNewProcessSequence(DsfExecutor executor, boolean isInitial, IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        return new DebugNewProcessSequence(executor, isInitial, dmc, file, attributes, rm);
    }

    public void getProcessesBeingDebugged(IDMContext dmc, final DataRequestMonitor<IDMContext[]> rm) {
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        final IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        if (containerDmc != null) {
            if (this.isExitedProcess((IDMContext)containerDmc)) {
                rm.done((Object)new IMIExecutionDMContext[0]);
                return;
            }
            this.fThreadCommandCache.execute(this.fCommandFactory.createMIListThreadGroups(controlDmc, containerDmc.getGroupId()), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)GDBProcesses_7_0.this.makeExecutionDMCs(containerDmc, ((MIListThreadGroupsInfo)this.getData()).getThreadInfo().getThreadList()));
                    rm.done();
                }
            });
        } else {
            ImmediateDataRequestMonitor<IMIContainerDMContext[]> addExitedDRM = new ImmediateDataRequestMonitor<IMIContainerDMContext[]>(rm){

                protected void handleCompleted() {
                    ArrayList<IMIContainerDMContext> containerDmcs = new ArrayList<IMIContainerDMContext>(Arrays.asList((IMIContainerDMContext[])this.getData()));
                    ArrayList<Map.Entry<String, ExitedProcInfo>> entries = new ArrayList<Map.Entry<String, ExitedProcInfo>>(GDBProcesses_7_0.this.getExitedProcesses().entrySet());
                    int i = entries.size() - 1;
                    while (i >= 0) {
                        Map.Entry entry = (Map.Entry)entries.get(i);
                        String groupId = (String)entry.getKey();
                        String pid = ((ExitedProcInfo)entry.getValue()).getPid();
                        IProcesses.IProcessDMContext processDmc = GDBProcesses_7_0.this.createExitedProcessContext(controlDmc, pid, groupId);
                        containerDmcs.add(GDBProcesses_7_0.this.createContainerContext(processDmc, groupId));
                        --i;
                    }
                    rm.done((Object)((IDMContext[])containerDmcs.toArray(new IMIContainerDMContext[containerDmcs.size()])));
                }
            };
            this.fContainerCommandCache.execute(this.fCommandFactory.createMIListThreadGroups(controlDmc), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), (RequestMonitor)addExitedDRM, (DataRequestMonitor)addExitedDRM, controlDmc){
                private final /* synthetic */ DataRequestMonitor val$addExitedDRM;
                private final /* synthetic */ ICommandControlService.ICommandControlDMContext val$controlDmc;
                {
                    this.val$addExitedDRM = dataRequestMonitor;
                    this.val$controlDmc = iCommandControlDMContext;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    this.val$addExitedDRM.done((Object)GDBProcesses_7_0.this.makeContainerDMCs(this.val$controlDmc, ((MIListThreadGroupsInfo)this.getData()).getGroupList()));
                }

                protected void handleFailure() {
                    IMIContainerDMContext[] containerDmcs = new IMIContainerDMContext[GDBProcesses_7_0.this.getGroupToPidMap().size()];
                    int i = 0;
                    for (String groupId : GDBProcesses_7_0.this.getGroupToPidMap().keySet()) {
                        containerDmcs[i++] = GDBProcesses_7_0.this.createContainerContextFromGroupId(this.val$controlDmc, groupId);
                    }
                    this.val$addExitedDRM.done((Object)containerDmcs);
                }
            });
        }
    }

    private IRunControl.IExecutionDMContext[] makeExecutionDMCs(IRunControl.IContainerDMContext containerDmc, MIThread[] threadInfos) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
        if (threadInfos.length == 0) {
            return new IMIExecutionDMContext[]{this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, FAKE_THREAD_ID), FAKE_THREAD_ID)};
        }
        IRunControl.IExecutionDMContext[] executionDmcs = new IMIExecutionDMContext[threadInfos.length];
        int i = 0;
        while (i < threadInfos.length) {
            String threadId = threadInfos[i].getThreadId();
            executionDmcs[i] = this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, threadId), threadId);
            ++i;
        }
        return executionDmcs;
    }

    private IMIContainerDMContext[] makeContainerDMCs(ICommandControlService.ICommandControlDMContext controlDmc, MIListThreadGroupsInfo.IThreadGroupInfo[] groups) {
        if (groups.length == 0 && this.fBackend.getSessionType() == SessionType.CORE) {
            return new IMIContainerDMContext[]{this.createContainerContextFromGroupId(controlDmc, "")};
        }
        ArrayList<IMIContainerDMContext> containerDmcs = new ArrayList<IMIContainerDMContext>(groups.length);
        MIListThreadGroupsInfo.IThreadGroupInfo[] iThreadGroupInfoArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            MIListThreadGroupsInfo.IThreadGroupInfo group = iThreadGroupInfoArray[n2];
            if (group.getPid() != null && !group.getPid().isEmpty() && !group.getPid().equals(FAKE_THREAD_ID)) {
                String groupId = group.getGroupId();
                containerDmcs.add(this.createContainerContextFromGroupId(controlDmc, groupId));
            }
            ++n2;
        }
        return containerDmcs.toArray(new IMIContainerDMContext[containerDmcs.size()]);
    }

    public void getRunningProcesses(IDMContext dmc, final DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc != null) {
            this.fListThreadGroupsAvailableCache.execute(this.fCommandFactory.createMIListThreadGroups(controlDmc, true), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    GDBProcesses_7_0.this.fListThreadGroupsAvailableCache.reset();
                    if (this.isSuccess()) {
                        rm.setData((Object)GDBProcesses_7_0.this.makeProcessDMCAndData(controlDmc, ((MIListThreadGroupsInfo)this.getData()).getGroupList()));
                    } else if (GDBProcesses_7_0.this.fBackend.getSessionType() == SessionType.LOCAL) {
                        IProcessList list = null;
                        try {
                            list = CCorePlugin.getDefault().getProcessList();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        if (list == null) {
                            rm.setData((Object)new IProcesses.IProcessDMContext[0]);
                        } else {
                            IProcessInfo[] procInfos = list.getProcessList();
                            rm.setData((Object)GDBProcesses_7_0.this.makeProcessDMCAndData(controlDmc, procInfos));
                        }
                    } else {
                        rm.setData((Object)new IProcesses.IProcessDMContext[0]);
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    protected MIProcessDMCAndData[] makeProcessDMCAndData(ICommandControlService.ICommandControlDMContext controlDmc, IProcessInfo[] processes) {
        MIProcessDMCAndData[] procDmcs = new MIProcessDMCAndData[processes.length];
        int i = 0;
        while (i < procDmcs.length) {
            procDmcs[i] = new MIProcessDMCAndData(controlDmc.getSessionId(), controlDmc, Integer.toString(processes[i].getPid()), processes[i].getName(), null, null);
            ++i;
        }
        return procDmcs;
    }

    protected MIProcessDMCAndData[] makeProcessDMCAndData(ICommandControlService.ICommandControlDMContext controlDmc, MIListThreadGroupsInfo.IThreadGroupInfo[] processes) {
        MIProcessDMCAndData[] procDmcs = new MIProcessDMCAndData[processes.length];
        int i = 0;
        MIListThreadGroupsInfo.IThreadGroupInfo[] iThreadGroupInfoArray = processes;
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            MIListThreadGroupsInfo.IThreadGroupInfo process = iThreadGroupInfoArray[n2];
            procDmcs[i++] = new MIProcessDMCAndData(controlDmc.getSessionId(), controlDmc, process.getGroupId(), process.getName(), process.getCores(), process.getUser());
            ++n2;
        }
        return procDmcs;
    }

    public void isRunNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void runNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void terminate(IProcesses.IThreadDMContext thread, final RequestMonitor rm) {
        if (thread instanceof MIExitedProcessDMC) {
            String groupId = ((MIExitedProcessDMC)thread).getGroupId();
            this.getExitedProcesses().remove(groupId);
            this.removeProcessFromLaunch(groupId);
            this.getSession().dispatchEvent((Object)new ProcessRemovedDMEvent((IProcesses.IProcessDMContext)thread), null);
        } else if (this.fBackend.getSessionType() == SessionType.CORE) {
            this.fCommandControl.terminate(rm);
        } else if (thread instanceof IMIProcessDMContext) {
            this.getDebuggingContext(thread, (DataRequestMonitor<IDMContext>)new ImmediateDataRequestMonitor<IDMContext>(rm){

                protected void handleSuccess() {
                    if (this.getData() instanceof IMIContainerDMContext) {
                        IMIRunControl runControl = (IMIRunControl)GDBProcesses_7_0.this.getServicesTracker().getService(IMIRunControl.class);
                        if (runControl != null && !runControl.isTargetAcceptingCommands()) {
                            GDBProcesses_7_0.this.fBackend.interrupt();
                        }
                        GDBProcesses_7_0.this.fCommandControl.queueCommand(GDBProcesses_7_0.this.fCommandFactory.createMIInterpreterExecConsoleKill((IMIContainerDMContext)this.getData()), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
                        rm.done();
                    }
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    @Override
    public void canRestart(IRunControl.IContainerDMContext containerDmc, DataRequestMonitor<Boolean> rm) {
        if (this.fBackend.getIsAttachSession() || this.fBackend.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (this.fBackend.getSessionType() == SessionType.REMOTE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        rm.setData((Object)true);
        rm.done();
    }

    protected IMIContainerDMContext createContainerContextForRestart(String groupId) {
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(this.fCommandControl.getContext(), "");
        return this.createContainerContext(processDmc, "");
    }

    @Override
    public void restart(IRunControl.IContainerDMContext containerDmc, final Map<String, Object> attributes, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        final String groupId = ((IMIContainerDMContext)containerDmc).getGroupId();
        ImmediateRequestMonitor restartRm = new ImmediateRequestMonitor((RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0);
            }

            protected void handleSuccess() {
                IMIContainerDMContext newContainerDmc = GDBProcesses_7_0.this.createContainerContextForRestart(groupId);
                GDBProcesses_7_0.this.startOrRestart(newContainerDmc, attributes, true, (DataRequestMonitor<IRunControl.IContainerDMContext>)new ImmediateDataRequestMonitor<IRunControl.IContainerDMContext>((RequestMonitor)this.val$rm){

                    protected void handleCompleted() {
                        GDBProcesses_7_0.this.getExitedProcesses().remove(groupId);
                        this.setData((IRunControl.IContainerDMContext)this.getData());
                        super.handleCompleted();
                    }
                });
            }
        };
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        if (runControl != null && !runControl.isSuspended((IRunControl.IExecutionDMContext)containerDmc)) {
            runControl.suspend((IRunControl.IExecutionDMContext)containerDmc, (RequestMonitor)restartRm);
        } else {
            restartRm.done();
        }
    }

    @Override
    public void start(IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        this.startOrRestart(containerDmc, attributes, false, rm);
    }

    protected void startOrRestart(IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        ImmediateExecutor.getInstance().execute((Runnable)this.getStartOrRestartProcessSequence(this.getExecutor(), containerDmc, attributes, restart, rm));
    }

    protected Sequence getStartOrRestartProcessSequence(DsfExecutor executor, IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        return new StartOrRestartProcessSequence_7_0(executor, containerDmc, attributes, restart, rm);
    }

    private String removeProcessFromLaunch(String groupId) {
        IProcess[] launchProcesses;
        ILaunch launch = (ILaunch)this.getSession().getModelAdapter(ILaunch.class);
        IProcess[] iProcessArray = launchProcesses = launch.getProcesses();
        int n = launchProcesses.length;
        int n2 = 0;
        while (n2 < n) {
            String groupAttribute;
            IProcess process = iProcessArray[n2];
            if (process instanceof InferiorRuntimeProcess && ((groupAttribute = process.getAttribute("org.eclipse.cdt.dsf.gdb.inferiorGroupId")) == null || groupAttribute.equals("") || groupAttribute.equals(groupId))) {
                launch.removeProcess(process);
                return process.getLabel();
            }
            ++n2;
        }
        return null;
    }

    private void addProcessToLaunch(final Process inferior, final String groupId, final String label) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ILaunch launch = (ILaunch)GDBProcesses_7_0.this.getSession().getModelAdapter(ILaunch.class);
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.inferiorProcess");
                IProcess runtimeInferior = DebugPlugin.newProcess((ILaunch)launch, (Process)inferior, (String)(label != null ? label : ""), attributes);
                runtimeInferior.setAttribute("org.eclipse.cdt.dsf.gdb.inferiorGroupId", groupId);
            }
        });
    }

    @Override
    public void addInferiorToLaunch(IRunControl.IContainerDMContext containerDmc, String label, PTY pty, RequestMonitor rm) {
        if (containerDmc instanceof IMIContainerDMContext) {
            MIInferiorProcess inferiorProcess;
            String groupId = ((IMIContainerDMContext)containerDmc).getGroupId();
            if (pty == null) {
                inferiorProcess = this.createInferiorProcess(containerDmc, this.fBackend.getMIOutputStream());
            } else {
                this.fGroupIdToPTYMap.put(groupId, pty);
                inferiorProcess = this.createInferiorProcess(containerDmc, pty);
            }
            this.addProcessToLaunch(inferiorProcess, groupId, label);
        }
        rm.done();
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupCreatedEvent e) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)e.getDMContext();
        IMIContainerDMContext containerDmc = e.getGroupId() != null ? this.createContainerContext(procDmc, e.getGroupId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerStartedDMEvent(containerDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupExitedEvent e) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)e.getDMContext();
        IMIContainerDMContext containerDmc = e.getGroupId() != null ? this.createContainerContext(procDmc, e.getGroupId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerExitedDMEvent(containerDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fContainerCommandCache.setContextAvailable(e.getDMContext(), false);
            this.fThreadCommandCache.setContextAvailable(e.getDMContext(), false);
            this.fListThreadGroupsAvailableCache.setContextAvailable(e.getDMContext(), false);
        }
    }

    protected MIInferiorProcess createInferiorProcess(IRunControl.IContainerDMContext container, OutputStream outputStream) {
        return new MIInferiorProcess(container, outputStream);
    }

    protected MIInferiorProcess createInferiorProcess(IRunControl.IContainerDMContext container, PTY pty) {
        return new MIInferiorProcess(container, pty);
    }

    private void handleRestartingProcess(IMIContainerDMContext containerDmc) {
        String label = this.removeProcessFromLaunch(containerDmc.getGroupId());
        if (label != null) {
            this.addInferiorToLaunch(containerDmc, label, this.fGroupIdToPTYMap.get(containerDmc.getGroupId()), (RequestMonitor)new ImmediateRequestMonitor());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
            this.fThreadCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
            this.fListThreadGroupsAvailableCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        }
        try {
            if (this.fBackend.getUpdateThreadListOnSuspend()) {
                ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), ICommandControlService.ICommandControlDMContext.class);
                this.fThreadCommandCache.reset((IDMContext)controlDmc);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        if (e.getDMContext() instanceof IMIContainerDMContext) {
            String groupId = ((IMIContainerDMContext)e.getDMContext()).getGroupId();
            if (this.fExitedGroupId.remove(groupId)) {
                this.handleRestartingProcess((IMIContainerDMContext)e.getDMContext());
            }
            this.fContainerCommandCache.reset();
            ++this.fNumConnected;
        } else {
            this.fThreadCommandCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e.getDMContext() instanceof IMIContainerDMContext) {
            this.fExitedGroupId.add(((IMIContainerDMContext)e.getDMContext()).getGroupId());
            this.fContainerCommandCache.reset();
            assert (this.fNumConnected > 0);
            --this.fNumConnected;
            if (this.fNumConnected == 0 && Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb", "autoTerminateGdb", true, null)) {
                this.getExecutor().schedule((Runnable)new DsfRunnable(){

                    public void run() {
                        if (GDBProcesses_7_0.this.fNumConnected == 0) {
                            GDBProcesses_7_0.this.fCommandControl.terminate((RequestMonitor)new ImmediateRequestMonitor());
                        }
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            }
        } else {
            this.fThreadCommandCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        for (PTY pty : this.fGroupIdToPTYMap.values()) {
            if (!(pty instanceof PersistentPTY)) continue;
            try {
                ((PersistentPTY)pty).closeStreams();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fGroupIdToPTYMap.clear();
        this.fExitedGroupId.clear();
    }

    public void flushCache(IDMContext context) {
        this.fContainerCommandCache.reset(context);
        this.fThreadCommandCache.reset(context);
        this.fListThreadGroupsAvailableCache.reset(context);
    }

    public void eventReceived(Object output) {
        MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
        int n = mIOOBRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIOOBRecord oobr = mIOOBRecordArray[n2];
            if (oobr instanceof MINotifyAsyncOutput) {
                String groupId;
                MIValue val;
                String var;
                MINotifyAsyncOutput exec = (MINotifyAsyncOutput)oobr;
                String miEvent = exec.getAsyncClass();
                if ("thread-created".equals(miEvent) || "thread-exited".equals(miEvent)) {
                    String threadId = null;
                    String groupId2 = null;
                    MIResult[] results = exec.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        var = results[i].getVariable();
                        val = results[i].getMIValue();
                        if (var.equals("group-id")) {
                            if (val instanceof MIConst) {
                                groupId2 = ((MIConst)val).getString();
                            }
                        } else if (var.equals("id") && val instanceof MIConst) {
                            threadId = ((MIConst)val).getString();
                        }
                        ++i;
                    }
                    if ("thread-created".equals(miEvent)) {
                        this.getThreadToGroupMap().put(threadId, groupId2);
                    } else {
                        this.getThreadToGroupMap().remove(threadId);
                    }
                } else if ("thread-group-created".equals(miEvent) || "thread-group-started".equals(miEvent)) {
                    groupId = null;
                    String pId = null;
                    MIResult[] results = exec.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        var = results[i].getVariable();
                        val = results[i].getMIValue();
                        if (var.equals("id")) {
                            if (val instanceof MIConst) {
                                groupId = ((MIConst)val).getString().trim();
                            }
                        } else if (var.equals("pid") && val instanceof MIConst) {
                            pId = ((MIConst)val).getString().trim();
                        }
                        ++i;
                    }
                    if (pId == null) {
                        pId = groupId;
                    }
                    if (groupId != null) {
                        this.getExitedProcesses().remove(groupId);
                        this.getGroupToPidMap().put(groupId, pId);
                        this.fDebuggedProcessesAndNames.put(pId, "");
                    }
                } else if ("thread-group-exited".equals(miEvent)) {
                    groupId = null;
                    MIResult[] results = exec.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        String var2 = results[i].getVariable();
                        MIValue val2 = results[i].getMIValue();
                        if (var2.equals("id") && val2 instanceof MIConst) {
                            groupId = ((MIConst)val2).getString().trim();
                        }
                        ++i;
                    }
                    if (groupId != null) {
                        String pId = this.getGroupToPidMap().remove(groupId);
                        String name = this.fDebuggedProcessesAndNames.remove(pId);
                        if (!this.getDetachedProcesses().remove(groupId)) {
                            this.getExitedProcesses().put(groupId, new ExitedProcInfo(pId, name));
                        }
                        if (this.getThreadToGroupMap().containsValue(groupId)) {
                            Iterator<Map.Entry<String, String>> iterator = this.getThreadToGroupMap().entrySet().iterator();
                            while (iterator.hasNext()) {
                                if (!iterator.next().getValue().equals(groupId)) continue;
                                iterator.remove();
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    static /* synthetic */ Map access$2(GDBProcesses_7_0 gDBProcesses_7_0) {
        return gDBProcesses_7_0.fDebuggedProcessesAndNames;
    }

    public static class ContainerExitedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IExitedDMEvent {
        public ContainerExitedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    public static class ContainerStartedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IStartedDMEvent {
        public ContainerStartedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    protected class ExitedProcInfo {
        private String pid;
        private String name;
        private Integer exitCode;

        public ExitedProcInfo(String aPid, String aName) {
            this.pid = aPid;
            this.name = aName;
        }

        protected String getPid() {
            return this.pid;
        }

        protected String getName() {
            return this.name;
        }

        protected Integer getExitCode() {
            return this.exitCode;
        }

        protected void setExitCode(Integer code) {
            this.exitCode = code;
        }
    }

    private static class GDBContainerDMC
    extends MIContainerDMC
    implements IMemory.IMemoryDMContext,
    IBreakpoints.IBreakpointsTargetDMContext {
        public GDBContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            super(sessionId, processDmc, groupId);
        }
    }

    private class LRUExitedProcessMap
    extends LinkedHashMap<String, ExitedProcInfo> {
        public static final long serialVersionUID = 0L;

        private LRUExitedProcessMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ExitedProcInfo> eldest) {
            return this.size() > 5;
        }
    }

    @Immutable
    static class MIContainerDMC
    extends AbstractDMContext
    implements IMIContainerDMContext,
    IDisassembly.IDisassemblyDMContext {
        private final String fId;

        public MIContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = groupId;
        }

        @Override
        public String getGroupId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".threadGroup[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && (((MIContainerDMC)obj).fId == null ? this.fId == null : ((MIContainerDMC)obj).fId.equals(this.fId));
        }

        public int hashCode() {
            return this.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    private static class MIExecutionDMC
    extends AbstractDMContext
    implements IMIExecutionDMContext,
    IDisassembly.IDisassemblyDMContext {
        private final String fThreadId;

        protected MIExecutionDMC(String sessionId, IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
            IDMContext[] iDMContextArray;
            if (containerDmc == null && threadDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else if (containerDmc == null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = threadDmc;
            } else if (threadDmc == null) {
                IDMContext[] iDMContextArray3 = new IDMContext[1];
                iDMContextArray = iDMContextArray3;
                iDMContextArray3[0] = containerDmc;
            } else {
                IDMContext[] iDMContextArray4 = new IDMContext[2];
                iDMContextArray4[0] = containerDmc;
                iDMContextArray = iDMContextArray4;
                iDMContextArray4[1] = threadDmc;
            }
            super(sessionId, iDMContextArray);
            this.fThreadId = threadId;
        }

        @Override
        public String getThreadId() {
            return this.fThreadId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".thread[" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && ((MIExecutionDMC)obj).fThreadId.equals(this.fThreadId);
        }

        public int hashCode() {
            return this.baseHashCode() ^ this.fThreadId.hashCode();
        }
    }

    @Immutable
    protected static class MIExitedProcessDMC
    extends MIProcessDMC {
        private final String fGroupId;

        public MIExitedProcessDMC(String sessionId, ICommandControlService.ICommandControlDMContext controlDmc, String pid, String groupId) {
            super(sessionId, controlDmc, pid);
            this.fGroupId = groupId;
        }

        public String getGroupId() {
            return this.fGroupId;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ".group[" + this.getGroupId() + "]";
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            MIExitedProcessDMC other = (MIExitedProcessDMC)obj;
            if (this.fGroupId == null || other.fGroupId == null) {
                return this.fGroupId == null && other.fGroupId == null;
            }
            return this.fGroupId.equals(other.fGroupId);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (this.fGroupId == null ? 0 : this.fGroupId.hashCode());
        }
    }

    @Immutable
    protected static class MIExitedProcessDMData
    implements IGDBProcesses.IGdbThreadExitedDMData {
        final String fName;
        final String fId;
        final Integer fExitCode;

        public MIExitedProcessDMData(String name, String id, Integer exitCode) {
            this.fName = name;
            this.fId = id;
            this.fExitCode = exitCode;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return false;
        }

        @Override
        public Integer getExitCode() {
            return this.fExitCode;
        }
    }

    @Immutable
    private static class MIProcessDMC
    extends AbstractDMContext
    implements IMIProcessDMContext {
        private final String fId;

        public MIProcessDMC(String sessionId, ICommandControlService.ICommandControlDMContext controlDmc, String id) {
            IDMContext[] iDMContextArray;
            if (controlDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = controlDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        @Override
        public String getProcId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".proc[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            if (!this.baseEquals(obj)) {
                return false;
            }
            MIProcessDMC other = (MIProcessDMC)obj;
            if (this.fId == null || other.fId == null) {
                return this.fId == null && other.fId == null;
            }
            if (this.fId.equals("") || other.fId.equals("")) {
                return true;
            }
            return this.fId.equals(other.fId);
        }

        public int hashCode() {
            return this.baseHashCode();
        }
    }

    @Immutable
    protected static class MIProcessDMCAndData
    extends MIProcessDMC
    implements IGDBProcesses.IGdbThreadDMData {
        final String fName;
        final String[] fCores;
        final String fOwner;

        public MIProcessDMCAndData(String sessionId, ICommandControlService.ICommandControlDMContext controlDmc, String id, String name, String[] cores, String owner) {
            super(sessionId, controlDmc, id);
            this.fName = name;
            this.fCores = cores;
            this.fOwner = owner;
        }

        public String getId() {
            return this.getProcId();
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }

        @Override
        public String[] getCores() {
            return this.fCores;
        }

        @Override
        public String getOwner() {
            return this.fOwner;
        }

        @Override
        public String toString() {
            return String.valueOf(this.baseToString()) + ".proc[" + this.getId() + "," + this.getName() + "," + this.getOwner() + "]";
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && (((MIProcessDMCAndData)obj).fName == null ? this.fName == null : ((MIProcessDMCAndData)obj).fName.equals(this.fName)) && (((MIProcessDMCAndData)obj).fOwner == null ? this.fOwner == null : ((MIProcessDMCAndData)obj).fOwner.equals(this.fOwner));
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (this.fName == null ? 0 : this.fName.hashCode()) ^ (this.fOwner == null ? 0 : this.fOwner.hashCode());
        }
    }

    @Immutable
    protected static class MIThreadDMC
    extends AbstractDMContext
    implements IProcesses.IThreadDMContext {
        private final String fId;

        public MIThreadDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String id) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".OSthread[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && (((MIThreadDMC)((Object)obj)).fId == null ? this.fId == null : ((MIThreadDMC)((Object)obj)).fId.equals(this.fId));
        }

        public int hashCode() {
            return this.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    protected static class MIThreadDMData
    implements IProcesses.IThreadDMData {
        final String fName;
        final String fId;

        public MIThreadDMData(String name, String id) {
            this.fName = name;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }

    protected static class ProcessRemovedDMEvent
    extends AbstractDMEvent<IProcesses.IThreadDMContext>
    implements IGDBProcesses.IThreadRemovedDMEvent {
        public ProcessRemovedDMEvent(IProcesses.IProcessDMContext context) {
            super((IDMContext)context);
        }
    }
}

