/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class SubdirectoryOrSameNameSchedulingRule
implements ISchedulingRule {
    private File directory;

    public SubdirectoryOrSameNameSchedulingRule(File directory) {
        this.directory = directory;
    }

    public SubdirectoryOrSameNameSchedulingRule(IResource resource) {
        this(resource.getLocation().toFile());
    }

    public boolean contains(ISchedulingRule rule) {
        if (rule == this || rule instanceof IResource) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] iSchedulingRuleArray = ((MultiRule)rule).getChildren();
            int n = iSchedulingRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISchedulingRule child = iSchedulingRuleArray[n2];
                if (this.contains(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule instanceof SubdirectoryOrSameNameSchedulingRule) {
            SubdirectoryOrSameNameSchedulingRule otherRule = (SubdirectoryOrSameNameSchedulingRule)rule;
            return otherRule.directory.getAbsolutePath().startsWith(this.directory.getAbsolutePath()) || otherRule.directory.getName().equals(this.directory.getName());
        }
        if (rule instanceof IResource) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] iSchedulingRuleArray = ((MultiRule)rule).getChildren();
            int n = iSchedulingRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISchedulingRule child = iSchedulingRuleArray[n2];
                if (this.isConflicting(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

