/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.wizards.classwizard.AbstractMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.core.runtime.CoreException;

public final class DestructorMethodStub
extends AbstractMethodStub {
    private static String NAME = NewClassWizardMessages.NewClassCodeGeneration_stub_destructor_name;

    public DestructorMethodStub() {
        this(ASTAccessVisibility.PUBLIC, true, false);
    }

    public DestructorMethodStub(ASTAccessVisibility access, boolean isVirtual, boolean isInline) {
        super(NAME, access, isVirtual, isInline);
    }

    @Override
    public String createMethodDeclaration(ITranslationUnit tu, String className, IBaseClassInfo[] baseClasses, String lineDelimiter) throws CoreException {
        StringBuilder buf = new StringBuilder();
        if (this.fIsVirtual) {
            buf.append("virtual ");
        }
        buf.append("~");
        buf.append(className);
        buf.append("()");
        if (this.fIsInline) {
            buf.append('{');
            buf.append(lineDelimiter);
            String body = CodeGeneration.getDestructorBodyContent(tu, className, null, lineDelimiter);
            if (body != null) {
                buf.append(body);
                buf.append(lineDelimiter);
            }
            buf.append('}');
        } else {
            buf.append(";");
        }
        return buf.toString();
    }

    @Override
    public String createMethodImplementation(ITranslationUnit tu, String className, IBaseClassInfo[] baseClasses, String lineDelimiter) throws CoreException {
        if (this.fIsInline) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(className);
        buf.append("::~");
        buf.append(className);
        buf.append("()");
        buf.append(lineDelimiter);
        buf.append('{');
        buf.append(lineDelimiter);
        String body = CodeGeneration.getDestructorBodyContent(tu, className, null, lineDelimiter);
        if (body != null) {
            buf.append(body);
            buf.append(lineDelimiter);
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public boolean isDestructor() {
        return true;
    }
}

